/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.testscenarios.executors;

import java.io.Serializable;
import java.util.HashMap;
import org.drools.Cheesery;
import org.drools.ide.common.client.modeldriven.testing.CallFieldValue;
import org.drools.ide.common.client.modeldriven.testing.CallMethod;
import org.drools.ide.common.server.testscenarios.executors.MethodExecutor;
import org.junit.Assert;
import org.junit.Test;

public class MethodExecutorTest {
    @Test
    public void testCallMethodNoArgumentOnFact() throws Exception {
        HashMap<String, Cheesery> populatedData = new HashMap<String, Cheesery>();
        MethodExecutor methodExecutor = new MethodExecutor(populatedData);
        Cheesery listChesse = new Cheesery();
        listChesse.setTotalAmount(1000);
        populatedData.put("cheese", listChesse);
        CallMethod mCall = new CallMethod();
        mCall.setVariable("cheese");
        mCall.setMethodName("setTotalAmountToZero");
        methodExecutor.executeMethod(mCall);
        Assert.assertTrue((listChesse.getTotalAmount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCallMethodOnStandardArgumentOnFact() throws Exception {
        HashMap<String, Cheesery> populatedData = new HashMap<String, Cheesery>();
        MethodExecutor methodExecutor = new MethodExecutor(populatedData);
        Cheesery listChesse = new Cheesery();
        listChesse.setTotalAmount(1000);
        populatedData.put("cheese", listChesse);
        CallMethod mCall = new CallMethod();
        mCall.setVariable("cheese");
        mCall.setMethodName("addToTotalAmount");
        CallFieldValue field = new CallFieldValue();
        field.value = "5";
        mCall.addFieldValue(field);
        methodExecutor.executeMethod(mCall);
        Assert.assertTrue((listChesse.getTotalAmount() == 1005 ? 1 : 0) != 0);
    }

    @Test
    public void testCallMethodOnClassArgumentOnFact() throws Exception {
        HashMap<String, Serializable> populatedData = new HashMap<String, Serializable>();
        MethodExecutor methodExecutor = new MethodExecutor(populatedData);
        Cheesery listChesse = new Cheesery();
        listChesse.setTotalAmount(1000);
        populatedData.put("cheese", listChesse);
        Cheesery.Maturity m = new Cheesery.Maturity();
        populatedData.put("m", m);
        CallMethod mCall = new CallMethod();
        mCall.setVariable("cheese");
        mCall.setMethodName("setGoodMaturity");
        CallFieldValue field = new CallFieldValue();
        field.value = "=m";
        mCall.addFieldValue(field);
        methodExecutor.executeMethod(mCall);
        Assert.assertTrue((boolean)listChesse.getMaturity().equals(m));
        Assert.assertTrue((listChesse.getMaturity() == m ? 1 : 0) != 0);
    }

    @Test
    public void testCallMethodOnClassArgumentAndOnArgumentStandardOnFact() throws Exception {
        HashMap<String, Serializable> populatedData = new HashMap<String, Serializable>();
        MethodExecutor methodExecutor = new MethodExecutor(populatedData);
        Cheesery listChesse = new Cheesery();
        listChesse.setTotalAmount(1000);
        populatedData.put("cheese", listChesse);
        Cheesery.Maturity m = new Cheesery.Maturity("veryYoung");
        populatedData.put("m", m);
        CallMethod mCall = new CallMethod();
        mCall.setVariable("cheese");
        mCall.setMethodName("setAgeToMaturity");
        CallFieldValue field = new CallFieldValue();
        field.value = "=m";
        mCall.addFieldValue(field);
        CallFieldValue field2 = new CallFieldValue();
        field2.value = "veryold";
        mCall.addFieldValue(field2);
        methodExecutor.executeMethod(mCall);
        Assert.assertTrue((boolean)m.getAge().equals("veryold"));
    }
}

