/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.assistant;

import org.drools.ide.common.assistant.refactor.drl.VariableBinding;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VariableBindingTest {
    private String line;
    private String response;

    @Before
    public void setUp() throws Exception {
        this.line = "\tEmployee($company : company, $age : age > 80, salary > 400)";
    }

    @Test
    public void testFieldWithVariableAssignedTest1() {
        this.response = VariableBinding.execute((String)this.line, (int)24);
        Assert.assertEquals((Object)true, (Object)this.response.equals(this.line));
    }

    @Test
    public void testClassNameWithoutVariableAssigned() {
        this.response = VariableBinding.execute((String)this.line, (int)4);
        Assert.assertEquals((Object)false, (Object)this.response.equals(this.line));
    }

    @Test
    public void testFieldWithVariableAssignedTest2() {
        this.response = VariableBinding.execute((String)this.line, (int)39);
        Assert.assertEquals((Object)true, (Object)this.response.equals(this.line));
    }

    @Test
    public void testAssignVariableInsideTheComparator() {
        this.response = VariableBinding.execute((String)this.line, (int)50);
        Assert.assertEquals((Object)false, (Object)this.response.equals(this.line));
    }

    @Test
    public void testInsideFieldComparator() {
        this.response = VariableBinding.execute((String)this.line, (int)58);
        Assert.assertEquals((Object)true, (Object)this.response.equals(this.line));
    }

    @Test
    public void testComplexLineTestMustAssign() {
        this.line = "$ma20 : Double() from accumulate( $r2:ClosePrice(close, this != $r1, this after [0ms,20ms] $r1) , average ( $value ))";
        this.response = VariableBinding.execute((String)this.line, (int)53);
        Assert.assertEquals((Object)false, (Object)this.response.equals(this.line));
    }

    @Test
    public void testComplexLineTestDontMustAssign() {
        this.line = "$ma20 : Double() from accumulate( $r2:ClosePrice($close : close, this != $r1, this after [0ms,20ms] $r1) , average ( $value ))";
        this.response = VariableBinding.execute((String)this.line, (int)61);
        Assert.assertEquals((Object)true, (Object)this.response.equals(this.line));
    }

    @Test
    public void testComplexLineClosePriceMustAssign() {
        this.line = "$ma20 : Double() from accumulate( ClosePrice($close : close, this != $r1, this after [0ms,20ms] $r1) , average ( $value ))";
        this.response = VariableBinding.execute((String)this.line, (int)43);
        Assert.assertEquals((Object)false, (Object)this.response.equals(this.line));
    }

    @Test
    public void testComplexLineClosePriceDontMustAssign() {
        this.line = "$ma20 : Double() from accumulate( $cp : ClosePrice($close : close, this != $r1, this after [0ms,20ms] $r1) , average ( $value ))";
        this.response = VariableBinding.execute((String)this.line, (int)36);
        Assert.assertEquals((Object)true, (Object)this.response.equals(this.line));
    }

    @Test
    public void testSampleDRL() {
        this.line = "\t\tMessage( status == Message.HELLO, myMessage : message )\n";
        this.response = VariableBinding.execute((String)this.line, (int)3);
        Assert.assertEquals((Object)false, (Object)this.response.equals(this.line));
    }

    @Test
    public void testWithoutSpacesOrTab() {
        this.line = "Message( status == Message.HELLO, myMessage : message )\n";
        this.response = VariableBinding.execute((String)this.line, (int)0);
        Assert.assertEquals((Object)false, (Object)this.response.equals(this.line));
    }

    @Test
    public void testWithoutSpacesOrTabButWithVariableAssigned() {
        this.line = "m : Message( status == Message.HELLO, myMessage : message )\n";
        this.response = VariableBinding.execute((String)this.line, (int)1);
        Assert.assertEquals((Object)true, (Object)this.response.equals(this.line));
    }

    @Test
    public void testWithoutSpaceOnLeftOfField() {
        this.line = "m : Message( status == Message.HELLO,message )\n";
        this.response = VariableBinding.execute((String)this.line, (int)37);
        Assert.assertEquals((Object)false, (Object)this.response.equals(this.line));
    }
}

