/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.testscenarios.populators;

import java.io.Serializable;
import java.util.Map;
import org.drools.base.TypeResolver;
import org.drools.ide.common.server.testscenarios.populators.FieldPopulator;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;

public class EnumFieldPopulator
extends FieldPopulator {
    private final String fieldValue;
    private final TypeResolver typeResolver;
    private final ParserConfiguration pconf;
    private final ParserContext pctx;

    public EnumFieldPopulator(Object factObject, String fieldName, String fieldValue, TypeResolver typeResolver, ClassLoader classLoader) {
        super(factObject, fieldName);
        this.typeResolver = typeResolver;
        this.fieldValue = fieldValue;
        this.pconf = new ParserConfiguration();
        this.pconf.setClassLoader(classLoader);
        this.pctx = new ParserContext(this.pconf);
        this.pctx.setStrongTyping(true);
    }

    @Override
    public void populate(Map<String, Object> populatedData) {
        Object value;
        String valueOfEnum = "";
        if (this.fieldValue.indexOf(".") != -1) {
            String classNameOfEnum = this.fieldValue.substring(0, this.fieldValue.lastIndexOf("."));
            valueOfEnum = this.fieldValue.substring(this.fieldValue.lastIndexOf(".") + 1);
            try {
                String fullName = this.typeResolver.getFullTypeName(classNameOfEnum);
                if (fullName != null && !"".equals(fullName)) {
                    valueOfEnum = fullName + "." + valueOfEnum;
                }
                Serializable compiled = MVEL.compileExpression((String)valueOfEnum, (ParserContext)this.pctx);
                value = MVEL.executeExpression((Object)compiled);
            }
            catch (ClassNotFoundException e) {
                String fullName = classNameOfEnum;
                if (fullName != null && !"".equals(fullName)) {
                    valueOfEnum = fullName + "." + valueOfEnum;
                }
                value = valueOfEnum;
            }
        } else {
            value = this.fieldValue;
        }
        this.populateField(value, populatedData);
    }
}

