/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven.brl.templates;

import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;
import org.drools.ide.common.client.modeldriven.brl.CEPWindow;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.DSLVariableValue;
import org.drools.ide.common.client.modeldriven.brl.ExpressionFormLine;
import org.drools.ide.common.client.modeldriven.brl.ExpressionPart;
import org.drools.ide.common.client.modeldriven.brl.ExpressionText;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.brl.FromAccumulateCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCollectCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleAttribute;
import org.drools.ide.common.client.modeldriven.brl.RuleMetadata;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraintEBLeftSide;
import org.drools.ide.common.client.modeldriven.brl.templates.RuleModelCloneVisitor;
import org.junit.Assert;
import org.junit.Test;

public class RuleModelCloneVisitorTests {
    @Test
    public void testRuleModel() {
        RuleModel model = new RuleModel();
        model.modelVersion = "1";
        model.name = "ruleModelName";
        model.parentName = "ruleModelParentName";
        RuleModelCloneVisitor cloneVisitor = new RuleModelCloneVisitor();
        RuleModel clone = cloneVisitor.visitRuleModel(model);
        Assert.assertNotSame((Object)model, (Object)clone);
        Assert.assertEquals((Object)"1", (Object)clone.modelVersion);
        Assert.assertEquals((Object)"ruleModelName", (Object)clone.name);
        Assert.assertEquals((Object)"ruleModelParentName", (Object)clone.parentName);
    }

    @Test
    public void testRuleAttributes() {
        RuleModel model = new RuleModel();
        model.attributes = new RuleAttribute[2];
        model.attributes[0] = new RuleAttribute("attr0", "attr0Value");
        model.attributes[1] = new RuleAttribute("attr1", "attr1Value");
        RuleModelCloneVisitor cloneVisitor = new RuleModelCloneVisitor();
        RuleModel clone = cloneVisitor.visitRuleModel(model);
        Assert.assertEquals((long)2L, (long)clone.attributes.length);
        Assert.assertNotSame((Object)model.attributes[0], (Object)clone.attributes[0]);
        Assert.assertEquals((Object)"attr0", (Object)clone.attributes[0].attributeName);
        Assert.assertEquals((Object)"attr0Value", (Object)clone.attributes[0].value);
        Assert.assertNotSame((Object)model.attributes[1], (Object)clone.attributes[1]);
        Assert.assertEquals((Object)"attr1", (Object)clone.attributes[1].attributeName);
        Assert.assertEquals((Object)"attr1Value", (Object)clone.attributes[1].value);
    }

    @Test
    public void testRuleMetadata() {
        RuleModel model = new RuleModel();
        model.metadataList = new RuleMetadata[2];
        model.metadataList[0] = new RuleMetadata("md0", "md0Value");
        model.metadataList[1] = new RuleMetadata("md1", "md1Value");
        RuleModelCloneVisitor cloneVisitor = new RuleModelCloneVisitor();
        RuleModel clone = cloneVisitor.visitRuleModel(model);
        Assert.assertEquals((long)2L, (long)clone.metadataList.length);
        Assert.assertNotSame((Object)model.metadataList[0], (Object)clone.metadataList[0]);
        Assert.assertEquals((Object)"md0", (Object)clone.metadataList[0].attributeName);
        Assert.assertEquals((Object)"md0Value", (Object)clone.metadataList[0].value);
        Assert.assertNotSame((Object)model.metadataList[1], (Object)clone.metadataList[1]);
        Assert.assertEquals((Object)"md1", (Object)clone.metadataList[1].attributeName);
        Assert.assertEquals((Object)"md1Value", (Object)clone.metadataList[1].value);
    }

    @Test
    public void testActionInsertFact() {
        RuleModel model = new RuleModel();
        model.rhs = new IAction[2];
        ActionInsertFact aif0 = new ActionInsertFact("AIF0");
        aif0.setBoundName("$t0");
        ActionFieldValue aif0f0 = new ActionFieldValue("AIF0F0", "AIF0F0Value", "String");
        aif0f0.setNature(1L);
        aif0.addFieldValue(aif0f0);
        ActionFieldValue aif0f1 = new ActionFieldValue("AIF0F1", "AIF0F1Value", "String");
        aif0f1.setNature(1L);
        aif0.addFieldValue(aif0f1);
        model.rhs[0] = aif0;
        ActionInsertFact aif1 = new ActionInsertFact("AIF1");
        aif1.setBoundName("$t1");
        ActionFieldValue aif1f0 = new ActionFieldValue("AIF1F0", "AIF1F0Value", "String");
        aif1f0.setNature(1L);
        aif1.addFieldValue(aif1f0);
        ActionFieldValue aif1f1 = new ActionFieldValue("AIF1F1", "AIF1F1Value", "String");
        aif1f1.setNature(1L);
        aif1.addFieldValue(aif1f1);
        model.rhs[1] = aif1;
        RuleModelCloneVisitor cloneVisitor = new RuleModelCloneVisitor();
        RuleModel clone = cloneVisitor.visitRuleModel(model);
        Assert.assertEquals((long)2L, (long)clone.rhs.length);
        Assert.assertNotSame((Object)model.rhs[0], (Object)clone.rhs[0]);
        Assert.assertNotNull((Object)clone.rhs[0]);
        Assert.assertTrue((boolean)(clone.rhs[0] instanceof ActionInsertFact));
        ActionInsertFact aif0Clone = (ActionInsertFact)clone.rhs[0];
        Assert.assertEquals((Object)"AIF0", (Object)aif0Clone.factType);
        Assert.assertEquals((Object)"$t0", (Object)aif0Clone.getBoundName());
        Assert.assertEquals((long)2L, (long)aif0Clone.fieldValues.length);
        Assert.assertNotSame((Object)aif0.fieldValues[0], (Object)aif0Clone.fieldValues[0]);
        Assert.assertNotNull((Object)aif0Clone.fieldValues[0]);
        Assert.assertTrue((boolean)(aif0Clone.fieldValues[0] instanceof ActionFieldValue));
        ActionFieldValue aif0f0Clone = aif0Clone.fieldValues[0];
        Assert.assertEquals((Object)aif0f0.field, (Object)aif0f0Clone.field);
        Assert.assertEquals((long)aif0f0.nature, (long)aif0f0Clone.nature);
        Assert.assertEquals((Object)aif0f0.type, (Object)aif0f0Clone.type);
        Assert.assertEquals((Object)aif0f0.value, (Object)aif0f0Clone.value);
        Assert.assertNotSame((Object)aif0.fieldValues[1], (Object)aif0Clone.fieldValues[1]);
        Assert.assertNotNull((Object)aif0Clone.fieldValues[1]);
        Assert.assertTrue((boolean)(aif0Clone.fieldValues[1] instanceof ActionFieldValue));
        ActionFieldValue aif0f1Clone = aif0Clone.fieldValues[1];
        Assert.assertEquals((Object)aif0f1.field, (Object)aif0f1Clone.field);
        Assert.assertEquals((long)aif0f1.nature, (long)aif0f1Clone.nature);
        Assert.assertEquals((Object)aif0f1.type, (Object)aif0f1Clone.type);
        Assert.assertEquals((Object)aif0f1.value, (Object)aif0f1Clone.value);
        Assert.assertNotSame((Object)model.rhs[1], (Object)clone.rhs[1]);
        Assert.assertNotNull((Object)clone.rhs[1]);
        Assert.assertTrue((boolean)(clone.rhs[1] instanceof ActionInsertFact));
        ActionInsertFact aif1Clone = (ActionInsertFact)clone.rhs[1];
        Assert.assertEquals((Object)"AIF1", (Object)aif1Clone.factType);
        Assert.assertEquals((Object)"$t1", (Object)aif1Clone.getBoundName());
        Assert.assertEquals((long)2L, (long)aif1Clone.fieldValues.length);
        Assert.assertNotSame((Object)aif1.fieldValues[0], (Object)aif1Clone.fieldValues[0]);
        Assert.assertNotNull((Object)aif1Clone.fieldValues[0]);
        Assert.assertTrue((boolean)(aif1Clone.fieldValues[0] instanceof ActionFieldValue));
        ActionFieldValue aif1f0Clone = aif1Clone.fieldValues[0];
        Assert.assertEquals((Object)aif1f0.field, (Object)aif1f0Clone.field);
        Assert.assertEquals((long)aif1f0.nature, (long)aif1f0Clone.nature);
        Assert.assertEquals((Object)aif1f0.type, (Object)aif1f0Clone.type);
        Assert.assertEquals((Object)aif1f0.value, (Object)aif1f0Clone.value);
        Assert.assertNotSame((Object)aif1.fieldValues[1], (Object)aif1Clone.fieldValues[1]);
        Assert.assertNotNull((Object)aif1Clone.fieldValues[1]);
        Assert.assertTrue((boolean)(aif1Clone.fieldValues[1] instanceof ActionFieldValue));
        ActionFieldValue aif1f1Clone = aif1Clone.fieldValues[1];
        Assert.assertEquals((Object)aif1f1.field, (Object)aif1f1Clone.field);
        Assert.assertEquals((long)aif1f1.nature, (long)aif1f1Clone.nature);
        Assert.assertEquals((Object)aif1f1.type, (Object)aif1f1Clone.type);
        Assert.assertEquals((Object)aif1f1.value, (Object)aif1f1Clone.value);
    }

    @Test
    public void testActionSetField() {
        RuleModel model = new RuleModel();
        model.rhs = new IAction[2];
        ActionSetField asf0 = new ActionSetField("ASF0");
        asf0.variable = "$t0";
        ActionFieldValue asf0f0 = new ActionFieldValue("ASF0F0", "ASF0F0Value", "String");
        asf0f0.setNature(1L);
        asf0.addFieldValue(asf0f0);
        ActionFieldValue asf0f1 = new ActionFieldValue("ASF0F1", "ASF0F1Value", "String");
        asf0f1.setNature(1L);
        asf0.addFieldValue(asf0f1);
        model.rhs[0] = asf0;
        ActionSetField asf1 = new ActionSetField("ASF1");
        asf1.variable = "$t1";
        ActionFieldValue asf1f0 = new ActionFieldValue("ASF1F0", "ASF1F0Value", "String");
        asf1f0.setNature(1L);
        asf1.addFieldValue(asf1f0);
        ActionFieldValue asf1f1 = new ActionFieldValue("ASF1F1", "ASF1F1Value", "String");
        asf1f1.setNature(1L);
        asf1.addFieldValue(asf1f1);
        model.rhs[1] = asf1;
        RuleModelCloneVisitor cloneVisitor = new RuleModelCloneVisitor();
        RuleModel clone = cloneVisitor.visitRuleModel(model);
        Assert.assertEquals((long)2L, (long)clone.rhs.length);
        Assert.assertNotSame((Object)model.rhs[0], (Object)clone.rhs[0]);
        Assert.assertNotNull((Object)clone.rhs[0]);
        Assert.assertTrue((boolean)(clone.rhs[0] instanceof ActionSetField));
        ActionSetField asf0Clone = (ActionSetField)clone.rhs[0];
        Assert.assertEquals((Object)"$t0", (Object)asf0Clone.variable);
        Assert.assertEquals((long)2L, (long)asf0Clone.fieldValues.length);
        Assert.assertNotSame((Object)asf0.fieldValues[0], (Object)asf0Clone.fieldValues[0]);
        Assert.assertNotNull((Object)asf0Clone.fieldValues[0]);
        Assert.assertTrue((boolean)(asf0Clone.fieldValues[0] instanceof ActionFieldValue));
        ActionFieldValue asf0f0Clone = asf0Clone.fieldValues[0];
        Assert.assertEquals((Object)asf0f0.field, (Object)asf0f0Clone.field);
        Assert.assertEquals((long)asf0f0.nature, (long)asf0f0Clone.nature);
        Assert.assertEquals((Object)asf0f0.type, (Object)asf0f0Clone.type);
        Assert.assertEquals((Object)asf0f0.value, (Object)asf0f0Clone.value);
        Assert.assertNotSame((Object)asf0.fieldValues[1], (Object)asf0Clone.fieldValues[1]);
        Assert.assertNotNull((Object)asf0Clone.fieldValues[1]);
        Assert.assertTrue((boolean)(asf0Clone.fieldValues[1] instanceof ActionFieldValue));
        ActionFieldValue asf0f1Clone = asf0Clone.fieldValues[1];
        Assert.assertEquals((Object)asf0f1.field, (Object)asf0f1Clone.field);
        Assert.assertEquals((long)asf0f1.nature, (long)asf0f1Clone.nature);
        Assert.assertEquals((Object)asf0f1.type, (Object)asf0f1Clone.type);
        Assert.assertEquals((Object)asf0f1.value, (Object)asf0f1Clone.value);
        Assert.assertNotSame((Object)model.rhs[1], (Object)clone.rhs[1]);
        Assert.assertNotNull((Object)clone.rhs[1]);
        Assert.assertTrue((boolean)(clone.rhs[1] instanceof ActionSetField));
        ActionSetField asf1Clone = (ActionSetField)clone.rhs[1];
        Assert.assertEquals((Object)"$t1", (Object)asf1Clone.variable);
        Assert.assertEquals((long)2L, (long)asf1Clone.fieldValues.length);
        Assert.assertNotSame((Object)asf1.fieldValues[0], (Object)asf1Clone.fieldValues[0]);
        Assert.assertNotNull((Object)asf1Clone.fieldValues[0]);
        Assert.assertTrue((boolean)(asf1Clone.fieldValues[0] instanceof ActionFieldValue));
        ActionFieldValue asf1f0Clone = asf1Clone.fieldValues[0];
        Assert.assertEquals((Object)asf1f0.field, (Object)asf1f0Clone.field);
        Assert.assertEquals((long)asf1f0.nature, (long)asf1f0Clone.nature);
        Assert.assertEquals((Object)asf1f0.type, (Object)asf1f0Clone.type);
        Assert.assertEquals((Object)asf1f0.value, (Object)asf1f0Clone.value);
        Assert.assertNotSame((Object)asf1.fieldValues[1], (Object)asf1Clone.fieldValues[1]);
        Assert.assertNotNull((Object)asf1Clone.fieldValues[1]);
        Assert.assertTrue((boolean)(asf1Clone.fieldValues[1] instanceof ActionFieldValue));
        ActionFieldValue asf1f1Clone = asf1Clone.fieldValues[1];
        Assert.assertEquals((Object)asf1f1.field, (Object)asf1f1Clone.field);
        Assert.assertEquals((long)asf1f1.nature, (long)asf1f1Clone.nature);
        Assert.assertEquals((Object)asf1f1.type, (Object)asf1f1Clone.type);
        Assert.assertEquals((Object)asf1f1.value, (Object)asf1f1Clone.value);
    }

    @Test
    public void testActionUpdateField() {
        RuleModel model = new RuleModel();
        model.rhs = new IAction[2];
        ActionUpdateField auf0 = new ActionUpdateField();
        auf0.variable = "$t0";
        ActionFieldValue auf0f0 = new ActionFieldValue("AUF0F0", "AUF0F0Value", "String");
        auf0f0.setNature(1L);
        auf0.addFieldValue(auf0f0);
        ActionFieldValue auf0f1 = new ActionFieldValue("AUF0F1", "AUF0F1Value", "String");
        auf0f1.setNature(1L);
        auf0.addFieldValue(auf0f1);
        model.rhs[0] = auf0;
        ActionUpdateField auf1 = new ActionUpdateField();
        auf1.variable = "$t1";
        ActionFieldValue auf1f0 = new ActionFieldValue("AUF1F0", "AUF1F0Value", "String");
        auf1f0.setNature(1L);
        auf1.addFieldValue(auf1f0);
        ActionFieldValue auf1f1 = new ActionFieldValue("AUF1F1", "AUF1F1Value", "String");
        auf1f1.setNature(1L);
        auf1.addFieldValue(auf1f1);
        model.rhs[1] = auf1;
        RuleModelCloneVisitor cloneVisitor = new RuleModelCloneVisitor();
        RuleModel clone = cloneVisitor.visitRuleModel(model);
        Assert.assertEquals((long)2L, (long)clone.rhs.length);
        Assert.assertNotSame((Object)model.rhs[0], (Object)clone.rhs[0]);
        Assert.assertNotNull((Object)clone.rhs[0]);
        Assert.assertTrue((boolean)(clone.rhs[0] instanceof ActionUpdateField));
        ActionUpdateField auf0Clone = (ActionUpdateField)clone.rhs[0];
        Assert.assertEquals((Object)"$t0", (Object)auf0Clone.variable);
        Assert.assertEquals((long)2L, (long)auf0Clone.fieldValues.length);
        Assert.assertNotSame((Object)auf0.fieldValues[0], (Object)auf0Clone.fieldValues[0]);
        Assert.assertNotNull((Object)auf0Clone.fieldValues[0]);
        Assert.assertTrue((boolean)(auf0Clone.fieldValues[0] instanceof ActionFieldValue));
        ActionFieldValue auf0f0Clone = auf0Clone.fieldValues[0];
        Assert.assertEquals((Object)auf0f0.field, (Object)auf0f0Clone.field);
        Assert.assertEquals((long)auf0f0.nature, (long)auf0f0Clone.nature);
        Assert.assertEquals((Object)auf0f0.type, (Object)auf0f0Clone.type);
        Assert.assertEquals((Object)auf0f0.value, (Object)auf0f0Clone.value);
        Assert.assertNotSame((Object)auf0.fieldValues[1], (Object)auf0Clone.fieldValues[1]);
        Assert.assertNotNull((Object)auf0Clone.fieldValues[1]);
        Assert.assertTrue((boolean)(auf0Clone.fieldValues[1] instanceof ActionFieldValue));
        ActionFieldValue auf0f1Clone = auf0Clone.fieldValues[1];
        Assert.assertEquals((Object)auf0f1.field, (Object)auf0f1Clone.field);
        Assert.assertEquals((long)auf0f1.nature, (long)auf0f1Clone.nature);
        Assert.assertEquals((Object)auf0f1.type, (Object)auf0f1Clone.type);
        Assert.assertEquals((Object)auf0f1.value, (Object)auf0f1Clone.value);
        Assert.assertNotSame((Object)model.rhs[1], (Object)clone.rhs[1]);
        Assert.assertNotNull((Object)clone.rhs[1]);
        Assert.assertTrue((boolean)(clone.rhs[1] instanceof ActionUpdateField));
        ActionUpdateField auf1Clone = (ActionUpdateField)clone.rhs[1];
        Assert.assertEquals((Object)"$t1", (Object)auf1Clone.variable);
        Assert.assertEquals((long)2L, (long)auf1Clone.fieldValues.length);
        Assert.assertNotSame((Object)auf1.fieldValues[0], (Object)auf1Clone.fieldValues[0]);
        Assert.assertNotNull((Object)auf1Clone.fieldValues[0]);
        Assert.assertTrue((boolean)(auf1Clone.fieldValues[0] instanceof ActionFieldValue));
        ActionFieldValue auf1f0Clone = auf1Clone.fieldValues[0];
        Assert.assertEquals((Object)auf1f0.field, (Object)auf1f0Clone.field);
        Assert.assertEquals((long)auf1f0.nature, (long)auf1f0Clone.nature);
        Assert.assertEquals((Object)auf1f0.type, (Object)auf1f0Clone.type);
        Assert.assertEquals((Object)auf1f0.value, (Object)auf1f0Clone.value);
        Assert.assertNotSame((Object)auf1.fieldValues[1], (Object)auf1Clone.fieldValues[1]);
        Assert.assertNotNull((Object)auf1Clone.fieldValues[1]);
        Assert.assertTrue((boolean)(auf1Clone.fieldValues[1] instanceof ActionFieldValue));
        ActionFieldValue auf1f1Clone = auf1Clone.fieldValues[1];
        Assert.assertEquals((Object)auf1f1.field, (Object)auf1f1Clone.field);
        Assert.assertEquals((long)auf1f1.nature, (long)auf1f1Clone.nature);
        Assert.assertEquals((Object)auf1f1.type, (Object)auf1f1Clone.type);
        Assert.assertEquals((Object)auf1f1.value, (Object)auf1f1Clone.value);
    }

    @Test
    public void testActionRetractFact() {
        RuleModel model = new RuleModel();
        model.rhs = new IAction[1];
        ActionRetractFact arf = new ActionRetractFact();
        arf.variableName = "$arf";
        model.rhs[0] = arf;
        RuleModelCloneVisitor cloneVisitor = new RuleModelCloneVisitor();
        RuleModel clone = cloneVisitor.visitRuleModel(model);
        Assert.assertEquals((long)1L, (long)clone.rhs.length);
        Assert.assertNotSame((Object)model.rhs[0], (Object)clone.rhs[0]);
        Assert.assertNotNull((Object)clone.rhs[0]);
        Assert.assertTrue((boolean)(clone.rhs[0] instanceof ActionRetractFact));
        ActionRetractFact arfClone = (ActionRetractFact)clone.rhs[0];
        Assert.assertEquals((Object)"$arf", (Object)arfClone.variableName);
    }

    @Test
    public void testDSLSentence() {
        RuleModel model = new RuleModel();
        model.lhs = new IPattern[2];
        DSLSentence dsl0 = new DSLSentence();
        dsl0.setDefinition("DSL Sentence 0");
        dsl0.getValues().add(new DSLVariableValue("dsl0v0"));
        dsl0.getValues().add(new DSLVariableValue("dsl0v1"));
        model.lhs[0] = dsl0;
        DSLSentence dsl1 = new DSLSentence();
        dsl1.setDefinition("DSL Sentence 1");
        dsl1.getValues().add(new DSLVariableValue("dsl1v0"));
        dsl1.getValues().add(new DSLVariableValue("dsl1v1"));
        model.lhs[1] = dsl1;
        RuleModelCloneVisitor cloneVisitor = new RuleModelCloneVisitor();
        RuleModel clone = cloneVisitor.visitRuleModel(model);
        Assert.assertEquals((long)2L, (long)clone.lhs.length);
        Assert.assertNotSame((Object)model.lhs[0], (Object)clone.lhs[0]);
        Assert.assertNotNull((Object)clone.lhs[0]);
        Assert.assertTrue((boolean)(clone.lhs[0] instanceof DSLSentence));
        DSLSentence dsl0Clone = (DSLSentence)clone.lhs[0];
        Assert.assertEquals((Object)dsl0.getDefinition(), (Object)dsl0Clone.getDefinition());
        Assert.assertEquals((long)2L, (long)dsl0Clone.getValues().size());
        Assert.assertNotSame(dsl0.getValues().get(0), dsl0Clone.getValues().get(0));
        Assert.assertNotNull(dsl0Clone.getValues().get(0));
        Assert.assertTrue((boolean)(dsl0Clone.getValues().get(0) instanceof DSLVariableValue));
        DSLVariableValue dsl0v0Clone = (DSLVariableValue)dsl0Clone.getValues().get(0);
        Assert.assertEquals((Object)((DSLVariableValue)dsl0.getValues().get(0)).getValue(), (Object)dsl0v0Clone.getValue());
        Assert.assertNotSame(dsl0.getValues().get(1), dsl0Clone.getValues().get(1));
        Assert.assertNotNull(dsl0Clone.getValues().get(1));
        Assert.assertTrue((boolean)(dsl0Clone.getValues().get(1) instanceof DSLVariableValue));
        DSLVariableValue dsl0v1Clone = (DSLVariableValue)dsl0Clone.getValues().get(1);
        Assert.assertEquals((Object)((DSLVariableValue)dsl0.getValues().get(1)).getValue(), (Object)dsl0v1Clone.getValue());
        Assert.assertNotSame((Object)model.lhs[1], (Object)clone.lhs[1]);
        Assert.assertNotNull((Object)clone.lhs[1]);
        Assert.assertTrue((boolean)(clone.lhs[1] instanceof DSLSentence));
        DSLSentence dsl1Clone = (DSLSentence)clone.lhs[1];
        Assert.assertEquals((Object)dsl1.getDefinition(), (Object)dsl1Clone.getDefinition());
        Assert.assertEquals((long)2L, (long)dsl1Clone.getValues().size());
        Assert.assertNotSame(dsl1.getValues().get(0), dsl0Clone.getValues().get(0));
        Assert.assertNotNull(dsl1Clone.getValues().get(0));
        Assert.assertTrue((boolean)(dsl1Clone.getValues().get(0) instanceof DSLVariableValue));
        DSLVariableValue dsl1v0Clone = (DSLVariableValue)dsl1Clone.getValues().get(0);
        Assert.assertEquals((Object)((DSLVariableValue)dsl1.getValues().get(0)).getValue(), (Object)dsl1v0Clone.getValue());
        Assert.assertNotSame(dsl1.getValues().get(1), dsl1Clone.getValues().get(1));
        Assert.assertNotNull(dsl1Clone.getValues().get(1));
        Assert.assertTrue((boolean)(dsl1Clone.getValues().get(1) instanceof DSLVariableValue));
        DSLVariableValue dsl1v1Clone = (DSLVariableValue)dsl1Clone.getValues().get(1);
        Assert.assertEquals((Object)((DSLVariableValue)dsl1.getValues().get(1)).getValue(), (Object)dsl1v1Clone.getValue());
    }

    @Test
    public void testFactPattern_Basics() {
        RuleModel model = new RuleModel();
        model.lhs = new IPattern[1];
        FactPattern fp0 = new FactPattern();
        fp0.setBoundName("$t0");
        fp0.setFactType("FT0");
        fp0.setNegated(true);
        model.lhs[0] = fp0;
        RuleModelCloneVisitor cloneVisitor = new RuleModelCloneVisitor();
        RuleModel clone = cloneVisitor.visitRuleModel(model);
        Assert.assertEquals((long)1L, (long)clone.lhs.length);
        Assert.assertNotSame((Object)model.lhs[0], (Object)clone.lhs[0]);
        Assert.assertNotNull((Object)clone.lhs[0]);
        Assert.assertTrue((boolean)(clone.lhs[0] instanceof FactPattern));
        FactPattern fp0Clone = (FactPattern)clone.lhs[0];
        Assert.assertEquals((Object)fp0.getBoundName(), (Object)fp0Clone.getBoundName());
        Assert.assertEquals((Object)fp0.getFactType(), (Object)fp0Clone.getFactType());
        Assert.assertEquals((Object)fp0.isNegated(), (Object)fp0Clone.isNegated());
    }

    @Test
    public void testFactPattern_CEPWindow() {
        RuleModel model = new RuleModel();
        model.lhs = new IPattern[1];
        FactPattern fp0 = new FactPattern();
        fp0.setBoundName("$t0");
        fp0.setFactType("FT0");
        fp0.setNegated(true);
        CEPWindow cepWindow0 = new CEPWindow();
        cepWindow0.setOperator((String)SuggestionCompletionEngine.getCEPWindowOperators().get(0));
        cepWindow0.setParameter("cepWindow0P0", "cepWindow0P0Value");
        cepWindow0.setParameter("cepWindow0P1", "cepWindow0P1Value");
        fp0.setWindow(cepWindow0);
        model.lhs[0] = fp0;
        RuleModelCloneVisitor cloneVisitor = new RuleModelCloneVisitor();
        RuleModel clone = cloneVisitor.visitRuleModel(model);
        Assert.assertEquals((long)1L, (long)clone.lhs.length);
        Assert.assertNotSame((Object)model.lhs[0], (Object)clone.lhs[0]);
        Assert.assertNotNull((Object)clone.lhs[0]);
        Assert.assertTrue((boolean)(clone.lhs[0] instanceof FactPattern));
        FactPattern fp0Clone = (FactPattern)clone.lhs[0];
        Assert.assertEquals((Object)fp0.getBoundName(), (Object)fp0Clone.getBoundName());
        Assert.assertEquals((Object)fp0.getFactType(), (Object)fp0Clone.getFactType());
        Assert.assertEquals((Object)fp0.isNegated(), (Object)fp0Clone.isNegated());
        Assert.assertNotSame((Object)fp0.getWindow(), (Object)fp0Clone.getWindow());
        Assert.assertNotNull((Object)fp0Clone.getWindow());
        Assert.assertTrue((boolean)(fp0Clone.getWindow() instanceof CEPWindow));
        CEPWindow cepWindow0Clone = fp0Clone.getWindow();
        Assert.assertEquals((Object)cepWindow0.getOperator(), (Object)cepWindow0Clone.getOperator());
        Assert.assertEquals((long)cepWindow0.getParameters().size(), (long)cepWindow0Clone.getParameters().size());
        Assert.assertNotNull((Object)cepWindow0Clone.getParameter("cepWindow0P0"));
        Assert.assertEquals((Object)cepWindow0.getParameter("cepWindow0P0"), (Object)cepWindow0Clone.getParameter("cepWindow0P0"));
        Assert.assertNotNull((Object)cepWindow0Clone.getParameter("cepWindow0P1"));
        Assert.assertEquals((Object)cepWindow0.getParameter("cepWindow0P1"), (Object)cepWindow0Clone.getParameter("cepWindow0P1"));
    }

    @Test
    public void testFactPattern_SingleFieldConstraints() {
        RuleModel model = new RuleModel();
        model.lhs = new IPattern[1];
        FactPattern fp0 = new FactPattern();
        fp0.setBoundName("$t0");
        fp0.setFactType("FT0");
        SingleFieldConstraint sfc0 = new SingleFieldConstraint();
        sfc0.setConstraintValueType(1);
        sfc0.setFieldBinding("$sfc0");
        sfc0.setFactType("FT0");
        sfc0.setFieldName("sfc0");
        sfc0.setFieldType("String");
        sfc0.setOperator("==");
        sfc0.setParameter("sfc0p0", "sfc0p0Value");
        sfc0.setValue("sfc0Value");
        fp0.addConstraint((FieldConstraint)sfc0);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setConstraintValueType(1);
        sfc1.setFieldBinding("$sfc1");
        sfc1.setFactType("FT1");
        sfc1.setFieldName("sfc1");
        sfc1.setFieldType("String");
        sfc1.setOperator("==");
        sfc1.setParameter("sfc1p0", "sfc1p0Value");
        sfc1.setValue("sfc1Value");
        fp0.addConstraint((FieldConstraint)sfc1);
        model.lhs[0] = fp0;
        RuleModelCloneVisitor cloneVisitor = new RuleModelCloneVisitor();
        RuleModel clone = cloneVisitor.visitRuleModel(model);
        Assert.assertEquals((long)1L, (long)clone.lhs.length);
        Assert.assertNotSame((Object)model.lhs[0], (Object)clone.lhs[0]);
        Assert.assertNotNull((Object)clone.lhs[0]);
        Assert.assertTrue((boolean)(clone.lhs[0] instanceof FactPattern));
        FactPattern fp0Clone = (FactPattern)clone.lhs[0];
        Assert.assertEquals((Object)fp0.getBoundName(), (Object)fp0Clone.getBoundName());
        Assert.assertEquals((Object)fp0.getFactType(), (Object)fp0Clone.getFactType());
        Assert.assertEquals((long)2L, (long)fp0Clone.constraintList.constraints.length);
        Assert.assertNotSame((Object)fp0.constraintList.constraints[0], (Object)fp0Clone.constraintList.constraints[0]);
        Assert.assertNotNull((Object)fp0Clone.constraintList.constraints[0]);
        Assert.assertTrue((boolean)(fp0Clone.constraintList.constraints[0] instanceof SingleFieldConstraint));
        SingleFieldConstraint sfc0Clone = (SingleFieldConstraint)fp0Clone.constraintList.constraints[0];
        Assert.assertEquals((long)sfc0.getConstraintValueType(), (long)sfc0Clone.getConstraintValueType());
        Assert.assertEquals((Object)sfc0.getFieldBinding(), (Object)sfc0Clone.getFieldBinding());
        Assert.assertEquals((Object)sfc0.getFactType(), (Object)sfc0Clone.getFactType());
        Assert.assertEquals((Object)sfc0.getFieldName(), (Object)sfc0Clone.getFieldName());
        Assert.assertEquals((Object)sfc0.getFieldType(), (Object)sfc0Clone.getFieldType());
        Assert.assertEquals((Object)sfc0.getOperator(), (Object)sfc0Clone.getOperator());
        Assert.assertNotNull((Object)sfc0Clone.getParameter("sfc0p0"));
        Assert.assertEquals((Object)sfc0.getParameter("sfc0p0"), (Object)sfc0Clone.getParameter("sfc0p0"));
        Assert.assertEquals((Object)sfc0.getValue(), (Object)sfc0Clone.getValue());
        Assert.assertNotSame((Object)fp0.constraintList.constraints[1], (Object)fp0Clone.constraintList.constraints[1]);
        Assert.assertNotNull((Object)fp0Clone.constraintList.constraints[1]);
        Assert.assertTrue((boolean)(fp0Clone.constraintList.constraints[1] instanceof SingleFieldConstraint));
        SingleFieldConstraint sfc1Clone = (SingleFieldConstraint)fp0Clone.constraintList.constraints[1];
        Assert.assertEquals((long)sfc1.getConstraintValueType(), (long)sfc1Clone.getConstraintValueType());
        Assert.assertEquals((Object)sfc1.getFieldBinding(), (Object)sfc1Clone.getFieldBinding());
        Assert.assertEquals((Object)sfc1.getFactType(), (Object)sfc1Clone.getFactType());
        Assert.assertEquals((Object)sfc1.getFieldName(), (Object)sfc1Clone.getFieldName());
        Assert.assertEquals((Object)sfc1.getFieldType(), (Object)sfc1Clone.getFieldType());
        Assert.assertEquals((Object)sfc1.getOperator(), (Object)sfc1Clone.getOperator());
        Assert.assertNotNull((Object)sfc1Clone.getParameter("sfc1p0"));
        Assert.assertEquals((Object)sfc1.getParameter("sfc1p0"), (Object)sfc1Clone.getParameter("sfc1p0"));
        Assert.assertEquals((Object)sfc1.getValue(), (Object)sfc1Clone.getValue());
    }

    @Test
    public void testFactPattern_ConnectiveConstraints() {
        RuleModel model = new RuleModel();
        model.lhs = new IPattern[1];
        FactPattern fp0 = new FactPattern();
        fp0.setBoundName("$t0");
        fp0.setFactType("FT0");
        SingleFieldConstraint sfc0 = new SingleFieldConstraint();
        sfc0.setConstraintValueType(1);
        sfc0.setFieldBinding("$sfc0");
        sfc0.setFactType("FT0");
        sfc0.setFieldName("sfc0");
        sfc0.setFieldType("String");
        sfc0.setOperator("==");
        sfc0.setParameter("sfc0p0", "sfc0p0Value");
        sfc0.setValue("sfc0Value");
        fp0.addConstraint((FieldConstraint)sfc0);
        sfc0.addNewConnective();
        ConnectiveConstraint sfc0cc0 = sfc0.connectives[0];
        sfc0cc0.setConstraintValueType(1);
        sfc0cc0.setFieldName("sfc0");
        sfc0cc0.setFieldType("String");
        sfc0cc0.setOperator("|| ==");
        sfc0cc0.setParameter("sfc0cc0p0", "sfc0cc0p0Value");
        sfc0cc0.setValue("sfc0cc0Value");
        model.lhs[0] = fp0;
        RuleModelCloneVisitor cloneVisitor = new RuleModelCloneVisitor();
        RuleModel clone = cloneVisitor.visitRuleModel(model);
        Assert.assertEquals((long)1L, (long)clone.lhs.length);
        Assert.assertNotSame((Object)model.lhs[0], (Object)clone.lhs[0]);
        Assert.assertNotNull((Object)clone.lhs[0]);
        Assert.assertTrue((boolean)(clone.lhs[0] instanceof FactPattern));
        FactPattern fp0Clone = (FactPattern)clone.lhs[0];
        Assert.assertEquals((Object)fp0.getBoundName(), (Object)fp0Clone.getBoundName());
        Assert.assertEquals((Object)fp0.getFactType(), (Object)fp0Clone.getFactType());
        Assert.assertEquals((long)1L, (long)fp0Clone.constraintList.constraints.length);
        Assert.assertNotSame((Object)fp0.constraintList.constraints[0], (Object)fp0Clone.constraintList.constraints[0]);
        Assert.assertNotNull((Object)fp0Clone.constraintList.constraints[0]);
        Assert.assertTrue((boolean)(fp0Clone.constraintList.constraints[0] instanceof SingleFieldConstraint));
        SingleFieldConstraint sfc0Clone = (SingleFieldConstraint)fp0Clone.constraintList.constraints[0];
        Assert.assertEquals((long)sfc0.getConstraintValueType(), (long)sfc0Clone.getConstraintValueType());
        Assert.assertEquals((Object)sfc0.getFieldBinding(), (Object)sfc0Clone.getFieldBinding());
        Assert.assertEquals((Object)sfc0.getFactType(), (Object)sfc0Clone.getFactType());
        Assert.assertEquals((Object)sfc0.getFieldName(), (Object)sfc0Clone.getFieldName());
        Assert.assertEquals((Object)sfc0.getFieldType(), (Object)sfc0Clone.getFieldType());
        Assert.assertEquals((Object)sfc0.getOperator(), (Object)sfc0Clone.getOperator());
        Assert.assertNotNull((Object)sfc0Clone.getParameter("sfc0p0"));
        Assert.assertEquals((Object)sfc0.getParameter("sfc0p0"), (Object)sfc0Clone.getParameter("sfc0p0"));
        Assert.assertEquals((Object)sfc0.getValue(), (Object)sfc0Clone.getValue());
        Assert.assertEquals((long)sfc0.connectives.length, (long)sfc0Clone.connectives.length);
        Assert.assertNotSame((Object)sfc0.connectives[0], (Object)sfc0Clone.connectives[0]);
        Assert.assertNotNull((Object)sfc0Clone.connectives[0]);
        Assert.assertTrue((boolean)(sfc0Clone.connectives[0] instanceof ConnectiveConstraint));
        ConnectiveConstraint sfc0cc0Clone = sfc0Clone.connectives[0];
        Assert.assertEquals((long)sfc0cc0.getConstraintValueType(), (long)sfc0cc0Clone.getConstraintValueType());
        Assert.assertEquals((Object)sfc0cc0.getFieldName(), (Object)sfc0cc0Clone.getFieldName());
        Assert.assertEquals((Object)sfc0cc0.getFieldType(), (Object)sfc0cc0Clone.getFieldType());
        Assert.assertEquals((Object)sfc0cc0.getOperator(), (Object)sfc0cc0Clone.getOperator());
        Assert.assertNotNull((Object)sfc0cc0Clone.getParameter("sfc0cc0p0"));
        Assert.assertEquals((Object)sfc0cc0.getParameter("sfc0cc0p0"), (Object)sfc0cc0Clone.getParameter("sfc0cc0p0"));
        Assert.assertEquals((Object)sfc0cc0.getValue(), (Object)sfc0cc0Clone.getValue());
    }

    @Test
    public void testFactPattern_CompositeFieldConstraints() {
        RuleModel model = new RuleModel();
        model.lhs = new IPattern[1];
        FactPattern fp0 = new FactPattern();
        fp0.setBoundName("$t0");
        fp0.setFactType("FT0");
        CompositeFieldConstraint cfc0 = new CompositeFieldConstraint();
        cfc0.compositeJunctionType = "||";
        SingleFieldConstraint sfc0 = new SingleFieldConstraint();
        sfc0.setConstraintValueType(1);
        sfc0.setFieldBinding("$sfc0");
        sfc0.setFactType("FT0");
        sfc0.setFieldName("sfc0");
        sfc0.setFieldType("String");
        sfc0.setOperator("==");
        sfc0.setParameter("sfc0p0", "sfc0p0Value");
        sfc0.setValue("sfc0Value");
        cfc0.addConstraint((FieldConstraint)sfc0);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setConstraintValueType(1);
        sfc1.setFieldBinding("$sfc1");
        sfc1.setFactType("FT1");
        sfc1.setFieldName("sfc1");
        sfc1.setFieldType("String");
        sfc1.setOperator("==");
        sfc1.setParameter("sfc1p0", "sfc1p0Value");
        sfc1.setValue("sfc1Value");
        cfc0.addConstraint((FieldConstraint)sfc1);
        fp0.addConstraint((FieldConstraint)cfc0);
        model.lhs[0] = fp0;
        RuleModelCloneVisitor cloneVisitor = new RuleModelCloneVisitor();
        RuleModel clone = cloneVisitor.visitRuleModel(model);
        Assert.assertEquals((long)1L, (long)clone.lhs.length);
        Assert.assertNotSame((Object)model.lhs[0], (Object)clone.lhs[0]);
        Assert.assertNotNull((Object)clone.lhs[0]);
        Assert.assertTrue((boolean)(clone.lhs[0] instanceof FactPattern));
        FactPattern fp0Clone = (FactPattern)clone.lhs[0];
        Assert.assertEquals((Object)fp0.getBoundName(), (Object)fp0Clone.getBoundName());
        Assert.assertEquals((Object)fp0.getFactType(), (Object)fp0Clone.getFactType());
        Assert.assertEquals((long)1L, (long)fp0Clone.constraintList.constraints.length);
        Assert.assertNotSame((Object)fp0.constraintList.constraints[0], (Object)fp0Clone.constraintList.constraints[0]);
        Assert.assertNotNull((Object)fp0Clone.constraintList.constraints[0]);
        Assert.assertTrue((boolean)(fp0Clone.constraintList.constraints[0] instanceof CompositeFieldConstraint));
        CompositeFieldConstraint cfc0Clone = (CompositeFieldConstraint)fp0Clone.constraintList.constraints[0];
        Assert.assertEquals((Object)cfc0.compositeJunctionType, (Object)cfc0Clone.compositeJunctionType);
        Assert.assertNotSame((Object)cfc0.constraints[0], (Object)cfc0Clone.constraints[0]);
        Assert.assertNotNull((Object)cfc0Clone.constraints[0]);
        Assert.assertTrue((boolean)(cfc0Clone.constraints[0] instanceof SingleFieldConstraint));
        SingleFieldConstraint sfc0Clone = (SingleFieldConstraint)cfc0Clone.constraints[0];
        Assert.assertEquals((Object)sfc0.getFieldBinding(), (Object)sfc0Clone.getFieldBinding());
        Assert.assertEquals((Object)sfc0.getFactType(), (Object)sfc0Clone.getFactType());
        Assert.assertEquals((Object)sfc0.getFieldName(), (Object)sfc0Clone.getFieldName());
        Assert.assertEquals((Object)sfc0.getFieldType(), (Object)sfc0Clone.getFieldType());
        Assert.assertEquals((Object)sfc0.getOperator(), (Object)sfc0Clone.getOperator());
        Assert.assertNotNull((Object)sfc0Clone.getParameter("sfc0p0"));
        Assert.assertEquals((Object)sfc0.getParameter("sfc0p0"), (Object)sfc0Clone.getParameter("sfc0p0"));
        Assert.assertEquals((Object)sfc0.getValue(), (Object)sfc0Clone.getValue());
        Assert.assertNotSame((Object)cfc0.constraints[1], (Object)cfc0Clone.constraints[1]);
        Assert.assertNotNull((Object)cfc0Clone.constraints[1]);
        Assert.assertTrue((boolean)(cfc0Clone.constraints[1] instanceof SingleFieldConstraint));
        SingleFieldConstraint sfc1Clone = (SingleFieldConstraint)cfc0Clone.constraints[1];
        Assert.assertEquals((long)sfc1.getConstraintValueType(), (long)sfc1Clone.getConstraintValueType());
        Assert.assertEquals((Object)sfc1.getFieldBinding(), (Object)sfc1Clone.getFieldBinding());
        Assert.assertEquals((Object)sfc1.getFactType(), (Object)sfc1Clone.getFactType());
        Assert.assertEquals((Object)sfc1.getFieldName(), (Object)sfc1Clone.getFieldName());
        Assert.assertEquals((Object)sfc1.getFieldType(), (Object)sfc1Clone.getFieldType());
        Assert.assertEquals((Object)sfc1.getOperator(), (Object)sfc1Clone.getOperator());
        Assert.assertNotNull((Object)sfc1Clone.getParameter("sfc1p0"));
        Assert.assertEquals((Object)sfc1.getParameter("sfc1p0"), (Object)sfc1Clone.getParameter("sfc1p0"));
        Assert.assertEquals((Object)sfc1.getValue(), (Object)sfc1Clone.getValue());
    }

    @Test
    public void testFactPattern_ExpressionFormLine() {
        RuleModel model = new RuleModel();
        model.lhs = new IPattern[1];
        FactPattern fp0 = new FactPattern();
        fp0.setBoundName("$t0");
        fp0.setFactType("FT0");
        SingleFieldConstraint sfc0 = new SingleFieldConstraint();
        ExpressionFormLine efl0 = new ExpressionFormLine();
        efl0.setBinding("$efl0");
        ExpressionText efl0p0 = new ExpressionText("efl0p0");
        efl0.appendPart((ExpressionPart)efl0p0);
        sfc0.setExpressionValue(efl0);
        fp0.addConstraint((FieldConstraint)sfc0);
        model.lhs[0] = fp0;
        RuleModelCloneVisitor cloneVisitor = new RuleModelCloneVisitor();
        RuleModel clone = cloneVisitor.visitRuleModel(model);
        Assert.assertEquals((long)1L, (long)clone.lhs.length);
        Assert.assertNotSame((Object)model.lhs[0], (Object)clone.lhs[0]);
        Assert.assertNotNull((Object)clone.lhs[0]);
        Assert.assertTrue((boolean)(clone.lhs[0] instanceof FactPattern));
        FactPattern fp0Clone = (FactPattern)clone.lhs[0];
        Assert.assertEquals((Object)fp0.getBoundName(), (Object)fp0Clone.getBoundName());
        Assert.assertEquals((Object)fp0.getFactType(), (Object)fp0Clone.getFactType());
        Assert.assertEquals((long)1L, (long)fp0Clone.constraintList.constraints.length);
        Assert.assertNotSame((Object)fp0.constraintList.constraints[0], (Object)fp0Clone.constraintList.constraints[0]);
        Assert.assertNotNull((Object)fp0Clone.constraintList.constraints[0]);
        Assert.assertTrue((boolean)(fp0Clone.constraintList.constraints[0] instanceof SingleFieldConstraint));
        SingleFieldConstraint sfc0Clone = (SingleFieldConstraint)fp0Clone.constraintList.constraints[0];
        Assert.assertNotSame((Object)sfc0.getExpressionValue(), (Object)sfc0Clone.getExpressionValue());
        Assert.assertNotNull((Object)sfc0Clone.getExpressionValue());
        Assert.assertTrue((boolean)(sfc0Clone.getExpressionValue() instanceof ExpressionFormLine));
        ExpressionFormLine efl0Clone = sfc0Clone.getExpressionValue();
        Assert.assertEquals((long)1L, (long)sfc0Clone.getExpressionValue().getParts().size());
        Assert.assertTrue((boolean)(sfc0Clone.getExpressionValue().getParts().get(0) instanceof ExpressionText));
        ExpressionText efl0p0Clone = (ExpressionText)sfc0Clone.getExpressionValue().getParts().get(0);
        Assert.assertEquals((Object)efl0p0.getClassType(), (Object)efl0p0Clone.getClassType());
        Assert.assertEquals((Object)efl0p0.getName(), (Object)efl0p0Clone.getName());
        Assert.assertEquals((Object)efl0p0.getGenericType(), (Object)efl0p0Clone.getGenericType());
        Assert.assertEquals((Object)efl0p0.getParametricType(), (Object)efl0p0Clone.getParametricType());
        Assert.assertEquals((Object)efl0.getBinding(), (Object)efl0Clone.getBinding());
        Assert.assertEquals((Object)efl0.getClassType(), (Object)efl0Clone.getClassType());
        Assert.assertEquals((Object)efl0.getFieldName(), (Object)efl0Clone.getFieldName());
        Assert.assertEquals((Object)efl0.getGenericType(), (Object)efl0Clone.getGenericType());
        Assert.assertEquals((Object)efl0.getParametricType(), (Object)efl0Clone.getParametricType());
        Assert.assertEquals((Object)efl0.getCurrentName(), (Object)efl0Clone.getCurrentName());
    }

    @Test
    public void testFactPattern_SingleFieldConstraintEBLeftSide() {
        RuleModel model = new RuleModel();
        model.lhs = new IPattern[1];
        FactPattern fp0 = new FactPattern();
        fp0.setBoundName("$t0");
        fp0.setFactType("FT0");
        SingleFieldConstraintEBLeftSide sfc0 = new SingleFieldConstraintEBLeftSide();
        ExpressionFormLine eflhs0 = new ExpressionFormLine();
        eflhs0.setBinding("$eflhs0");
        ExpressionText eflhs0p0 = new ExpressionText("eflhs0p0");
        eflhs0.appendPart((ExpressionPart)eflhs0p0);
        sfc0.setExpressionLeftSide(eflhs0);
        ExpressionFormLine efl0 = new ExpressionFormLine();
        efl0.setBinding("$efl0");
        ExpressionText efl0p0 = new ExpressionText("efl0p0");
        efl0.appendPart((ExpressionPart)efl0p0);
        sfc0.setExpressionValue(efl0);
        fp0.addConstraint((FieldConstraint)sfc0);
        model.lhs[0] = fp0;
        RuleModelCloneVisitor cloneVisitor = new RuleModelCloneVisitor();
        RuleModel clone = cloneVisitor.visitRuleModel(model);
        Assert.assertEquals((long)1L, (long)clone.lhs.length);
        Assert.assertNotSame((Object)model.lhs[0], (Object)clone.lhs[0]);
        Assert.assertNotNull((Object)clone.lhs[0]);
        Assert.assertTrue((boolean)(clone.lhs[0] instanceof FactPattern));
        FactPattern fp0Clone = (FactPattern)clone.lhs[0];
        Assert.assertEquals((Object)fp0.getBoundName(), (Object)fp0Clone.getBoundName());
        Assert.assertEquals((Object)fp0.getFactType(), (Object)fp0Clone.getFactType());
        Assert.assertEquals((long)1L, (long)fp0Clone.constraintList.constraints.length);
        Assert.assertNotSame((Object)fp0.constraintList.constraints[0], (Object)fp0Clone.constraintList.constraints[0]);
        Assert.assertNotNull((Object)fp0Clone.constraintList.constraints[0]);
        Assert.assertTrue((boolean)(fp0Clone.constraintList.constraints[0] instanceof SingleFieldConstraintEBLeftSide));
        SingleFieldConstraintEBLeftSide sfc0Clone = (SingleFieldConstraintEBLeftSide)fp0Clone.constraintList.constraints[0];
        Assert.assertNotSame((Object)sfc0.getExpressionLeftSide(), (Object)sfc0Clone.getExpressionLeftSide());
        Assert.assertNotNull((Object)sfc0Clone.getExpressionLeftSide());
        Assert.assertTrue((boolean)(sfc0Clone.getExpressionLeftSide() instanceof ExpressionFormLine));
        ExpressionFormLine eflhs0Clone = sfc0Clone.getExpressionLeftSide();
        Assert.assertEquals((long)1L, (long)sfc0Clone.getExpressionLeftSide().getParts().size());
        Assert.assertTrue((boolean)(sfc0Clone.getExpressionLeftSide().getParts().get(0) instanceof ExpressionText));
        ExpressionText eflhs0p0Clone = (ExpressionText)sfc0Clone.getExpressionLeftSide().getParts().get(0);
        Assert.assertEquals((Object)eflhs0p0.getClassType(), (Object)eflhs0p0Clone.getClassType());
        Assert.assertEquals((Object)eflhs0p0.getName(), (Object)eflhs0p0Clone.getName());
        Assert.assertEquals((Object)eflhs0p0.getGenericType(), (Object)eflhs0p0Clone.getGenericType());
        Assert.assertEquals((Object)eflhs0p0.getParametricType(), (Object)eflhs0p0Clone.getParametricType());
        Assert.assertEquals((Object)eflhs0.getBinding(), (Object)eflhs0Clone.getBinding());
        Assert.assertEquals((Object)eflhs0.getClassType(), (Object)eflhs0Clone.getClassType());
        Assert.assertEquals((Object)eflhs0.getFieldName(), (Object)eflhs0Clone.getFieldName());
        Assert.assertEquals((Object)eflhs0.getGenericType(), (Object)eflhs0Clone.getGenericType());
        Assert.assertEquals((Object)eflhs0.getParametricType(), (Object)eflhs0Clone.getParametricType());
        Assert.assertEquals((Object)eflhs0.getCurrentName(), (Object)eflhs0Clone.getCurrentName());
        Assert.assertNotSame((Object)sfc0.getExpressionValue(), (Object)sfc0Clone.getExpressionValue());
        Assert.assertNotNull((Object)sfc0Clone.getExpressionValue());
        Assert.assertTrue((boolean)(sfc0Clone.getExpressionValue() instanceof ExpressionFormLine));
        ExpressionFormLine efl0Clone = sfc0Clone.getExpressionValue();
        Assert.assertEquals((long)1L, (long)sfc0Clone.getExpressionValue().getParts().size());
        Assert.assertTrue((boolean)(sfc0Clone.getExpressionValue().getParts().get(0) instanceof ExpressionText));
        ExpressionText efl0p0Clone = (ExpressionText)sfc0Clone.getExpressionValue().getParts().get(0);
        Assert.assertEquals((Object)efl0p0.getClassType(), (Object)efl0p0Clone.getClassType());
        Assert.assertEquals((Object)efl0p0.getName(), (Object)efl0p0Clone.getName());
        Assert.assertEquals((Object)efl0p0.getGenericType(), (Object)efl0p0Clone.getGenericType());
        Assert.assertEquals((Object)efl0p0.getParametricType(), (Object)efl0p0Clone.getParametricType());
        Assert.assertEquals((Object)efl0.getBinding(), (Object)efl0Clone.getBinding());
        Assert.assertEquals((Object)efl0.getClassType(), (Object)efl0Clone.getClassType());
        Assert.assertEquals((Object)efl0.getFieldName(), (Object)efl0Clone.getFieldName());
        Assert.assertEquals((Object)efl0.getGenericType(), (Object)efl0Clone.getGenericType());
        Assert.assertEquals((Object)efl0.getParametricType(), (Object)efl0Clone.getParametricType());
        Assert.assertEquals((Object)efl0.getCurrentName(), (Object)efl0Clone.getCurrentName());
    }

    @Test
    public void testCompositeFactPatterns() {
        RuleModel model = new RuleModel();
        model.lhs = new IPattern[1];
        CompositeFactPattern cfp0 = new CompositeFactPattern();
        cfp0.type = "or";
        FactPattern fp0 = new FactPattern();
        fp0.setBoundName("$t0");
        fp0.setFactType("FT0");
        fp0.setNegated(true);
        SingleFieldConstraint fp0sfc0 = new SingleFieldConstraint();
        fp0sfc0.setConstraintValueType(1);
        fp0sfc0.setFieldBinding("$fp0sfc0");
        fp0sfc0.setFactType("FT0");
        fp0sfc0.setFieldName("fp0sfc0");
        fp0sfc0.setFieldType("String");
        fp0sfc0.setOperator("==");
        fp0sfc0.setParameter("fp0sfc0p0", "fp0sfc0p0Value");
        fp0sfc0.setValue("fp0sfc0Value");
        fp0.addConstraint((FieldConstraint)fp0sfc0);
        FactPattern fp1 = new FactPattern();
        fp1.setBoundName("$t1");
        fp1.setFactType("FT1");
        fp1.setNegated(true);
        SingleFieldConstraint fp1sfc0 = new SingleFieldConstraint();
        fp1sfc0.setConstraintValueType(1);
        fp1sfc0.setFieldBinding("$fp1sfc0");
        fp1sfc0.setFactType("FT1");
        fp1sfc0.setFieldName("fp1sfc0");
        fp1sfc0.setFieldType("String");
        fp1sfc0.setOperator("==");
        fp1sfc0.setParameter("fp1sfc0p0", "fp1sfc0p0Value");
        fp1sfc0.setValue("fp1sfc0Value");
        fp1.addConstraint((FieldConstraint)fp1sfc0);
        cfp0.addFactPattern((IFactPattern)fp0);
        cfp0.addFactPattern((IFactPattern)fp1);
        model.lhs[0] = cfp0;
        RuleModelCloneVisitor cloneVisitor = new RuleModelCloneVisitor();
        RuleModel clone = cloneVisitor.visitRuleModel(model);
        Assert.assertEquals((long)1L, (long)clone.lhs.length);
        Assert.assertNotSame((Object)model.lhs[0], (Object)clone.lhs[0]);
        Assert.assertNotNull((Object)clone.lhs[0]);
        Assert.assertTrue((boolean)(clone.lhs[0] instanceof CompositeFactPattern));
        CompositeFactPattern cfp0Clone = (CompositeFactPattern)clone.lhs[0];
        Assert.assertEquals((Object)cfp0.type, (Object)cfp0Clone.type);
        Assert.assertEquals((long)cfp0.getPatterns().length, (long)cfp0Clone.getPatterns().length);
        Assert.assertNotSame((Object)cfp0.getPatterns()[0], (Object)cfp0Clone.getPatterns()[0]);
        Assert.assertNotNull((Object)cfp0Clone.getPatterns()[0]);
        Assert.assertTrue((boolean)(cfp0Clone.getPatterns()[0] instanceof FactPattern));
        FactPattern fp0Clone = (FactPattern)cfp0Clone.getPatterns()[0];
        Assert.assertEquals((Object)fp0.getBoundName(), (Object)fp0Clone.getBoundName());
        Assert.assertEquals((Object)fp0.getFactType(), (Object)fp0Clone.getFactType());
        Assert.assertEquals((long)fp0.constraintList.constraints.length, (long)fp0Clone.constraintList.constraints.length);
        Assert.assertNotSame((Object)fp0.constraintList.constraints[0], (Object)fp0Clone.constraintList.constraints[0]);
        Assert.assertNotNull((Object)fp0Clone.constraintList.constraints[0]);
        Assert.assertTrue((boolean)(fp0Clone.constraintList.constraints[0] instanceof SingleFieldConstraint));
        SingleFieldConstraint fp0sfc0Clone = (SingleFieldConstraint)fp0Clone.constraintList.constraints[0];
        Assert.assertEquals((Object)fp0sfc0.getFieldBinding(), (Object)fp0sfc0Clone.getFieldBinding());
        Assert.assertEquals((Object)fp0sfc0.getFactType(), (Object)fp0sfc0Clone.getFactType());
        Assert.assertEquals((Object)fp0sfc0.getFieldName(), (Object)fp0sfc0Clone.getFieldName());
        Assert.assertEquals((Object)fp0sfc0.getFieldType(), (Object)fp0sfc0Clone.getFieldType());
        Assert.assertEquals((Object)fp0sfc0.getOperator(), (Object)fp0sfc0Clone.getOperator());
        Assert.assertNotNull((Object)fp0sfc0Clone.getParameter("fp0sfc0p0"));
        Assert.assertEquals((Object)fp0sfc0.getParameter("fp0sfc0p0"), (Object)fp0sfc0Clone.getParameter("fp0sfc0p0"));
        Assert.assertEquals((Object)fp0sfc0.getValue(), (Object)fp0sfc0Clone.getValue());
        Assert.assertNotSame((Object)cfp0.getPatterns()[1], (Object)cfp0Clone.getPatterns()[1]);
        Assert.assertNotNull((Object)cfp0Clone.getPatterns()[1]);
        Assert.assertTrue((boolean)(cfp0Clone.getPatterns()[1] instanceof FactPattern));
        FactPattern fp1Clone = (FactPattern)cfp0Clone.getPatterns()[1];
        Assert.assertEquals((Object)fp1.getBoundName(), (Object)fp1Clone.getBoundName());
        Assert.assertEquals((Object)fp1.getFactType(), (Object)fp1Clone.getFactType());
        Assert.assertEquals((long)fp1.constraintList.constraints.length, (long)fp1Clone.constraintList.constraints.length);
        Assert.assertNotSame((Object)fp1.constraintList.constraints[0], (Object)fp1Clone.constraintList.constraints[0]);
        Assert.assertNotNull((Object)fp1Clone.constraintList.constraints[0]);
        Assert.assertTrue((boolean)(fp1Clone.constraintList.constraints[0] instanceof SingleFieldConstraint));
        SingleFieldConstraint fp1sfc0Clone = (SingleFieldConstraint)fp1Clone.constraintList.constraints[0];
        Assert.assertEquals((Object)fp1sfc0.getFieldBinding(), (Object)fp1sfc0Clone.getFieldBinding());
        Assert.assertEquals((Object)fp1sfc0.getFactType(), (Object)fp1sfc0Clone.getFactType());
        Assert.assertEquals((Object)fp1sfc0.getFieldName(), (Object)fp1sfc0Clone.getFieldName());
        Assert.assertEquals((Object)fp1sfc0.getFieldType(), (Object)fp1sfc0Clone.getFieldType());
        Assert.assertEquals((Object)fp1sfc0.getOperator(), (Object)fp1sfc0Clone.getOperator());
        Assert.assertNotNull((Object)fp1sfc0Clone.getParameter("fp1sfc0p0"));
        Assert.assertEquals((Object)fp1sfc0.getParameter("fp1sfc0p0"), (Object)fp1sfc0Clone.getParameter("fp1sfc0p0"));
        Assert.assertEquals((Object)fp1sfc0.getValue(), (Object)fp1sfc0Clone.getValue());
    }

    @Test
    public void testFreeFormLine() {
        RuleModel model = new RuleModel();
        model.lhs = new IPattern[1];
        FreeFormLine ffl0 = new FreeFormLine();
        ffl0.text = "ffl0";
        model.lhs[0] = ffl0;
        RuleModelCloneVisitor cloneVisitor = new RuleModelCloneVisitor();
        RuleModel clone = cloneVisitor.visitRuleModel(model);
        Assert.assertEquals((long)1L, (long)clone.lhs.length);
        Assert.assertNotSame((Object)model.lhs[0], (Object)clone.lhs[0]);
        Assert.assertNotNull((Object)clone.lhs[0]);
        Assert.assertTrue((boolean)(clone.lhs[0] instanceof FreeFormLine));
        FreeFormLine ffl0Clone = (FreeFormLine)clone.lhs[0];
        Assert.assertEquals((Object)ffl0.text, (Object)ffl0Clone.text);
    }

    @Test
    public void testFromAccumulateCompositeFactPattern() {
        RuleModel model = new RuleModel();
        model.lhs = new IPattern[1];
        FromAccumulateCompositeFactPattern fp0 = new FromAccumulateCompositeFactPattern();
        fp0.setActionCode("fp0.actionCode");
        ExpressionFormLine efl0 = new ExpressionFormLine();
        efl0.setBinding("$efl0");
        ExpressionText efl0p0 = new ExpressionText("efl0p0");
        efl0.appendPart((ExpressionPart)efl0p0);
        fp0.setExpression(efl0);
        FactPattern fp0FactPattern = new FactPattern("fp0FactPattern");
        fp0.setFactPattern(fp0FactPattern);
        fp0.setFunction("fp0.function");
        fp0.setInitCode("fp0.initCode");
        fp0.setResultCode("fp0.resultCode");
        fp0.setReverseCode("fp0.reverseCode");
        FactPattern fp0SourcePattern = new FactPattern("fp0SourcePattern");
        fp0.setSourcePattern((IPattern)fp0SourcePattern);
        model.lhs[0] = fp0;
        RuleModelCloneVisitor cloneVisitor = new RuleModelCloneVisitor();
        RuleModel clone = cloneVisitor.visitRuleModel(model);
        Assert.assertEquals((long)1L, (long)clone.lhs.length);
        Assert.assertNotSame((Object)model.lhs[0], (Object)clone.lhs[0]);
        Assert.assertNotNull((Object)clone.lhs[0]);
        Assert.assertTrue((boolean)(clone.lhs[0] instanceof FromAccumulateCompositeFactPattern));
        FromAccumulateCompositeFactPattern fp0Clone = (FromAccumulateCompositeFactPattern)clone.lhs[0];
        Assert.assertEquals((Object)fp0.getActionCode(), (Object)fp0Clone.getActionCode());
        Assert.assertEquals((Object)fp0.getFunction(), (Object)fp0Clone.getFunction());
        Assert.assertEquals((Object)fp0.getInitCode(), (Object)fp0Clone.getInitCode());
        Assert.assertEquals((Object)fp0.getResultCode(), (Object)fp0Clone.getResultCode());
        Assert.assertEquals((Object)fp0.getReverseCode(), (Object)fp0Clone.getReverseCode());
        Assert.assertNotSame((Object)fp0.getExpression(), (Object)fp0Clone.getExpression());
        Assert.assertNotNull((Object)fp0Clone.getExpression());
        Assert.assertTrue((boolean)(fp0Clone.getExpression() instanceof ExpressionFormLine));
        ExpressionFormLine efl0Clone = fp0Clone.getExpression();
        Assert.assertEquals((long)1L, (long)fp0Clone.getExpression().getParts().size());
        Assert.assertTrue((boolean)(fp0Clone.getExpression().getParts().get(0) instanceof ExpressionText));
        ExpressionText efl0p0Clone = (ExpressionText)fp0Clone.getExpression().getParts().get(0);
        Assert.assertEquals((Object)efl0p0.getClassType(), (Object)efl0p0Clone.getClassType());
        Assert.assertEquals((Object)efl0p0.getName(), (Object)efl0p0Clone.getName());
        Assert.assertEquals((Object)efl0p0.getGenericType(), (Object)efl0p0Clone.getGenericType());
        Assert.assertEquals((Object)efl0p0.getParametricType(), (Object)efl0p0Clone.getParametricType());
        Assert.assertEquals((Object)efl0.getBinding(), (Object)efl0Clone.getBinding());
        Assert.assertEquals((Object)efl0.getClassType(), (Object)efl0Clone.getClassType());
        Assert.assertEquals((Object)efl0.getFieldName(), (Object)efl0Clone.getFieldName());
        Assert.assertEquals((Object)efl0.getGenericType(), (Object)efl0Clone.getGenericType());
        Assert.assertEquals((Object)efl0.getParametricType(), (Object)efl0Clone.getParametricType());
        Assert.assertEquals((Object)efl0.getCurrentName(), (Object)efl0Clone.getCurrentName());
        Assert.assertNotSame((Object)fp0.getFactPattern(), (Object)fp0Clone.getFactPattern());
        Assert.assertNotNull((Object)fp0Clone.getFactPattern());
        Assert.assertTrue((boolean)(fp0Clone.getFactPattern() instanceof FactPattern));
        FactPattern fp0FactPatternClone = fp0Clone.getFactPattern();
        Assert.assertEquals((Object)fp0FactPattern.getBoundName(), (Object)fp0FactPatternClone.getBoundName());
        Assert.assertEquals((Object)fp0FactPattern.getFactType(), (Object)fp0FactPatternClone.getFactType());
        Assert.assertNotSame((Object)fp0.getSourcePattern(), (Object)fp0Clone.getSourcePattern());
        Assert.assertNotNull((Object)fp0Clone.getSourcePattern());
        Assert.assertTrue((boolean)(fp0Clone.getSourcePattern() instanceof FactPattern));
        FactPattern fp0SourcePatternClone = (FactPattern)fp0Clone.getSourcePattern();
        Assert.assertEquals((Object)fp0SourcePattern.getBoundName(), (Object)fp0SourcePatternClone.getBoundName());
        Assert.assertEquals((Object)fp0SourcePattern.getFactType(), (Object)fp0SourcePatternClone.getFactType());
    }

    @Test
    public void testFromCollectCompositeFactPattern() {
        RuleModel model = new RuleModel();
        model.lhs = new IPattern[1];
        FromCollectCompositeFactPattern fp0 = new FromCollectCompositeFactPattern();
        ExpressionFormLine efl0 = new ExpressionFormLine();
        efl0.setBinding("$efl0");
        ExpressionText efl0p0 = new ExpressionText("efl0p0");
        efl0.appendPart((ExpressionPart)efl0p0);
        fp0.setExpression(efl0);
        FactPattern fp0FactPattern = new FactPattern("fp0FactPattern");
        fp0.setFactPattern(fp0FactPattern);
        FactPattern fp0RightPattern = new FactPattern("fp0RightPattern");
        fp0.setRightPattern((IPattern)fp0RightPattern);
        model.lhs[0] = fp0;
        RuleModelCloneVisitor cloneVisitor = new RuleModelCloneVisitor();
        RuleModel clone = cloneVisitor.visitRuleModel(model);
        Assert.assertEquals((long)1L, (long)clone.lhs.length);
        Assert.assertNotSame((Object)model.lhs[0], (Object)clone.lhs[0]);
        Assert.assertNotNull((Object)clone.lhs[0]);
        Assert.assertTrue((boolean)(clone.lhs[0] instanceof FromCollectCompositeFactPattern));
        FromCollectCompositeFactPattern fp0Clone = (FromCollectCompositeFactPattern)clone.lhs[0];
        Assert.assertNotSame((Object)fp0.getExpression(), (Object)fp0Clone.getExpression());
        Assert.assertNotNull((Object)fp0Clone.getExpression());
        Assert.assertTrue((boolean)(fp0Clone.getExpression() instanceof ExpressionFormLine));
        ExpressionFormLine efl0Clone = fp0Clone.getExpression();
        Assert.assertEquals((long)1L, (long)fp0Clone.getExpression().getParts().size());
        Assert.assertTrue((boolean)(fp0Clone.getExpression().getParts().get(0) instanceof ExpressionText));
        ExpressionText efl0p0Clone = (ExpressionText)fp0Clone.getExpression().getParts().get(0);
        Assert.assertEquals((Object)efl0p0.getClassType(), (Object)efl0p0Clone.getClassType());
        Assert.assertEquals((Object)efl0p0.getName(), (Object)efl0p0Clone.getName());
        Assert.assertEquals((Object)efl0p0.getGenericType(), (Object)efl0p0Clone.getGenericType());
        Assert.assertEquals((Object)efl0p0.getParametricType(), (Object)efl0p0Clone.getParametricType());
        Assert.assertEquals((Object)efl0.getBinding(), (Object)efl0Clone.getBinding());
        Assert.assertEquals((Object)efl0.getClassType(), (Object)efl0Clone.getClassType());
        Assert.assertEquals((Object)efl0.getFieldName(), (Object)efl0Clone.getFieldName());
        Assert.assertEquals((Object)efl0.getGenericType(), (Object)efl0Clone.getGenericType());
        Assert.assertEquals((Object)efl0.getParametricType(), (Object)efl0Clone.getParametricType());
        Assert.assertEquals((Object)efl0.getCurrentName(), (Object)efl0Clone.getCurrentName());
        Assert.assertNotSame((Object)fp0.getFactPattern(), (Object)fp0Clone.getFactPattern());
        Assert.assertNotNull((Object)fp0Clone.getFactPattern());
        Assert.assertTrue((boolean)(fp0Clone.getFactPattern() instanceof FactPattern));
        FactPattern fp0FactPatternClone = fp0Clone.getFactPattern();
        Assert.assertEquals((Object)fp0FactPattern.getBoundName(), (Object)fp0FactPatternClone.getBoundName());
        Assert.assertEquals((Object)fp0FactPattern.getFactType(), (Object)fp0FactPatternClone.getFactType());
        Assert.assertNotSame((Object)fp0.getRightPattern(), (Object)fp0Clone.getRightPattern());
        Assert.assertNotNull((Object)fp0Clone.getRightPattern());
        Assert.assertTrue((boolean)(fp0Clone.getRightPattern() instanceof FactPattern));
        FactPattern fp0RightPatternClone = (FactPattern)fp0Clone.getRightPattern();
        Assert.assertEquals((Object)fp0RightPattern.getBoundName(), (Object)fp0RightPatternClone.getBoundName());
        Assert.assertEquals((Object)fp0RightPattern.getFactType(), (Object)fp0RightPatternClone.getFactType());
    }

    @Test
    public void testFromCompositeFactPattern() {
        RuleModel model = new RuleModel();
        model.lhs = new IPattern[1];
        FromCompositeFactPattern fp0 = new FromCompositeFactPattern();
        ExpressionFormLine efl0 = new ExpressionFormLine();
        efl0.setBinding("$efl0");
        ExpressionText efl0p0 = new ExpressionText("efl0p0");
        efl0.appendPart((ExpressionPart)efl0p0);
        fp0.setExpression(efl0);
        FactPattern fp0FactPattern = new FactPattern("fp0FactPattern");
        fp0.setFactPattern(fp0FactPattern);
        model.lhs[0] = fp0;
        RuleModelCloneVisitor cloneVisitor = new RuleModelCloneVisitor();
        RuleModel clone = cloneVisitor.visitRuleModel(model);
        Assert.assertEquals((long)1L, (long)clone.lhs.length);
        Assert.assertNotSame((Object)model.lhs[0], (Object)clone.lhs[0]);
        Assert.assertNotNull((Object)clone.lhs[0]);
        Assert.assertTrue((boolean)(clone.lhs[0] instanceof FromCompositeFactPattern));
        FromCompositeFactPattern fp0Clone = (FromCompositeFactPattern)clone.lhs[0];
        Assert.assertNotSame((Object)fp0.getExpression(), (Object)fp0Clone.getExpression());
        Assert.assertNotNull((Object)fp0Clone.getExpression());
        Assert.assertTrue((boolean)(fp0Clone.getExpression() instanceof ExpressionFormLine));
        ExpressionFormLine efl0Clone = fp0Clone.getExpression();
        Assert.assertEquals((long)1L, (long)fp0Clone.getExpression().getParts().size());
        Assert.assertTrue((boolean)(fp0Clone.getExpression().getParts().get(0) instanceof ExpressionText));
        ExpressionText efl0p0Clone = (ExpressionText)fp0Clone.getExpression().getParts().get(0);
        Assert.assertEquals((Object)efl0p0.getClassType(), (Object)efl0p0Clone.getClassType());
        Assert.assertEquals((Object)efl0p0.getName(), (Object)efl0p0Clone.getName());
        Assert.assertEquals((Object)efl0p0.getGenericType(), (Object)efl0p0Clone.getGenericType());
        Assert.assertEquals((Object)efl0p0.getParametricType(), (Object)efl0p0Clone.getParametricType());
        Assert.assertEquals((Object)efl0.getBinding(), (Object)efl0Clone.getBinding());
        Assert.assertEquals((Object)efl0.getClassType(), (Object)efl0Clone.getClassType());
        Assert.assertEquals((Object)efl0.getFieldName(), (Object)efl0Clone.getFieldName());
        Assert.assertEquals((Object)efl0.getGenericType(), (Object)efl0Clone.getGenericType());
        Assert.assertEquals((Object)efl0.getParametricType(), (Object)efl0Clone.getParametricType());
        Assert.assertEquals((Object)efl0.getCurrentName(), (Object)efl0Clone.getCurrentName());
        Assert.assertNotSame((Object)fp0.getFactPattern(), (Object)fp0Clone.getFactPattern());
        Assert.assertNotNull((Object)fp0Clone.getFactPattern());
        Assert.assertTrue((boolean)(fp0Clone.getFactPattern() instanceof FactPattern));
        FactPattern fp0FactPatternClone = fp0Clone.getFactPattern();
        Assert.assertEquals((Object)fp0FactPattern.getBoundName(), (Object)fp0FactPatternClone.getBoundName());
        Assert.assertEquals((Object)fp0FactPattern.getFactType(), (Object)fp0FactPatternClone.getFactType());
    }
}

