/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.factconstraints.predefined;

import java.util.ArrayList;
import java.util.Map;
import org.drools.ide.common.client.factconstraints.ConstraintConfiguration;
import org.drools.ide.common.client.factconstraints.ValidationResult;
import org.drools.ide.common.server.factconstraints.DefaultFieldConstraintImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerConstraint
extends DefaultFieldConstraintImpl {
    private static final long serialVersionUID = 501L;
    public static final String NAME = "IntegerConstraint";

    @Override
    protected String internalVerifierRule(ConstraintConfiguration config, Map<String, Object> context) {
        ArrayList<String> constraints = new ArrayList<String>();
        constraints.add("valueType != Field.INT");
        return this.createVerifierRuleTemplate(config, context, "Integer_Field_Constraint", constraints, "The value must be an integer");
    }

    @Override
    public ValidationResult validate(Object value, ConstraintConfiguration config) {
        ValidationResult result = new ValidationResult();
        if (value == null) {
            result.setSuccess(false);
            result.setMessage("The value is null");
        } else if (value instanceof Integer) {
            result.setSuccess(true);
        } else if (value instanceof String) {
            try {
                Integer.parseInt((String)value);
                result.setSuccess(true);
            }
            catch (NumberFormatException ex) {
                result.setSuccess(false);
                result.setMessage(ex.getMessage());
            }
        } else {
            result.setSuccess(false);
            result.setMessage("Invalid value type " + value.getClass().getName());
        }
        return result;
    }
}

