/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.util.ReflectiveVisitor;
import org.drools.ide.common.client.modeldriven.FieldNature;
import org.drools.ide.common.client.modeldriven.brl.ActionCallMethod;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldFunction;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionGlobalCollectionAdd;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertLogicalFact;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;
import org.drools.ide.common.client.modeldriven.brl.CEPWindow;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.ExpressionFormLine;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.brl.FromAccumulateCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCollectCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromEntryPointFactPattern;
import org.drools.ide.common.client.modeldriven.brl.HasParameterizedOperator;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleAttribute;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraintEBLeftSide;
import org.drools.ide.common.server.util.BRLPersistence;
import org.drools.ide.common.server.util.DRLConstraintValueBuilder;
import org.drools.ide.common.server.util.OperatorParameterDRLBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BRDRLPersistence
implements BRLPersistence {
    private static final BRLPersistence INSTANCE = new BRDRLPersistence();

    protected BRDRLPersistence() {
    }

    public static BRLPersistence getInstance() {
        return INSTANCE;
    }

    @Override
    public String marshal(RuleModel model) {
        return this.marshalRule(model);
    }

    protected String marshalRule(RuleModel model) {
        boolean isDSLEnhanced = model.hasDSLSentences();
        StringBuilder buf = new StringBuilder();
        this.marshalHeader(model, buf);
        this.marshalMetadata(buf, model);
        this.marshalAttributes(buf, model);
        buf.append("\twhen\n");
        this.marshalLHS(buf, model, isDSLEnhanced);
        buf.append("\tthen\n");
        this.marshalRHS(buf, model, isDSLEnhanced);
        this.marshalFooter(buf);
        return buf.toString();
    }

    protected void marshalFooter(StringBuilder buf) {
        buf.append("end\n");
    }

    protected void marshalHeader(RuleModel model, StringBuilder buf) {
        buf.append("rule \"" + this.marshalRuleName(model) + "\"");
        if (null != model.parentName && model.parentName.length() > 0) {
            buf.append(" extends \"" + model.parentName + "\"\n");
        } else {
            buf.append('\n');
        }
    }

    protected String marshalRuleName(RuleModel model) {
        return model.name;
    }

    @Override
    public RuleModel unmarshal(String str) {
        throw new UnsupportedOperationException("Still not possible to convert pure DRL to RuleModel");
    }

    private void marshalAttributes(StringBuilder buf, RuleModel model) {
        boolean hasDialect = false;
        for (int i = 0; i < model.attributes.length; ++i) {
            RuleAttribute attr = model.attributes[i];
            buf.append("\t");
            buf.append(attr);
            buf.append("\n");
            if (!attr.attributeName.equals("dialect")) continue;
            hasDialect = true;
        }
        if (!hasDialect) {
            RuleAttribute attr = new RuleAttribute("dialect", "mvel");
            buf.append("\t");
            buf.append(attr);
            buf.append("\n");
        }
    }

    private void marshalMetadata(StringBuilder buf, RuleModel model) {
        if (model.metadataList != null) {
            for (int i = 0; i < model.metadataList.length; ++i) {
                buf.append("\t").append(model.metadataList[i]).append("\n");
            }
        }
    }

    private void marshalLHS(StringBuilder buf, RuleModel model, boolean isDSLEnhanced) {
        String indentation;
        String nestedIndentation = indentation = "\t\t";
        boolean isNegated = model.isNegated();
        if (model.lhs != null) {
            if (isNegated) {
                nestedIndentation = nestedIndentation + "\t";
                buf.append(indentation);
                buf.append("not (\n");
            }
            LHSPatternVisitor visitor = new LHSPatternVisitor(isDSLEnhanced, buf, nestedIndentation, isNegated);
            for (IPattern cond : model.lhs) {
                visitor.visit(cond);
            }
            if (model.isNegated()) {
                buf.delete(buf.length() - 5, buf.length());
                buf.append("\n");
                buf.append(indentation);
                buf.append(")\n");
            }
        }
    }

    private void marshalRHS(StringBuilder buf, RuleModel model, boolean isDSLEnhanced) {
        String indentation = "\t\t";
        if (model.rhs != null) {
            Map<String, List<ActionFieldValue>> classes = this.getRHSClassDependencies(model);
            if (classes.containsKey("Date")) {
                buf.append(indentation);
                buf.append("java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(\"" + System.getProperty("drools.dateformat") + "\");\n");
            }
            RHSActionVisitor actionVisitor = new RHSActionVisitor(isDSLEnhanced, buf, indentation);
            for (IAction action : model.rhs) {
                actionVisitor.visit(action);
            }
        }
    }

    private Map<String, List<ActionFieldValue>> getRHSClassDependencies(RuleModel model) {
        if (model != null) {
            RHSClassDependencyVisitor dependencyVisitor = new RHSClassDependencyVisitor();
            for (IAction action : model.rhs) {
                dependencyVisitor.visit(action);
            }
            return dependencyVisitor.getRHSClasses();
        }
        Map<String, List<ActionFieldValue>> empty = Collections.emptyMap();
        return empty;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RHSClassDependencyVisitor
    extends ReflectiveVisitor {
        private Map<String, List<ActionFieldValue>> classes = new HashMap<String, List<ActionFieldValue>>();

        public void visitFreeFormLine(FreeFormLine ffl) {
        }

        public void visitActionGlobalCollectionAdd(ActionGlobalCollectionAdd add) {
        }

        public void visitActionRetractFact(ActionRetractFact action) {
        }

        public void visitDSLSentence(DSLSentence sentence) {
        }

        public void visitActionInsertFact(ActionInsertFact action) {
            this.getClasses(action.fieldValues);
        }

        public void visitActionInsertLogicalFact(ActionInsertLogicalFact action) {
            this.getClasses(action.fieldValues);
        }

        public void visitActionUpdateField(ActionUpdateField action) {
            this.getClasses(action.fieldValues);
        }

        public void visitActionSetField(ActionSetField action) {
            this.getClasses(action.fieldValues);
        }

        public Map<String, List<ActionFieldValue>> getRHSClasses() {
            return this.classes;
        }

        private void getClasses(ActionFieldValue[] fieldValues) {
            for (ActionFieldValue afv : fieldValues) {
                String type = afv.getType();
                List<ActionFieldValue> afvs = this.classes.get(type);
                if (afvs == null) {
                    afvs = new ArrayList<ActionFieldValue>();
                    this.classes.put(type, afvs);
                }
                afvs.add(afv);
            }
        }
    }

    public static class RHSActionVisitor
    extends ReflectiveVisitor {
        private StringBuilder buf;
        private boolean isDSLEnhanced;
        private String indentation;
        private int idx = 0;

        public RHSActionVisitor(boolean isDSLEnhanced, StringBuilder b, String indentation) {
            this.isDSLEnhanced = isDSLEnhanced;
            this.indentation = indentation;
            this.buf = b;
        }

        public void visitActionInsertFact(ActionInsertFact action) {
            this.generateInsertCall(action, false);
        }

        public void visitActionInsertLogicalFact(ActionInsertLogicalFact action) {
            this.generateInsertCall(action, true);
        }

        public void visitFreeFormLine(FreeFormLine ffl) {
            this.buf.append(this.indentation);
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            this.buf.append(ffl.text);
            this.buf.append("\n");
        }

        private void generateInsertCall(ActionInsertFact action, boolean isLogic) {
            this.buf.append(this.indentation);
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            if (action.fieldValues.length == 0 && action.getBoundName() == null) {
                this.buf.append(isLogic ? "insertLogical( new " : "insert( new ");
                this.buf.append(action.factType);
                this.buf.append("() );\n");
            } else {
                this.buf.append(action.factType);
                if (action.getBoundName() == null) {
                    this.buf.append(" fact");
                    this.buf.append(this.idx);
                } else {
                    this.buf.append(" " + action.getBoundName());
                }
                this.buf.append(" = new ");
                this.buf.append(action.factType);
                this.buf.append("();\n");
                if (action.getBoundName() == null) {
                    this.generateSetMethodCalls("fact" + this.idx, action.fieldValues);
                } else {
                    this.generateSetMethodCalls(action.getBoundName(), action.fieldValues);
                }
                this.buf.append(this.indentation);
                if (this.isDSLEnhanced) {
                    this.buf.append(">");
                }
                if (isLogic) {
                    this.buf.append("insertLogical(");
                    if (action.getBoundName() == null) {
                        this.buf.append("fact");
                        this.buf.append(this.idx++);
                    } else {
                        this.buf.append(action.getBoundName());
                    }
                    this.buf.append(" );\n");
                } else {
                    this.buf.append("insert(");
                    if (action.getBoundName() == null) {
                        this.buf.append("fact");
                        this.buf.append(this.idx++);
                    } else {
                        this.buf.append(action.getBoundName());
                    }
                    this.buf.append(" );\n");
                }
            }
        }

        public void visitActionUpdateField(ActionUpdateField action) {
            this.visitActionSetField(action);
            this.buf.append(this.indentation);
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            this.buf.append("update( ");
            this.buf.append(action.variable);
            this.buf.append(" );\n");
        }

        public void visitActionGlobalCollectionAdd(ActionGlobalCollectionAdd add) {
            this.buf.append(this.indentation);
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            this.buf.append(add.globalName + ".add(" + add.factName + ");\n");
        }

        public void visitActionRetractFact(ActionRetractFact action) {
            this.buf.append(this.indentation);
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            this.buf.append("retract( ");
            this.buf.append(action.variableName);
            this.buf.append(" );\n");
        }

        public void visitDSLSentence(DSLSentence sentence) {
            this.buf.append(this.indentation);
            this.buf.append(sentence.toString());
            this.buf.append("\n");
        }

        public void visitActionSetField(ActionSetField action) {
            if (action instanceof ActionCallMethod) {
                this.generateSetMethodCallsMethod((ActionCallMethod)action, action.fieldValues);
            } else {
                this.generateSetMethodCalls(action.variable, action.fieldValues);
            }
        }

        private void generateSetMethodCalls(String variableName, ActionFieldValue[] fieldValues) {
            for (int i = 0; i < fieldValues.length; ++i) {
                this.buf.append(this.indentation);
                if (this.isDSLEnhanced) {
                    this.buf.append(">");
                }
                this.buf.append(variableName);
                ActionFieldValue value = fieldValues[i];
                if (value instanceof ActionFieldFunction) {
                    this.buf.append(".");
                    this.buf.append(value.field);
                } else {
                    this.buf.append(".set");
                    this.buf.append(Character.toUpperCase(fieldValues[i].field.charAt(0)));
                    this.buf.append(fieldValues[i].field.substring(1));
                }
                this.buf.append("( ");
                if (fieldValues[i].isFormula()) {
                    this.buf.append(fieldValues[i].value.substring(1));
                } else if (fieldValues[i].nature == 7L) {
                    DRLConstraintValueBuilder.buildRHSFieldValue(this.buf, fieldValues[i].type, "@{" + fieldValues[i].value + "}");
                } else {
                    DRLConstraintValueBuilder.buildRHSFieldValue(this.buf, fieldValues[i].type, fieldValues[i].value);
                }
                this.buf.append(" );\n");
            }
        }

        private void generateSetMethodCallsMethod(ActionCallMethod action, FieldNature[] fieldValues) {
            this.buf.append(this.indentation);
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            this.buf.append(action.variable);
            this.buf.append(".");
            this.buf.append(action.methodName);
            this.buf.append("(");
            boolean isFirst = true;
            for (int i = 0; i < fieldValues.length; ++i) {
                ActionFieldFunction valueFunction = (ActionFieldFunction)fieldValues[i];
                if (isFirst) {
                    isFirst = false;
                } else {
                    this.buf.append(",");
                }
                this.buf.append(valueFunction.value);
            }
            this.buf.append(" );\n");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LHSPatternVisitor
    extends ReflectiveVisitor {
        private StringBuilder buf;
        private boolean isDSLEnhanced;
        private boolean isPatternNegated;
        private String indentation;

        public LHSPatternVisitor(boolean isDSLEnhanced, StringBuilder b, String indentation, boolean isPatternNegated) {
            this.isPatternNegated = isPatternNegated;
            this.isDSLEnhanced = isDSLEnhanced;
            this.indentation = indentation;
            this.buf = b;
        }

        public void visitFactPattern(FactPattern pattern) {
            this.buf.append(this.indentation);
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            this.generateFactPattern(pattern);
            if (this.isPatternNegated) {
                this.buf.append(" and ");
            }
            this.buf.append("\n");
        }

        public void visitFreeFormLine(FreeFormLine ffl) {
            this.buf.append(this.indentation);
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            this.buf.append(ffl.text);
            this.buf.append("\n");
        }

        public void visitCompositeFactPattern(CompositeFactPattern pattern) {
            this.buf.append(this.indentation);
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            if ("exists".equals(pattern.type)) {
                this.renderCompositeFOL(pattern);
            } else if ("not".equals(pattern.type)) {
                this.renderCompositeFOL(pattern);
            } else if ("or".equals(pattern.type)) {
                this.buf.append("( ");
                if (pattern.getPatterns() != null) {
                    for (int i = 0; i < pattern.getPatterns().length; ++i) {
                        if (i > 0) {
                            this.buf.append(" ");
                            this.buf.append(pattern.type);
                            this.buf.append(" ");
                        }
                        this.renderSubPattern(pattern, i);
                    }
                }
                this.buf.append(" )\n");
            }
        }

        public void visitFromCompositeFactPattern(FromCompositeFactPattern pattern) {
            this.buf.append(this.indentation);
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            if (pattern.getFactPattern() != null) {
                this.generateFactPattern(pattern.getFactPattern());
            }
            this.buf.append(" from ");
            this.renderExpression(pattern.getExpression());
            this.buf.append("\n");
        }

        public void visitFromCollectCompositeFactPattern(FromCollectCompositeFactPattern pattern) {
            this.buf.append(this.indentation);
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            if (pattern.getFactPattern() != null) {
                this.generateFactPattern(pattern.getFactPattern());
            }
            this.buf.append(" from collect ( ");
            if (pattern.getRightPattern() != null) {
                if (pattern.getRightPattern() instanceof FactPattern) {
                    this.generateFactPattern((FactPattern)pattern.getRightPattern());
                } else if (pattern.getRightPattern() instanceof FromAccumulateCompositeFactPattern) {
                    this.visitFromAccumulateCompositeFactPattern((FromAccumulateCompositeFactPattern)pattern.getRightPattern());
                } else if (pattern.getRightPattern() instanceof FromCollectCompositeFactPattern) {
                    this.visitFromCollectCompositeFactPattern((FromCollectCompositeFactPattern)pattern.getRightPattern());
                } else if (pattern.getRightPattern() instanceof FromCompositeFactPattern) {
                    this.visitFromCompositeFactPattern((FromCompositeFactPattern)pattern.getRightPattern());
                } else if (pattern.getRightPattern() instanceof FreeFormLine) {
                    this.visitFreeFormLine((FreeFormLine)pattern.getRightPattern());
                } else {
                    throw new IllegalArgumentException("Unsupported pattern " + pattern.getRightPattern() + " for FROM COLLECT");
                }
            }
            this.buf.append(") \n");
        }

        public void visitFromAccumulateCompositeFactPattern(FromAccumulateCompositeFactPattern pattern) {
            this.buf.append(this.indentation);
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            if (pattern.getFactPattern() != null) {
                this.generateFactPattern(pattern.getFactPattern());
            }
            this.buf.append(" from accumulate ( ");
            if (pattern.getSourcePattern() != null) {
                if (pattern.getSourcePattern() instanceof FactPattern) {
                    this.generateFactPattern((FactPattern)pattern.getSourcePattern());
                } else if (pattern.getSourcePattern() instanceof FromAccumulateCompositeFactPattern) {
                    this.visitFromAccumulateCompositeFactPattern((FromAccumulateCompositeFactPattern)pattern.getSourcePattern());
                } else if (pattern.getSourcePattern() instanceof FromCollectCompositeFactPattern) {
                    this.visitFromCollectCompositeFactPattern((FromCollectCompositeFactPattern)pattern.getSourcePattern());
                } else if (pattern.getSourcePattern() instanceof FromCompositeFactPattern) {
                    this.visitFromCompositeFactPattern((FromCompositeFactPattern)pattern.getSourcePattern());
                } else {
                    throw new IllegalArgumentException("Unsupported pattern " + pattern.getSourcePattern() + " for FROM ACCUMULATE");
                }
            }
            this.buf.append(",\n");
            if (pattern.useFunctionOrCode().equals("use_function")) {
                this.buf.append(this.indentation + "\t");
                this.buf.append(pattern.getFunction());
            } else {
                this.buf.append(this.indentation + "\tinit( ");
                this.buf.append(pattern.getInitCode());
                this.buf.append(" ),\n");
                this.buf.append(this.indentation + "\taction( ");
                this.buf.append(pattern.getActionCode());
                this.buf.append(" ),\n");
                if (pattern.getReverseCode() != null && !pattern.getReverseCode().trim().equals("")) {
                    this.buf.append(this.indentation + "\treverse( ");
                    this.buf.append(pattern.getReverseCode());
                    this.buf.append(" ),\n");
                }
                this.buf.append(this.indentation + "\tresult( ");
                this.buf.append(pattern.getResultCode());
                this.buf.append(" )\n");
            }
            this.buf.append(") \n");
        }

        public void visitFromEntryPointFactPattern(FromEntryPointFactPattern pattern) {
            this.buf.append(this.indentation);
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            if (pattern.getFactPattern() != null) {
                this.generateFactPattern(pattern.getFactPattern());
            }
            this.buf.append(" from entry-point \"" + pattern.getEntryPointName() + "\"\n");
        }

        private void renderCompositeFOL(CompositeFactPattern pattern) {
            this.buf.append(pattern.type);
            if (pattern.getPatterns() != null) {
                this.buf.append(" (");
                for (int i = 0; i < pattern.getPatterns().length; ++i) {
                    this.renderSubPattern(pattern, i);
                    if (i == pattern.getPatterns().length - 1) continue;
                    this.buf.append(" and ");
                }
                this.buf.append(") \n");
            }
        }

        private void renderSubPattern(CompositeFactPattern pattern, int subIndex) {
            if (pattern.getPatterns() == null || pattern.getPatterns().length == 0) {
                return;
            }
            IFactPattern subPattern = pattern.getPatterns()[subIndex];
            if (subPattern instanceof FactPattern) {
                this.generateFactPattern((FactPattern)subPattern);
            } else if (subPattern instanceof FromAccumulateCompositeFactPattern) {
                this.visitFromAccumulateCompositeFactPattern((FromAccumulateCompositeFactPattern)subPattern);
            } else if (subPattern instanceof FromCollectCompositeFactPattern) {
                this.visitFromCollectCompositeFactPattern((FromCollectCompositeFactPattern)subPattern);
            } else if (subPattern instanceof FromCompositeFactPattern) {
                this.visitFromCompositeFactPattern((FromCompositeFactPattern)subPattern);
            } else {
                throw new IllegalStateException("Unsupported Pattern: " + subPattern.getClass().getName());
            }
        }

        private void renderExpression(ExpressionFormLine expression) {
            this.buf.append(expression.getText());
        }

        public void visitDSLSentence(DSLSentence sentence) {
            this.buf.append(this.indentation);
            this.buf.append(sentence);
            this.buf.append("\n");
        }

        private void generateFactPattern(FactPattern pattern) {
            if (pattern.isNegated()) {
                this.buf.append("not ");
            } else if (pattern.getBoundName() != null) {
                this.buf.append(pattern.getBoundName());
                this.buf.append(" : ");
            }
            if (pattern.getFactType() != null) {
                this.buf.append(pattern.getFactType());
            }
            this.buf.append("( ");
            if (pattern.constraintList != null) {
                this.generateConstraints(pattern);
            }
            this.buf.append(")");
            CEPWindow window = pattern.getWindow();
            if (window.isDefined()) {
                this.buf.append(" ");
                this.buf.append(window.getOperator());
                this.buf.append((CharSequence)this.buildOperatorParameterDRL(window.getParameters()));
            }
        }

        private void generateConstraints(FactPattern pattern) {
            int printedCount = 0;
            for (int i = 0; i < pattern.getFieldConstraints().length; ++i) {
                StringBuilder buffer = new StringBuilder();
                this.generateConstraint(pattern.constraintList.constraints[i], false, buffer);
                if (buffer.length() <= 0) continue;
                if (printedCount > 0) {
                    this.buf.append(", ");
                }
                this.buf.append((CharSequence)buffer);
                ++printedCount;
            }
        }

        private void generateConstraint(FieldConstraint con, boolean nested, StringBuilder buf) {
            if (con instanceof CompositeFieldConstraint) {
                FieldConstraint[] nestedConstraints;
                CompositeFieldConstraint cfc = (CompositeFieldConstraint)con;
                if (nested) {
                    buf.append("( ");
                }
                if ((nestedConstraints = cfc.constraints) != null) {
                    for (int i = 0; i < nestedConstraints.length; ++i) {
                        this.generateConstraint(nestedConstraints[i], true, buf);
                        if (i >= nestedConstraints.length - 1) continue;
                        buf.append(cfc.compositeJunctionType + " ");
                    }
                }
                if (nested) {
                    buf.append(")");
                }
            } else {
                this.generateSingleFieldConstraint((SingleFieldConstraint)con, buf);
            }
        }

        private void generateSingleFieldConstraint(SingleFieldConstraint constr, StringBuilder buf) {
            if (constr.getConstraintValueType() == 5) {
                buf.append("eval( ");
                buf.append(constr.getValue());
                buf.append(" )");
            } else {
                if (constr.getFieldBinding() != null) {
                    buf.append(constr.getFieldBinding());
                    buf.append(" : ");
                }
                if (constr.getOperator() != null && (constr.getValue() != null || constr.getOperator().equals("== null") || constr.getOperator().equals("!= null")) || constr.getFieldBinding() != null || constr.getConstraintValueType() == 6 || constr instanceof SingleFieldConstraintEBLeftSide) {
                    StringBuilder parentBuf = new StringBuilder();
                    for (SingleFieldConstraint parent = (SingleFieldConstraint)constr.getParent(); parent != null; parent = (SingleFieldConstraint)parent.getParent()) {
                        parentBuf.insert(0, parent.getFieldName() + ".");
                    }
                    buf.append((CharSequence)parentBuf);
                    if (constr instanceof SingleFieldConstraintEBLeftSide) {
                        buf.append(((SingleFieldConstraintEBLeftSide)constr).getExpressionLeftSide().getText());
                    } else {
                        buf.append(constr.getFieldName());
                    }
                }
                Map<String, String> parameters = null;
                if (constr instanceof HasParameterizedOperator) {
                    SingleFieldConstraint hop = constr;
                    parameters = hop.getParameters();
                }
                if (constr instanceof SingleFieldConstraintEBLeftSide) {
                    SingleFieldConstraintEBLeftSide sfexp = (SingleFieldConstraintEBLeftSide)constr;
                    this.addFieldRestriction(buf, sfexp.getConstraintValueType(), sfexp.getExpressionLeftSide().getGenericType(), sfexp.getOperator(), parameters, sfexp.getValue(), sfexp.getExpressionValue());
                } else {
                    this.addFieldRestriction(buf, constr.getConstraintValueType(), constr.getFieldType(), constr.getOperator(), parameters, constr.getValue(), constr.getExpressionValue());
                }
                if (constr.connectives != null) {
                    for (int j = 0; j < constr.connectives.length; ++j) {
                        ConnectiveConstraint conn = constr.connectives[j];
                        parameters = null;
                        if (conn instanceof HasParameterizedOperator) {
                            ConnectiveConstraint hop = conn;
                            parameters = hop.getParameters();
                        }
                        this.addFieldRestriction(buf, conn.getConstraintValueType(), conn.getFieldType(), conn.getOperator(), parameters, conn.getValue(), null);
                    }
                }
            }
        }

        private void addFieldRestriction(StringBuilder buf, int type, String fieldType, String operator, Map<String, String> parameters, String value, ExpressionFormLine expression) {
            if (operator == null) {
                return;
            }
            buf.append(" ");
            buf.append(operator);
            if (parameters != null && parameters.size() > 0) {
                buf.append((CharSequence)this.buildOperatorParameterDRL(parameters));
            }
            buf.append(" ");
            switch (type) {
                case 3: {
                    buf.append("( ");
                    buf.append(value);
                    buf.append(" )");
                    break;
                }
                case 1: {
                    if (operator.equals("in") || operator.equals("not in")) {
                        buf.append(value);
                        break;
                    }
                    if (operator.equals("== null") || operator.equals("!= null")) break;
                    DRLConstraintValueBuilder.buildLHSFieldValue(buf, type, fieldType, value);
                    break;
                }
                case 6: {
                    if (expression == null) break;
                    buf.append(expression.getText());
                    break;
                }
                case 7: {
                    DRLConstraintValueBuilder.buildLHSFieldValue(buf, type, fieldType, "@{" + value + "}");
                    break;
                }
                case 4: {
                    DRLConstraintValueBuilder.buildLHSFieldValue(buf, type, fieldType, value);
                    break;
                }
                default: {
                    buf.append(value);
                }
            }
            buf.append(" ");
        }

        private StringBuilder buildOperatorParameterDRL(Map<String, String> parameters) {
            String className = parameters.get("org.drools.ide.common.server.util.BRDRLPersistence.operatorParameterGenerator");
            if (className == null) {
                throw new IllegalStateException("Implementation of 'org.drools.ide.common.server.util.OperatorParameterDRLBuilder' undefined. Unable to build Operator Parameter DRL.");
            }
            try {
                OperatorParameterDRLBuilder builder = (OperatorParameterDRLBuilder)Class.forName(className).newInstance();
                return builder.buildDRL(parameters);
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.fillInStackTrace();
                cnfe.printStackTrace(System.err);
                throw new IllegalStateException("Unable to generate Operator DRL using class '" + className + "'.");
            }
            catch (IllegalAccessException iae) {
                iae.fillInStackTrace();
                iae.printStackTrace(System.err);
                throw new IllegalStateException("Unable to generate Operator DRL using class '" + className + "'.");
            }
            catch (InstantiationException ie) {
                ie.fillInStackTrace();
                ie.printStackTrace(System.err);
                throw new IllegalStateException("Unable to generate Operator DRL using class '" + className + "'.");
            }
        }
    }
}

