/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.impl.refl.nodes;

import java.lang.reflect.Constructor;
import org.mvel2.DataConversion;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.impl.refl.nodes.BaseAccessor;
import org.mvel2.optimizers.impl.refl.nodes.GetterAccessor;

public class ConstructorAccessor
extends BaseAccessor {
    private Constructor constructor;
    private Class[] parmTypes;
    private ExecutableStatement[] parms;
    private int length;
    private boolean coercionNeeded = false;

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
        try {
            if (!this.coercionNeeded) {
                try {
                    if (this.nextNode != null) {
                        return this.nextNode.getValue(this.constructor.newInstance(this.executeAll(elCtx, variableFactory)), elCtx, variableFactory);
                    }
                    return this.constructor.newInstance(this.executeAll(elCtx, variableFactory));
                }
                catch (IllegalArgumentException e) {
                    this.coercionNeeded = true;
                    return this.getValue(ctx, elCtx, variableFactory);
                }
            }
            if (this.nextNode != null) {
                return this.nextNode.getValue(this.constructor.newInstance(this.executeAndCoerce(this.parmTypes, elCtx, variableFactory)), elCtx, variableFactory);
            }
            return this.constructor.newInstance(this.executeAndCoerce(this.parmTypes, elCtx, variableFactory));
        }
        catch (Exception e) {
            throw new RuntimeException("cannot construct object", e);
        }
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        return null;
    }

    private Object[] executeAll(Object ctx, VariableResolverFactory vars) {
        if (this.length == 0) {
            return GetterAccessor.EMPTY;
        }
        Object[] vals = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            vals[i] = this.parms[i].getValue(ctx, vars);
        }
        return vals;
    }

    private Object[] executeAndCoerce(Class[] target, Object elCtx, VariableResolverFactory vars) {
        Object[] values = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            values[i] = DataConversion.convert(this.parms[i].getValue(elCtx, vars), target[i]);
        }
        return values;
    }

    public ConstructorAccessor(Constructor constructor, ExecutableStatement[] parms) {
        this.constructor = constructor;
        this.parmTypes = constructor.getParameterTypes();
        this.length = this.parmTypes.length;
        this.parms = parms;
    }

    public Class getKnownEgressType() {
        return this.constructor.getClass();
    }
}

