/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.wsht;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.drools.SystemEventListenerFactory;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.jbpm.eventmessaging.EventResponseHandler;
import org.jbpm.eventmessaging.Payload;
import org.jbpm.task.AccessType;
import org.jbpm.task.Content;
import org.jbpm.task.Group;
import org.jbpm.task.I18NText;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.PeopleAssignments;
import org.jbpm.task.Status;
import org.jbpm.task.SubTasksStrategy;
import org.jbpm.task.SubTasksStrategyFactory;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.User;
import org.jbpm.task.event.TaskCompletedEvent;
import org.jbpm.task.event.TaskEvent;
import org.jbpm.task.event.TaskEventKey;
import org.jbpm.task.event.TaskFailedEvent;
import org.jbpm.task.event.TaskSkippedEvent;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.mina.MinaTaskClientConnector;
import org.jbpm.task.service.mina.MinaTaskClientHandler;
import org.jbpm.task.service.responsehandlers.AbstractBaseResponseHandler;

public class WSHumanTaskHandler
implements WorkItemHandler {
    private String ipAddress = "127.0.0.1";
    private int port = 9123;
    private TaskClient client;
    private WorkItemManager manager = null;

    public void setConnection(String ipAddress, int port) {
        this.ipAddress = ipAddress;
        this.port = port;
    }

    public void setClient(TaskClient client) {
        this.client = client;
    }

    public void connect() {
        if (this.client == null) {
            this.client = new TaskClient(new MinaTaskClientConnector("org.drools.process.workitem.wsht.WSHumanTaskHandler", new MinaTaskClientHandler(SystemEventListenerFactory.getSystemEventListener())));
            boolean connected = this.client.connect(this.ipAddress, this.port);
            if (!connected) {
                throw new IllegalArgumentException("Could not connect task client");
            }
        }
        TaskEventKey key = new TaskEventKey(TaskCompletedEvent.class, -1L);
        TaskCompletedHandler eventResponseHandler = new TaskCompletedHandler(this.manager, this.client);
        this.client.registerForEvent(key, false, eventResponseHandler);
        key = new TaskEventKey(TaskFailedEvent.class, -1L);
        this.client.registerForEvent(key, false, eventResponseHandler);
        key = new TaskEventKey(TaskSkippedEvent.class, -1L);
        this.client.registerForEvent(key, false, eventResponseHandler);
        System.out.println("Registered human task listener");
    }

    public void setManager(WorkItemManager manager) {
        this.manager = manager;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        ObjectOutputStream out;
        String groupId;
        String subTaskStrategiesCommaSeparated;
        String comment;
        if (this.manager == null) {
            this.manager = manager;
        } else if (this.manager != manager) {
            throw new IllegalArgumentException("This WSHumanTaskHandler can only be used for one WorkItemManager");
        }
        this.connect();
        Task task = new Task();
        String taskName = (String)workItem.getParameter("TaskName");
        if (taskName != null) {
            ArrayList<I18NText> names = new ArrayList<I18NText>();
            names.add(new I18NText("en-UK", taskName));
            task.setNames(names);
        }
        if ((comment = (String)workItem.getParameter("Comment")) != null) {
            ArrayList<I18NText> descriptions = new ArrayList<I18NText>();
            descriptions.add(new I18NText("en-UK", comment));
            task.setDescriptions(descriptions);
            ArrayList<I18NText> subjects = new ArrayList<I18NText>();
            subjects.add(new I18NText("en-UK", comment));
            task.setSubjects(subjects);
        }
        String priorityString = (String)workItem.getParameter("Priority");
        int priority = 0;
        if (priorityString != null) {
            try {
                priority = new Integer(priorityString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        task.setPriority(priority);
        TaskData taskData = new TaskData();
        taskData.setWorkItemId(workItem.getId());
        taskData.setProcessInstanceId(workItem.getProcessInstanceId());
        taskData.setSkipable(!"false".equals(workItem.getParameter("Skippable")));
        Long parentId = (Long)workItem.getParameter("ParentId");
        if (parentId != null) {
            taskData.setParentId(parentId);
        }
        if ((subTaskStrategiesCommaSeparated = (String)workItem.getParameter("SubTaskStrategies")) != null && !subTaskStrategiesCommaSeparated.equals("")) {
            String[] subTaskStrategies = subTaskStrategiesCommaSeparated.split(",");
            ArrayList<SubTasksStrategy> strategies = new ArrayList<SubTasksStrategy>();
            for (String subTaskStrategyString : subTaskStrategies) {
                SubTasksStrategy subTaskStrategy = SubTasksStrategyFactory.newStrategy(subTaskStrategyString);
                strategies.add(subTaskStrategy);
            }
            task.setSubTaskStrategies(strategies);
        }
        PeopleAssignments assignments = new PeopleAssignments();
        ArrayList<OrganizationalEntity> potentialOwners = new ArrayList<OrganizationalEntity>();
        String actorId = (String)workItem.getParameter("ActorId");
        if (actorId != null && actorId.trim().length() > 0) {
            String[] actorIds;
            for (String id : actorIds = actorId.split(",")) {
                potentialOwners.add(new User(id.trim()));
            }
            if (potentialOwners.size() > 0) {
                taskData.setCreatedBy((User)potentialOwners.get(0));
            }
        }
        if ((groupId = (String)workItem.getParameter("GroupId")) != null && groupId.trim().length() > 0) {
            String[] groupIds;
            for (String id : groupIds = groupId.split(",")) {
                potentialOwners.add(new Group(id.trim()));
            }
        }
        assignments.setPotentialOwners(potentialOwners);
        ArrayList<OrganizationalEntity> businessAdministrators = new ArrayList<OrganizationalEntity>();
        businessAdministrators.add(new User("Administrator"));
        assignments.setBusinessAdministrators(businessAdministrators);
        task.setPeopleAssignments(assignments);
        task.setTaskData(taskData);
        ContentData content = null;
        Object contentObject = workItem.getParameter("Content");
        if (contentObject != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                out = new ObjectOutputStream(bos);
                out.writeObject(contentObject);
                out.close();
                content = new ContentData();
                content.setContent(bos.toByteArray());
                content.setAccessType(AccessType.Inline);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            contentObject = workItem.getParameters();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                out = new ObjectOutputStream(bos);
                out.writeObject(contentObject);
                out.close();
                content = new ContentData();
                content.setContent(bos.toByteArray());
                content.setAccessType(AccessType.Inline);
                content.setType("java.util.map");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.client.addTask(task, content, null);
    }

    public void dispose() throws Exception {
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        AbortTaskResponseHandler abortTaskResponseHandler = new AbortTaskResponseHandler(this.client);
        this.client.getTaskByWorkItemId(workItem.getId(), abortTaskResponseHandler);
    }

    private static class AbortTaskResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.GetTaskResponseHandler {
        private TaskClient client;

        public AbortTaskResponseHandler(TaskClient client) {
            this.client = client;
        }

        public void execute(Task task) {
            if (task != null) {
                this.client.skip(task.getId(), "Administrator", null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetResultContentResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.GetContentResponseHandler {
        private WorkItemManager manager;
        private Task task;
        private Map<String, Object> results;

        public GetResultContentResponseHandler(WorkItemManager manager, Task task, Map<String, Object> results) {
            this.manager = manager;
            this.task = task;
            this.results = results;
        }

        @Override
        public void execute(Content content) {
            ByteArrayInputStream bis = new ByteArrayInputStream(content.getContent());
            try {
                ObjectInputStream in = new ObjectInputStream(bis);
                Object result = in.readObject();
                in.close();
                this.results.put("Result", result);
                if (result instanceof Map) {
                    Map map = (Map)result;
                    for (Map.Entry entry : map.entrySet()) {
                        if (!(entry.getKey() instanceof String)) continue;
                        this.results.put((String)entry.getKey(), entry.getValue());
                    }
                }
                this.manager.completeWorkItem(this.task.getTaskData().getWorkItemId(), this.results);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private static class GetCompletedTaskResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.GetTaskResponseHandler {
        private WorkItemManager manager;
        private TaskClient client;

        public GetCompletedTaskResponseHandler(WorkItemManager manager, TaskClient client) {
            this.manager = manager;
            this.client = client;
        }

        public void execute(Task task) {
            long workItemId = task.getTaskData().getWorkItemId();
            if (task.getTaskData().getStatus() == Status.Completed) {
                String userId = task.getTaskData().getActualOwner().getId();
                HashMap<String, Object> results = new HashMap<String, Object>();
                results.put("ActorId", userId);
                long contentId = task.getTaskData().getOutputContentId();
                if (contentId != -1L) {
                    GetResultContentResponseHandler getContentResponseHandler = new GetResultContentResponseHandler(this.manager, task, results);
                    this.client.getContent(contentId, getContentResponseHandler);
                } else {
                    this.manager.completeWorkItem(workItemId, results);
                }
            } else {
                this.manager.abortWorkItem(workItemId);
            }
        }
    }

    private static class TaskCompletedHandler
    extends AbstractBaseResponseHandler
    implements EventResponseHandler {
        private WorkItemManager manager;
        private TaskClient client;

        public TaskCompletedHandler(WorkItemManager manager, TaskClient client) {
            this.manager = manager;
            this.client = client;
        }

        public void execute(Payload payload) {
            TaskEvent event = (TaskEvent)payload.get();
            long taskId = event.getTaskId();
            System.out.println("Task completed " + taskId);
            GetCompletedTaskResponseHandler getTaskResponseHandler = new GetCompletedTaskResponseHandler(this.manager, this.client);
            this.client.getTask(taskId, getTaskResponseHandler);
        }

        public boolean isRemove() {
            return false;
        }
    }
}

