/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.timer;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.JobHandle;
import org.drools.time.TimerService;
import org.drools.time.Trigger;
import org.drools.time.impl.IntervalTrigger;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.timer.TimerInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerManager {
    private long timerId = 0L;
    private InternalKnowledgeRuntime kruntime;
    private TimerService timerService;
    private Map<Long, TimerInstance> timers = new HashMap<Long, TimerInstance>();
    private Job processJob = new ProcessJob();

    public TimerManager(InternalKnowledgeRuntime kruntime, TimerService timerService) {
        this.kruntime = kruntime;
        this.timerService = timerService;
    }

    public void registerTimer(TimerInstance timer, ProcessInstance processInstance) {
        timer.setId(++this.timerId);
        timer.setProcessInstanceId(processInstance.getId());
        timer.setActivated(new Date());
        ProcessJobContext ctx = new ProcessJobContext(timer, processInstance.getId(), this.kruntime);
        JobHandle jobHandle = this.timerService.scheduleJob(this.processJob, (JobContext)ctx, (Trigger)new IntervalTrigger(this.timerService.getCurrentTime(), null, null, -1, timer.getDelay(), timer.getPeriod(), null, null));
        timer.setJobHandle(jobHandle);
        this.timers.put(timer.getId(), timer);
    }

    public void internalAddTimer(TimerInstance timer) {
        long delay;
        ProcessJobContext ctx = new ProcessJobContext(timer, timer.getProcessInstanceId(), this.kruntime);
        Date lastTriggered = timer.getLastTriggered();
        if (lastTriggered == null) {
            Date activated = timer.getActivated();
            Date now = new Date();
            long timespan = now.getTime() - activated.getTime();
            delay = timer.getDelay() - timespan;
            if (delay < 0L) {
                delay = 0L;
            }
        } else {
            Date now = new Date();
            long timespan = now.getTime() - lastTriggered.getTime();
            delay = timespan - timer.getPeriod();
            if (delay < 0L) {
                delay = 0L;
            }
        }
        JobHandle jobHandle = this.timerService.scheduleJob(this.processJob, (JobContext)ctx, (Trigger)new IntervalTrigger(this.timerService.getCurrentTime(), null, null, -1, delay, timer.getPeriod(), null, null));
        timer.setJobHandle(jobHandle);
        this.timers.put(timer.getId(), timer);
    }

    public void cancelTimer(long timerId) {
        TimerInstance timer = this.timers.remove(timerId);
        if (timer != null) {
            this.timerService.removeJob(timer.getJobHandle());
        }
    }

    public void dispose() {
        for (TimerInstance timer : this.timers.values()) {
            this.timerService.removeJob(timer.getJobHandle());
        }
        this.timerService.shutdown();
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    public Collection<TimerInstance> getTimers() {
        return this.timers.values();
    }

    public long internalGetTimerId() {
        return this.timerId;
    }

    public void internalSetTimerId(long timerId) {
        this.timerId = timerId;
    }

    public void setTimerService(TimerService timerService) {
        this.timerService = timerService;
    }

    public static class ProcessJobContext
    implements JobContext {
        private Long processInstanceId;
        private InternalKnowledgeRuntime kruntime;
        private TimerInstance timer;
        private JobHandle jobHandle;

        public ProcessJobContext(TimerInstance timer, Long processInstanceId, InternalKnowledgeRuntime kruntime) {
            this.timer = timer;
            this.processInstanceId = processInstanceId;
            this.kruntime = kruntime;
        }

        public Long getProcessInstanceId() {
            return this.processInstanceId;
        }

        public InternalKnowledgeRuntime getKnowledgeRuntime() {
            return this.kruntime;
        }

        public JobHandle getJobHandle() {
            return this.jobHandle;
        }

        public void setJobHandle(JobHandle jobHandle) {
            this.jobHandle = jobHandle;
        }

        public TimerInstance getTimer() {
            return this.timer;
        }
    }

    public class ProcessJob
    implements Job {
        public void execute(JobContext c) {
            ProcessJobContext ctx = (ProcessJobContext)c;
            Long processInstanceId = ctx.getProcessInstanceId();
            InternalKnowledgeRuntime kruntime = ctx.getKnowledgeRuntime();
            if (processInstanceId == null) {
                throw new IllegalArgumentException("Could not find process instance for timer ");
            }
            ctx.getTimer().setLastTriggered(new Date());
            ((InternalProcessRuntime)kruntime.getProcessRuntime()).getSignalManager().signalEvent(processInstanceId, "timerTriggered", ctx.getTimer());
            if (ctx.getTimer().getPeriod() == 0L) {
                TimerManager.this.timers.remove(ctx.getTimer().getId());
            }
        }
    }
}

