/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.jndi.provider;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;

class DummyContext
extends Hashtable
implements Context,
Cloneable {
    private transient Hashtable environment;
    private static final NameParser nameParser = new FlatNameParser();

    DummyContext() {
        this((Hashtable)null);
    }

    DummyContext(Hashtable environment) {
        this.environment = environment == null ? new Hashtable() : (Hashtable)environment.clone();
    }

    protected String getComponentName(Name name) throws NamingException {
        if (name instanceof CompositeName) {
            if (name.size() > 1) {
                throw new InvalidNameException(name.toString() + " has more components than namespace can handle");
            }
            return name.get(0);
        }
        return name.toString();
    }

    protected Object getBoundObject(String name) throws NamingException {
        Object obj = this.get(name);
        if (obj == null) {
            throw new NameNotFoundException();
        }
        return obj;
    }

    public Object clone() {
        Object obj = super.clone();
        ((DummyContext)obj).environment = (Hashtable)this.environment.clone();
        return obj;
    }

    public void bind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("empty name");
        }
        String n = this.getComponentName(name);
        if (this.containsKey(n)) {
            throw new NameAlreadyBoundException();
        }
        this.put(n, obj);
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(new CompositeName(name), obj);
    }

    public void close() throws NamingException {
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name newName = (Name)prefix.clone();
        return newName.addAll(name);
    }

    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(new CompositeName(name), new CompositeName(prefix)).toString();
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("subcontexts are not supported");
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new CompositeName(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("subcontexts are not supported");
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new CompositeName(name));
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.environment.clone();
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return nameParser;
    }

    public NameParser getNameParser(String name) throws NamingException {
        return nameParser;
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new NamingEnum(this);
        }
        String n = this.getComponentName(name);
        Object obj = this.getBoundObject(n);
        if (obj instanceof Context) {
            return ((Context)obj).list("");
        }
        throw new NotContextException(name + " is not bound to a context");
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new BindingEnum(this);
        }
        String n = this.getComponentName(name);
        Object obj = this.getBoundObject(n);
        if (obj instanceof Context) {
            return ((Context)obj).listBindings("");
        }
        throw new NotContextException(name + " is not bound to a context");
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    public Object lookup(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this.clone();
        }
        String n = this.getComponentName(name);
        return this.getBoundObject(n);
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(new CompositeName(name));
    }

    public void rebind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("empty name");
        }
        String n = this.getComponentName(name);
        this.put(n, obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new CompositeName(name), obj);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.environment.remove(propName);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        if (oldName.isEmpty() || newName.isEmpty()) {
            throw new InvalidNameException("empty name");
        }
        Object obj = this.lookup(oldName);
        this.bind(newName, obj);
        this.unbind(oldName);
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.rename(new CompositeName(oldName), new CompositeName(newName));
    }

    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("empty name");
        }
        String n = this.getComponentName(name);
        this.remove(n);
    }

    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.environment.put(propName, propVal);
    }

    class BindingEnum
    extends NamingEnum {
        BindingEnum(Hashtable bindings) {
            super(bindings);
        }

        public Object nextElement() {
            String name = (String)this.namesEnum.nextElement();
            return new Binding(name, this.bindings.get(name));
        }
    }

    class NamingEnum
    implements NamingEnumeration {
        protected Enumeration namesEnum;
        protected Hashtable bindings;

        NamingEnum(Hashtable bindings) {
            this.namesEnum = bindings.keys();
            this.bindings = bindings;
        }

        public boolean hasMoreElements() {
            return this.namesEnum.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public Object nextElement() {
            String name = (String)this.namesEnum.nextElement();
            String className = this.bindings.get(name).getClass().getName();
            return new NameClassPair(name, className);
        }

        public void close() throws NamingException {
        }
    }

    static class FlatNameParser
    implements NameParser {
        private static final Properties syntax = new Properties();

        FlatNameParser() {
        }

        public Name parse(String name) throws NamingException {
            return new CompoundName(name, syntax);
        }

        static {
            syntax.put("jndi.syntax.direction", "flat");
            syntax.put("jndi.syntax.ignorecase", "false");
        }
    }
}

