/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.pool;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.jackrabbit.core.persistence.pool.DbNameIndex;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.DbUtility;

public class PostgreSQLNameIndex
extends DbNameIndex {
    protected String generatedKeySelectSQL;

    public PostgreSQLNameIndex(ConnectionHelper connectionHelper, String schemaObjectPrefix) throws SQLException {
        super(connectionHelper, schemaObjectPrefix);
    }

    protected void init(String schemaObjectPrefix) throws SQLException {
        this.nameSelectSQL = "select NAME from " + schemaObjectPrefix + "NAMES where ID = ?";
        this.indexSelectSQL = "select ID from " + schemaObjectPrefix + "NAMES where NAME = ?";
        this.nameInsertSQL = "insert into " + schemaObjectPrefix + "NAMES (NAME) values (?)";
        this.generatedKeySelectSQL = "select currval('" + schemaObjectPrefix + "NAMES_ID_SEQ')";
    }

    protected int insertString(String string) {
        try {
            this.conHelper.exec(this.nameInsertSQL, string);
            return this.getGeneratedKey();
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException("Unable to insert index for string: " + string);
            ise.initCause(e);
            throw ise;
        }
    }

    protected int getGeneratedKey() {
        int n;
        ResultSet rs;
        block5: {
            rs = null;
            rs = this.conHelper.exec(this.generatedKeySelectSQL, (Object[])null, false, 0);
            if (rs.next()) break block5;
            int n2 = -1;
            DbUtility.close(rs);
            return n2;
        }
        try {
            n = rs.getInt(1);
        }
        catch (Exception e) {
            try {
                IllegalStateException ise = new IllegalStateException("Unable to read generated index");
                ise.initCause(e);
                throw ise;
            }
            catch (Throwable throwable) {
                DbUtility.close(rs);
                throw throwable;
            }
        }
        DbUtility.close(rs);
        return n;
    }
}

