/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.security.authentication.CryptedSimpleCredentials;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.core.security.user.AuthorizableImpl;
import org.apache.jackrabbit.core.security.user.ImpersonationImpl;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;

public class UserImpl
extends AuthorizableImpl
implements User {
    private Principal principal;
    private Impersonation impersonation;

    protected UserImpl(NodeImpl node, UserManagerImpl userManager) throws RepositoryException {
        super(node, userManager);
    }

    static String buildPasswordValue(String password) throws RepositoryException {
        try {
            return new CryptedSimpleCredentials("_", password).getPassword();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public boolean isAdmin() {
        try {
            return this.userManager.isAdminId(this.getID());
        }
        catch (RepositoryException e) {
            log.error("Internal error while retrieving UserID.", (Throwable)e);
            return false;
        }
    }

    public Credentials getCredentials() throws RepositoryException {
        try {
            String password = this.getNode().getProperty(P_PASSWORD).getString();
            return new CryptedSimpleCredentials(this.getID(), password);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public boolean isGroup() {
        return false;
    }

    public Principal getPrincipal() throws RepositoryException {
        if (this.principal == null) {
            this.principal = this.isAdmin() ? new NodeBasedAdminPrincipal(this.getPrincipalName()) : new AuthorizableImpl.NodeBasedPrincipal(this, this.getPrincipalName());
        }
        return this.principal;
    }

    public Impersonation getImpersonation() throws RepositoryException {
        if (this.impersonation == null) {
            this.impersonation = new ImpersonationImpl(this, this.userManager);
        }
        return this.impersonation;
    }

    public void changePassword(String password) throws RepositoryException {
        Value v = this.getSession().getValueFactory().createValue(UserImpl.buildPasswordValue(password));
        this.userManager.setProtectedProperty(this.getNode(), P_PASSWORD, v);
    }

    private class NodeBasedAdminPrincipal
    extends AdminPrincipal
    implements ItemBasedPrincipal {
        public NodeBasedAdminPrincipal(String adminId) {
            super(adminId);
        }

        public String getPath() throws RepositoryException {
            return UserImpl.this.getNode().getPath();
        }
    }
}

