/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.components;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.verifier.components.Consequence;
import org.drools.verifier.components.Possibility;
import org.drools.verifier.components.RuleComponent;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.components.VerifierRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubRule
extends RuleComponent
implements Serializable,
Possibility {
    private static final long serialVersionUID = 510L;
    private Set<RuleComponent> items = new HashSet<RuleComponent>();
    private final VerifierRule rule;

    public SubRule(VerifierRule rule, int orderNumber) {
        super(rule);
        this.rule = rule;
        this.setOrderNumber(orderNumber);
    }

    @Override
    public String getPath() {
        return String.format("%s/subRule[%s]", this.getRulePath(), this.getOrderNumber());
    }

    public Set<RuleComponent> getItems() {
        return this.items;
    }

    @Override
    public int getAmountOfItems() {
        return this.items.size();
    }

    public void add(RuleComponent ruleComponent) {
        this.items.add(ruleComponent);
    }

    public VerifierRule getRule() {
        return this.rule;
    }

    public String getConsequencePath() {
        return this.rule.getConsequencePath();
    }

    public Consequence.ConsequenceType getConsequenceType() {
        return this.rule.getConsequenceType();
    }

    public Map<String, String> getAttributes() {
        return this.rule.getAttributes();
    }

    @Override
    public String toString() {
        return "SubRule from rule: " + this.getRuleName() + ", amount of items:" + this.items.size();
    }

    @Override
    public VerifierComponentType getVerifierComponentType() {
        return VerifierComponentType.SUB_RULE;
    }
}

