/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse;

import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.RuleBaseConfiguration;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.util.ProjectClassLoader;
import org.drools.process.core.WorkDefinition;
import org.drools.process.core.datatype.DataType;
import org.drools.process.core.impl.ParameterDefinitionImpl;
import org.drools.process.core.impl.WorkDefinitionExtensionImpl;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkItemDefinitions {
    private WorkItemDefinitions() {
    }

    public static Map<String, WorkDefinition> getWorkDefinitions(IResource resource) {
        IProject project = resource.getProject();
        if (project != null) {
            try {
                IJavaProject javaProject;
                if (project.getNature("org.eclipse.jdt.core.javanature") != null && (javaProject = JavaCore.create((IProject)project)) != null && javaProject.exists()) {
                    return WorkItemDefinitions.getWorkDefinitions(javaProject);
                }
            }
            catch (CoreException e) {
                DroolsEclipsePlugin.log(e);
            }
        }
        return null;
    }

    public static Map<String, WorkDefinition> getWorkDefinitions(IJavaProject project) {
        if (project != null) {
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            URLClassLoader newLoader = ProjectClassLoader.getProjectClassLoader(project);
            try {
                HashMap<String, WorkDefinition> workDefinitions = new HashMap<String, WorkDefinition>();
                Thread.currentThread().setContextClassLoader(newLoader);
                List workDefinitionsMaps = new RuleBaseConfiguration().getWorkDefinitions();
                for (Map workDefinitionMap : workDefinitionsMaps) {
                    if (workDefinitionMap == null) continue;
                    WorkDefinitionExtensionImpl workDefinition = new WorkDefinitionExtensionImpl();
                    workDefinition.setName((String)workDefinitionMap.get("name"));
                    workDefinition.setDisplayName((String)workDefinitionMap.get("displayName"));
                    workDefinition.setIcon((String)workDefinitionMap.get("icon"));
                    workDefinition.setCustomEditor((String)workDefinitionMap.get("customEditor"));
                    HashSet<ParameterDefinitionImpl> parameters = new HashSet<ParameterDefinitionImpl>();
                    Map parameterMap = (Map)workDefinitionMap.get("parameters");
                    if (parameterMap != null) {
                        for (Map.Entry entry : parameterMap.entrySet()) {
                            parameters.add(new ParameterDefinitionImpl((String)entry.getKey(), (DataType)entry.getValue()));
                        }
                    }
                    workDefinition.setParameters(parameters);
                    HashSet<ParameterDefinitionImpl> results = new HashSet<ParameterDefinitionImpl>();
                    Map resultMap = (Map)workDefinitionMap.get("results");
                    if (resultMap != null) {
                        for (Map.Entry entry : resultMap.entrySet()) {
                            results.add(new ParameterDefinitionImpl((String)entry.getKey(), (DataType)entry.getValue()));
                        }
                    }
                    workDefinition.setResults(results);
                    workDefinitions.put(workDefinition.getName(), (WorkDefinition)workDefinition);
                }
                HashMap<String, WorkDefinition> hashMap = workDefinitions;
                return hashMap;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
        return new HashMap<String, WorkDefinition>();
    }
}

