/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.rete;

import java.util.ArrayList;
import java.util.List;
import org.drools.eclipse.editors.rete.Row;
import org.drools.reteoo.BaseVertex;

public class RowList {
    private List rows = new ArrayList();

    public void add(int depth, BaseVertex vertex) {
        if (this.rows.size() < depth + 1) {
            int addRows = depth - this.rows.size() + 1;
            int i = 0;
            while (i < addRows) {
                this.rows.add(new Row(depth - addRows + i));
                ++i;
            }
        }
        ((Row)this.rows.get(depth)).add(vertex);
    }

    public int getDepth() {
        return this.rows.size();
    }

    public Row get(int row) {
        return (Row)this.rows.get(row);
    }

    public int getRow(BaseVertex vertex) {
        int numRows = this.rows.size();
        int i = 0;
        while (i < numRows) {
            if (((Row)this.rows.get(i)).contains(vertex)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getWidth() {
        int width = 0;
        for (Row row : this.rows) {
            int rowWidth = row.getWidth();
            if (rowWidth <= width) continue;
            width = rowWidth;
        }
        return width;
    }

    public int getWidth(int row) {
        return ((Row)this.rows.get(row)).getWidth();
    }

    public int getColumn(BaseVertex vertex) {
        int row = this.getRow(vertex);
        if (row < 0) {
            return -1;
        }
        List rowVertices = this.get(row).getVertices();
        int numCols = rowVertices.size();
        int i = 0;
        while (i < numCols) {
            if (rowVertices.get(i).equals(vertex)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void dump() {
        int numRows = this.rows.size();
        int i = 0;
        while (i < numRows) {
            System.err.println(String.valueOf(i) + ": " + this.get(i).getVertices());
            ++i;
        }
    }

    public void optimize() {
        int numRows = this.rows.size();
        int i = 0;
        while (i < numRows) {
            this.get(i).optimize();
            ++i;
        }
    }
}

