/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.core.command;

import java.util.List;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.eclipse.gef.commands.Command;

public class ReconnectElementConnectionSourceCommand
extends Command {
    private ElementConnection connection;
    private ElementWrapper target;
    private ElementWrapper oldSource;
    private ElementWrapper newSource;

    public boolean canExecute() {
        if (this.connection.getTarget().equals(this.newSource)) {
            return false;
        }
        List<ElementConnection> connections = this.newSource.getOutgoingConnections();
        int i = 0;
        while (i < connections.size()) {
            ElementConnection connection = connections.get(i);
            if (connection.getTarget().equals(this.target) && !connection.getSource().equals(this.oldSource)) {
                return false;
            }
            ++i;
        }
        return this.newSource.acceptsOutgoingConnection(this.connection, this.target);
    }

    public void execute() {
        if (this.newSource != null) {
            this.connection.disconnect();
            this.connection.connect(this.newSource, this.target);
        }
    }

    public void setSource(ElementWrapper source) {
        this.newSource = source;
    }

    public void setConnection(ElementConnection connection) {
        this.connection = connection;
        this.target = connection.getTarget();
        this.oldSource = connection.getSource();
    }

    public void undo() {
        this.connection.disconnect();
        this.connection.connect(this.oldSource, this.target);
    }

    public void redo() {
        this.connection.disconnect();
        this.connection.connect(this.newSource, this.target);
    }
}

