/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.view.datatype.editor.impl;

import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.flow.common.datatype.DataTypeRegistry;
import org.drools.process.core.datatype.DataType;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DataTypeCombo
extends Composite {
    private DataTypeRegistry registry;
    private ComboViewer dataTypeCombo;

    public DataTypeCombo(Composite parent, int style, DataTypeRegistry registry) {
        super(parent, style);
        this.registry = registry;
        this.setLayout((Layout)new FillLayout());
        this.dataTypeCombo = new ComboViewer((Composite)this, 8);
        this.dataTypeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((DataTypeRegistry.IDataTypeInfo)element).getName();
            }
        });
        this.dataTypeCombo.add((Object[])registry.getDataTypes().toArray(new DataTypeRegistry.IDataTypeInfo[0]));
    }

    private DataTypeRegistry.IDataTypeInfo getSelectedTypeInfo() {
        ISelection selection = this.dataTypeCombo.getSelection();
        if (!selection.isEmpty()) {
            return (DataTypeRegistry.IDataTypeInfo)((StructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    public void setDataType(DataType dataType) {
        if (dataType == null) {
            this.dataTypeCombo.setSelection(null);
        } else {
            try {
                this.dataTypeCombo.setSelection((ISelection)new StructuredSelection((Object)this.registry.getDataTypeInfo(dataType.getClass())));
            }
            catch (IllegalArgumentException e) {
                DroolsEclipsePlugin.log(e);
            }
        }
    }

    public DataType getDataType() {
        DataTypeRegistry.IDataTypeInfo dataTypeInfo = this.getSelectedTypeInfo();
        return dataTypeInfo == null ? null : dataTypeInfo.getDataTypeFactory().createDataType();
    }

    public void reset() {
        this.dataTypeCombo.setSelection(null);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.dataTypeCombo.getCombo().setEnabled(enabled);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.dataTypeCombo.addSelectionChangedListener(listener);
    }
}

