/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.IOException;
import java.io.InputStream;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.RuntimeDroolsException;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.rule.Package;

public class BinaryRuleBaseLoader {
    private RuleBase ruleBase;
    private ClassLoader classLoader;

    public BinaryRuleBaseLoader() {
        this(RuleBaseFactory.newRuleBase(), null);
    }

    public BinaryRuleBaseLoader(RuleBase rb) {
        this(rb, null);
    }

    public BinaryRuleBaseLoader(RuleBase rb, ClassLoader classLoader) {
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.ruleBase = rb;
        this.classLoader = classLoader;
    }

    public void addPackage(InputStream in) {
        this.addPackage(in, this.classLoader);
    }

    public void addPackage(InputStream in, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = this.classLoader;
        }
        try {
            Object opkg = DroolsStreamUtils.streamIn(in, classLoader);
            if (!(opkg instanceof Package)) {
                throw new IllegalArgumentException("Can only add instances of org.drools.rule.Package to a rulebase instance.");
            }
            Package binPkg = (Package)opkg;
            if (!binPkg.isValid()) {
                throw new IllegalArgumentException("Can't add a non valid package to a rulebase.");
            }
            try {
                this.ruleBase.addPackage(binPkg);
            }
            catch (Exception e) {
                throw new RuntimeDroolsException("Unable to add package to the rulebase.", e);
            }
        }
        catch (IOException e) {
            throw new RuntimeDroolsException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public RuleBase getRuleBase() {
        return this.ruleBase;
    }
}

