/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BaseNode;
import org.drools.common.BetaConstraints;
import org.drools.common.EmptyBetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.core.util.FastIterator;
import org.drools.core.util.LeftTupleList;
import org.drools.core.util.LinkedList;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.ContextEntry;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.DataProvider;
import org.drools.spi.PropagationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FromNode
extends LeftTupleSource
implements LeftTupleSinkNode,
NodeMemory {
    private static final long serialVersionUID = 510L;
    private DataProvider dataProvider;
    private LeftTupleSource tupleSource;
    private AlphaNodeFieldConstraint[] alphaConstraints;
    private BetaConstraints betaConstraints;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    protected boolean tupleMemoryEnabled;

    public FromNode() {
    }

    public FromNode(int id, DataProvider dataProvider, LeftTupleSource tupleSource, AlphaNodeFieldConstraint[] constraints, BetaConstraints binder, boolean tupleMemoryEnabled, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.dataProvider = dataProvider;
        this.tupleSource = tupleSource;
        this.alphaConstraints = constraints;
        this.betaConstraints = binder == null ? EmptyBetaConstraints.getInstance() : binder;
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.dataProvider = (DataProvider)in.readObject();
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.alphaConstraints = (AlphaNodeFieldConstraint[])in.readObject();
        this.betaConstraints = (BetaConstraints)in.readObject();
        this.tupleMemoryEnabled = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.dataProvider);
        out.writeObject(this.tupleSource);
        out.writeObject(this.alphaConstraints);
        out.writeObject(this.betaConstraints);
        out.writeBoolean(this.tupleMemoryEnabled);
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        FromMemory memory = (FromMemory)workingMemory.getNodeMemory(this);
        LinkedHashMap<Object, RightTuple> matches = null;
        if (this.tupleMemoryEnabled) {
            memory.betaMemory.getLeftTupleMemory().add(leftTuple);
            matches = new LinkedHashMap<Object, RightTuple>();
            memory.betaMemory.getCreatedHandles().put(leftTuple, matches);
        }
        this.betaConstraints.updateFromTuple(memory.betaMemory.getContext(), workingMemory, leftTuple);
        Iterator it = this.dataProvider.getResults(leftTuple, workingMemory, context, memory.providerContext);
        while (it.hasNext()) {
            Object object = it.next();
            InternalFactHandle handle = workingMemory.getFactHandleFactory().newFactHandle(object, null, workingMemory, null);
            RightTuple rightTuple = new RightTuple(handle, null);
            this.checkConstraintsAndPropagate(leftTuple, rightTuple, context, workingMemory, memory);
            if (!this.tupleMemoryEnabled) continue;
            this.addToCreatedHandlesMap(matches, rightTuple);
        }
        this.betaConstraints.resetTuple(memory.betaMemory.getContext());
    }

    private void addToCreatedHandlesMap(Map<Object, RightTuple> matches, RightTuple rightTuple) {
        if (rightTuple.getFactHandle().isValid()) {
            Object object = rightTuple.getFactHandle().getObject();
            RightTuple existingMatch = matches.get(object);
            if (existingMatch != null) {
                rightTuple.setNext(existingMatch);
            }
            matches.put(object, rightTuple);
        }
    }

    @Override
    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple leftTuple = modifyPreviousTuples.removeLeftTuple(this);
        if (leftTuple != null) {
            leftTuple.reAdd();
            this.modifyLeftTuple(leftTuple, context, workingMemory);
        } else {
            this.assertLeftTuple(new LeftTuple(factHandle, (LeftTupleSink)this, true), context, workingMemory);
        }
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        FromMemory memory = (FromMemory)workingMemory.getNodeMemory(this);
        memory.betaMemory.getLeftTupleMemory().removeAdd(leftTuple);
        Map previousMatches = (Map)memory.betaMemory.getCreatedHandles().remove(leftTuple);
        LinkedHashMap<Object, RightTuple> newMatches = new LinkedHashMap<Object, RightTuple>();
        memory.betaMemory.getCreatedHandles().put(leftTuple, newMatches);
        this.betaConstraints.updateFromTuple(memory.betaMemory.getContext(), workingMemory, leftTuple);
        FastIterator rightIt = LinkedList.fastIterator;
        Iterator it = this.dataProvider.getResults(leftTuple, workingMemory, context, memory.providerContext);
        while (it.hasNext()) {
            Object object = it.next();
            RightTuple rightTuple = (RightTuple)previousMatches.remove(object);
            if (rightTuple == null) {
                InternalFactHandle handle = workingMemory.getFactHandleFactory().newFactHandle(object, null, workingMemory, null);
                rightTuple = new RightTuple(handle, null);
            } else if (rightIt.next(rightTuple) != null) {
                previousMatches.put(object, (RightTuple)rightIt.next(rightTuple));
                rightTuple.setNext(null);
            }
            this.checkConstraintsAndPropagate(leftTuple, rightTuple, context, workingMemory, memory);
            this.addToCreatedHandlesMap(newMatches, rightTuple);
        }
        this.betaConstraints.resetTuple(memory.betaMemory.getContext());
        Iterator i$ = previousMatches.values().iterator();
        while (i$.hasNext()) {
            RightTuple rightTuple;
            RightTuple current = rightTuple = (RightTuple)i$.next();
            while (current != null) {
                this.retractMatchAndDestroyHandle(leftTuple, current, context, workingMemory);
                current = (RightTuple)rightIt.next(current);
            }
        }
    }

    private void checkConstraintsAndPropagate(LeftTuple leftTuple, RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory, FromMemory memory) {
        boolean isAllowed = true;
        if (this.alphaConstraints != null) {
            int length = this.alphaConstraints.length;
            for (int i = 0; i < length; ++i) {
                if (this.alphaConstraints[i].isAllowed(rightTuple.getFactHandle(), workingMemory, memory.alphaContexts[i])) continue;
                isAllowed = false;
                break;
            }
        }
        if (isAllowed && this.betaConstraints.isAllowedCachedLeft(memory.betaMemory.getContext(), rightTuple.getFactHandle())) {
            if (rightTuple.firstChild == null) {
                this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, null, null, context, workingMemory, this.tupleMemoryEnabled);
            } else {
                this.sink.propagateModifyChildLeftTuple(rightTuple.firstChild, leftTuple, context, workingMemory, this.tupleMemoryEnabled);
            }
        } else {
            this.retractMatchAndDestroyHandle(leftTuple, rightTuple, context, workingMemory);
        }
    }

    private void retractMatchAndDestroyHandle(LeftTuple leftTuple, RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (rightTuple.firstChild != null) {
            this.sink.propagateRetractChildLeftTuple(rightTuple.firstChild, leftTuple, context, workingMemory);
        }
        workingMemory.getFactHandleFactory().destroyFactHandle(rightTuple.getFactHandle());
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        FromMemory memory = (FromMemory)workingMemory.getNodeMemory(this);
        memory.betaMemory.getLeftTupleMemory().remove(leftTuple);
        this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
        this.destroyCreatedHandles(workingMemory, memory, leftTuple);
    }

    private void destroyCreatedHandles(InternalWorkingMemory workingMemory, FromMemory memory, LeftTuple leftTuple) {
        Map matches = (Map)memory.betaMemory.getCreatedHandles().remove(leftTuple);
        FastIterator rightIt = LinkedList.fastIterator;
        Iterator i$ = matches.values().iterator();
        while (i$.hasNext()) {
            RightTuple rightTuple;
            RightTuple current = rightTuple = (RightTuple)i$.next();
            while (current != null) {
                RightTuple next = (RightTuple)rightIt.next(current);
                workingMemory.getFactHandleFactory().destroyFactHandle(current.getFactHandle());
                current.unlinkFromRightParent();
                current = next;
            }
        }
    }

    @Override
    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    @Override
    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        for (InternalWorkingMemory workingMemory : workingMemories) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    @Override
    public void networkUpdated() {
        this.tupleSource.networkUpdated();
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (!node.isInUse()) {
            this.removeTupleSink((LeftTupleSink)((Object)node));
        }
        if (!this.isInUse()) {
            for (InternalWorkingMemory workingMemory : workingMemories) {
                FromMemory memory = (FromMemory)workingMemory.getNodeMemory(this);
                org.drools.core.util.Iterator it = memory.betaMemory.getLeftTupleMemory().iterator();
                LeftTuple leftTuple = (LeftTuple)it.next();
                while (leftTuple != null) {
                    this.destroyCreatedHandles(workingMemory, memory, leftTuple);
                    leftTuple.unlinkFromLeftParent();
                    leftTuple.unlinkFromRightParent();
                    leftTuple = (LeftTuple)it.next();
                }
                workingMemory.clearNodeMemory(this);
            }
        }
        this.tupleSource.remove(context, builder, this, workingMemories);
    }

    @Override
    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        FromMemory memory = (FromMemory)workingMemory.getNodeMemory(this);
        FastIterator rightIter = LinkedList.fastIterator;
        org.drools.core.util.Iterator tupleIter = memory.betaMemory.getLeftTupleMemory().iterator();
        LeftTuple leftTuple = (LeftTuple)tupleIter.next();
        while (leftTuple != null) {
            Map matches = (Map)memory.betaMemory.getCreatedHandles().get(leftTuple);
            Iterator i$ = matches.values().iterator();
            while (i$.hasNext()) {
                RightTuple rightTuples;
                RightTuple rightTuple = rightTuples = (RightTuple)i$.next();
                while (rightTuple != null) {
                    sink.assertLeftTuple(new LeftTuple(leftTuple, rightTuple, null, null, sink, this.tupleMemoryEnabled), context, workingMemory);
                    rightTuple = (RightTuple)rightIter.next(rightTuples);
                }
            }
            leftTuple = (LeftTuple)tupleIter.next();
        }
    }

    @Override
    public Object createMemory(RuleBaseConfiguration config) {
        BetaMemory beta = new BetaMemory(new LeftTupleList(), null, this.betaConstraints.createContext());
        return new FromMemory(beta, this.dataProvider.createContext(), this.alphaConstraints);
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public short getType() {
        return 4;
    }

    public static class FromMemory
    implements Serializable {
        private static final long serialVersionUID = 510L;
        public BetaMemory betaMemory;
        public Object providerContext;
        public ContextEntry[] alphaContexts;

        public FromMemory(BetaMemory betaMemory, Object providerContext, AlphaNodeFieldConstraint[] constraints) {
            this.betaMemory = betaMemory;
            this.providerContext = providerContext;
            this.alphaContexts = new ContextEntry[constraints.length];
            for (int i = 0; i < constraints.length; ++i) {
                this.alphaContexts[i] = constraints[i].createContextEntry();
            }
        }
    }
}

