/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder;

import org.drools.base.ArrayElements;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.base.FieldFactory;
import org.drools.base.ValueType;
import org.drools.base.evaluators.Operator;
import org.drools.base.extractors.ArrayElementReader;
import org.drools.compiler.DescrBuildError;
import org.drools.lang.descr.QueryDescr;
import org.drools.rule.Declaration;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.Pattern;
import org.drools.rule.Query;
import org.drools.rule.builder.EngineElementBuilder;
import org.drools.rule.builder.PatternBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.spi.AcceptsReadAccessor;
import org.drools.spi.Constraint;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;
import org.drools.type.DateFormats;

public class QueryBuilder
implements EngineElementBuilder {
    public Pattern build(RuleBuildContext context, QueryDescr queryDescr) {
        ClassObjectType queryObjectType = new ClassObjectType(DroolsQuery.class);
        Pattern pattern = new Pattern(context.getNextPatternId(), 0, (ObjectType)queryObjectType, null);
        InternalReadAccessor extractor = PatternBuilder.getFieldReadAccessor(context, queryDescr, (ObjectType)queryObjectType, "name", null, true);
        FieldValue field = FieldFactory.getFieldValue((String)queryDescr.getName(), (ValueType)ValueType.STRING_TYPE, (DateFormats)context.getPackageBuilder().getDateFormats());
        LiteralConstraint constraint = new LiteralConstraint(extractor, context.getConfiguration().getEvaluatorRegistry().getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL), field);
        PatternBuilder.registerReadAccessor(context, (ObjectType)queryObjectType, "name", (AcceptsReadAccessor)constraint);
        pattern.addConstraint((Constraint)constraint);
        ClassObjectType argsObjectType = new ClassObjectType(ArrayElements.class);
        InternalReadAccessor arrayExtractor = PatternBuilder.getFieldReadAccessor(context, queryDescr, (ObjectType)argsObjectType, "elements", null, true);
        String[] params = queryDescr.getParameters();
        String[] types = queryDescr.getParameterTypes();
        int i = 0;
        Declaration[] declarations = new Declaration[params.length];
        try {
            for (i = 0; i < params.length; ++i) {
                Declaration declr = pattern.addDeclaration(params[i]);
                ArrayElementReader reader = new ArrayElementReader(arrayExtractor, i, context.getDialect().getTypeResolver().resolveType(types[i]));
                PatternBuilder.registerReadAccessor(context, (ObjectType)argsObjectType, "elements", (AcceptsReadAccessor)reader);
                declr.setReadAccessor((InternalReadAccessor)reader);
                declarations[i] = declr;
            }
            ((Query)context.getRule()).setParameters(declarations);
        }
        catch (ClassNotFoundException e) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), queryDescr, e, "Unable to resolve type '" + types[i] + " for parameter" + params[i]));
        }
        return pattern;
    }
}

