/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder;

import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.PackageBuilder;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.Declaration;
import org.drools.rule.Dialectable;
import org.drools.rule.Package;
import org.drools.rule.Query;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.builder.PackageBuildContext;
import org.drools.spi.DeclarationScopeResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleBuildContext
extends PackageBuildContext {
    private Rule rule;
    private Stack<RuleConditionElement> buildStack = new Stack();
    private RuleDescr ruleDescr;
    private DeclarationScopeResolver declarationResolver;
    private int patternId = -1;
    protected Map<String, Declaration> declarations;

    public RuleBuildContext(PackageBuilder pkgBuilder, RuleDescr ruleDescr, DialectCompiletimeRegistry dialectCompiletimeRegistry, Package pkg, Dialect defaultDialect) {
        Dialect dialect;
        this.declarationResolver = new DeclarationScopeResolver(pkgBuilder.getGlobals(), this.buildStack);
        this.declarationResolver.setPackage(pkg);
        this.ruleDescr = ruleDescr;
        this.rule = ruleDescr instanceof QueryDescr ? new Query(ruleDescr.getName()) : new Rule(ruleDescr.getName());
        this.rule.setPackage(pkg.getName());
        this.rule.setDialect(ruleDescr.getDialect());
        this.init(pkgBuilder, pkg, ruleDescr, dialectCompiletimeRegistry, defaultDialect, (Dialectable)this.rule);
        if (this.rule.getDialect() == null) {
            this.rule.setDialect(this.getDialect().getId());
        }
        if ((dialect = this.getDialect()) != null) {
            dialect.init(ruleDescr);
        }
    }

    public Rule getRule() {
        return this.rule;
    }

    public RuleDescr getRuleDescr() {
        return this.ruleDescr;
    }

    public DeclarationScopeResolver getDeclarationResolver() {
        return this.declarationResolver;
    }

    public void setDeclarationResolver(DeclarationScopeResolver variables) {
        this.declarationResolver = variables;
    }

    public int getPatternId() {
        return this.patternId;
    }

    public int getNextPatternId() {
        return ++this.patternId;
    }

    public void setPatternId(int patternId) {
        this.patternId = patternId;
    }

    public Stack<RuleConditionElement> getBuildStack() {
        return this.buildStack;
    }

    public void addDeclaration(Declaration decl) {
        if (this.declarations == null) {
            this.declarations = new Hashtable<String, Declaration>();
        }
        this.declarations.put(decl.getIdentifier(), decl);
    }

    public Declaration getDeclaration(String identifier) {
        return this.declarations == null ? null : this.declarations.get(identifier);
    }
}

