/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.jpeg.JpegCommentReader;
import com.drew.metadata.jpeg.JpegReader;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import java.io.File;
import java.io.InputStream;

public class JpegMetadataReader {
    public static Metadata readMetadata(InputStream inputStream) throws JpegProcessingException {
        JpegSegmentReader jpegSegmentReader = new JpegSegmentReader(inputStream);
        return JpegMetadataReader.extractMetadataFromJpegSegmentReader(jpegSegmentReader);
    }

    public static Metadata readMetadata(File file) throws JpegProcessingException {
        JpegSegmentReader jpegSegmentReader = new JpegSegmentReader(file);
        return JpegMetadataReader.extractMetadataFromJpegSegmentReader(jpegSegmentReader);
    }

    public static Metadata extractMetadataFromJpegSegmentReader(JpegSegmentReader jpegSegmentReader) {
        byte[] byArray;
        Metadata metadata = new Metadata();
        try {
            byArray = jpegSegmentReader.readSegment((byte)-31);
            new ExifReader(byArray).extract(metadata);
        }
        catch (JpegProcessingException jpegProcessingException) {
            // empty catch block
        }
        try {
            byArray = jpegSegmentReader.readSegment((byte)-19);
            new IptcReader(byArray).extract(metadata);
        }
        catch (JpegProcessingException jpegProcessingException) {
            // empty catch block
        }
        try {
            byArray = jpegSegmentReader.readSegment((byte)-64);
            new JpegReader(byArray).extract(metadata);
        }
        catch (JpegProcessingException jpegProcessingException) {
            // empty catch block
        }
        try {
            byArray = jpegSegmentReader.readSegment((byte)-2);
            new JpegCommentReader(byArray).extract(metadata);
        }
        catch (JpegProcessingException jpegProcessingException) {
            // empty catch block
        }
        return metadata;
    }

    public static Metadata readMetadata(JPEGDecodeParam jPEGDecodeParam) {
        byte[][] byArray;
        byte[][] byArray2;
        Metadata metadata = new Metadata();
        byte[][] byArray3 = jPEGDecodeParam.getMarkerData(225);
        if (byArray3 != null && byArray3[0].length > 0) {
            new ExifReader(byArray3[0]).extract(metadata);
        }
        if ((byArray2 = jPEGDecodeParam.getMarkerData(237)) != null && byArray2[0].length > 0) {
            new IptcReader(byArray2[0]).extract(metadata);
        }
        if ((byArray = jPEGDecodeParam.getMarkerData(254)) != null && byArray[0].length > 0) {
            new JpegCommentReader(byArray[0]).extract(metadata);
        }
        return metadata;
    }

    private JpegMetadataReader() throws Exception {
        throw new Exception("Not intended for instantiation");
    }
}

