/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RefDataValue;
import org.apache.derby.iapi.types.RowLocation;

public class SQLRef
extends DataType
implements RefDataValue {
    protected RowLocation value;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLRef.class);

    public int estimateMemoryUsage() {
        int n = BASE_MEMORY_USAGE;
        if (null != this.value) {
            n += this.value.estimateMemoryUsage();
        }
        return n;
    }

    public String getString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    public Object getObject() {
        return this.value;
    }

    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (dataValueDescriptor.isNull()) {
            this.setToNull();
        } else {
            this.value = (RowLocation)dataValueDescriptor.getObject();
        }
    }

    public int getLength() {
        return -1;
    }

    public String getTypeName() {
        return "REF";
    }

    public int getTypeFormatId() {
        return 82;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.value);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.value = (RowLocation)objectInput.readObject();
    }

    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException, ClassNotFoundException {
        this.value = (RowLocation)arrayInputStream.readObject();
    }

    public void restoreToNull() {
        this.value = null;
    }

    public boolean compare(int n, DataValueDescriptor dataValueDescriptor, boolean bl, boolean bl2) throws StandardException {
        return this.value.compare(n, ((SQLRef)dataValueDescriptor).value, bl, bl2);
    }

    public int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        return this.value.compare(((SQLRef)dataValueDescriptor).value);
    }

    public DataValueDescriptor getClone() {
        if (this.value == null) {
            return new SQLRef();
        }
        return new SQLRef((RowLocation)this.value.cloneObject());
    }

    public DataValueDescriptor getNewNull() {
        return new SQLRef();
    }

    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) {
    }

    public void setInto(PreparedStatement preparedStatement, int n) {
    }

    public SQLRef() {
    }

    public SQLRef(RowLocation rowLocation) {
        this.value = rowLocation;
    }

    public void setValue(RowLocation rowLocation) {
        this.value = rowLocation;
    }

    public String toString() {
        if (this.value == null) {
            return "NULL";
        }
        return this.value.toString();
    }
}

