/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.timer;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.Timer;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.timer.TimerFactory;

public class SingletonTimerFactory
implements TimerFactory,
ModuleControl {
    private Timer singletonTimer;

    public SingletonTimerFactory() {
        ClassLoader classLoader = null;
        boolean bl = false;
        try {
            classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            bl = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (bl) {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(null);
                        return null;
                    }
                });
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        this.singletonTimer = new Timer(true);
        if (bl) {
            try {
                final ClassLoader classLoader2 = classLoader;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(classLoader2);
                        return null;
                    }
                });
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public Timer getCancellationTimer() {
        return this.singletonTimer;
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
    }

    public void stop() {
        this.singletonTimer.cancel();
    }
}

