/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.OptimizerImpl;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SetOperatorNode;
import org.apache.derby.impl.sql.compile.UnionNode;

abstract class TableOperatorNode
extends FromTable {
    ResultSetNode leftResultSet;
    ResultSetNode rightResultSet;
    Optimizer leftOptimizer;
    Optimizer rightOptimizer;
    private boolean leftModifyAccessPathsDone;
    private boolean rightModifyAccessPathsDone;

    TableOperatorNode() {
    }

    public void init(Object object, Object object2, Object object3) throws StandardException {
        this.init(null, object3);
        this.leftResultSet = (ResultSetNode)object;
        this.rightResultSet = (ResultSetNode)object2;
    }

    public Optimizable modifyAccessPath(JBitSet jBitSet) throws StandardException {
        boolean bl = false;
        if (this.leftResultSet instanceof FromTable) {
            if (this.leftOptimizer != null) {
                this.leftOptimizer.modifyAccessPaths();
                this.leftResultSet = (ResultSetNode)((Object)((OptimizerImpl)this.leftOptimizer).optimizableList.getOptimizable(0));
            } else {
                this.leftResultSet = (ResultSetNode)((Object)((FromTable)this.leftResultSet).modifyAccessPath(jBitSet));
            }
            this.leftModifyAccessPathsDone = true;
        } else {
            bl = true;
        }
        if (this.rightResultSet instanceof FromTable) {
            if (this.rightOptimizer != null) {
                this.rightOptimizer.modifyAccessPaths();
                this.rightResultSet = (ResultSetNode)((Object)((OptimizerImpl)this.rightOptimizer).optimizableList.getOptimizable(0));
            } else {
                this.rightResultSet = (ResultSetNode)((Object)((FromTable)this.rightResultSet).modifyAccessPath(jBitSet));
            }
            this.rightModifyAccessPathsDone = true;
        } else {
            bl = true;
        }
        if (bl) {
            return (Optimizable)((Object)this.modifyAccessPaths());
        }
        return this;
    }

    public void verifyProperties(DataDictionary dataDictionary) throws StandardException {
        if (this.leftResultSet instanceof Optimizable) {
            ((Optimizable)((Object)this.leftResultSet)).verifyProperties(dataDictionary);
        }
        if (this.rightResultSet instanceof Optimizable) {
            ((Optimizable)((Object)this.rightResultSet)).verifyProperties(dataDictionary);
        }
        super.verifyProperties(dataDictionary);
    }

    public void updateBestPlanMap(short s, Object object) throws StandardException {
        super.updateBestPlanMap(s, object);
        if (this.leftResultSet instanceof Optimizable) {
            ((Optimizable)((Object)this.leftResultSet)).updateBestPlanMap(s, object);
        } else if (this.leftResultSet.getOptimizerImpl() != null) {
            this.leftResultSet.getOptimizerImpl().updateBestPlanMaps(s, object);
        }
        if (this.rightResultSet instanceof Optimizable) {
            ((Optimizable)((Object)this.rightResultSet)).updateBestPlanMap(s, object);
        } else if (this.rightResultSet.getOptimizerImpl() != null) {
            this.rightResultSet.getOptimizerImpl().updateBestPlanMaps(s, object);
        }
    }

    public String toString() {
        return "";
    }

    public void printSubNodes(int n) {
    }

    public ResultSetNode getLeftResultSet() {
        return this.leftResultSet;
    }

    public ResultSetNode getRightResultSet() {
        return this.rightResultSet;
    }

    public ResultSetNode getLeftmostResultSet() {
        if (this.leftResultSet instanceof TableOperatorNode) {
            return ((TableOperatorNode)this.leftResultSet).getLeftmostResultSet();
        }
        return this.leftResultSet;
    }

    public void setLeftmostResultSet(ResultSetNode resultSetNode) {
        if (this.leftResultSet instanceof TableOperatorNode) {
            ((TableOperatorNode)this.leftResultSet).setLeftmostResultSet(resultSetNode);
        } else {
            this.leftResultSet = resultSetNode;
        }
    }

    public void setLevel(int n) {
        super.setLevel(n);
        if (this.leftResultSet instanceof FromTable) {
            ((FromTable)this.leftResultSet).setLevel(n);
        }
        if (this.rightResultSet instanceof FromTable) {
            ((FromTable)this.rightResultSet).setLevel(n);
        }
    }

    public String getExposedName() {
        return null;
    }

    public void setNestedInParens(boolean bl) {
    }

    public ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        this.leftResultSet = this.leftResultSet.bindNonVTITables(dataDictionary, fromList);
        this.rightResultSet = this.rightResultSet.bindNonVTITables(dataDictionary, fromList);
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        return this;
    }

    public ResultSetNode bindVTITables(FromList fromList) throws StandardException {
        this.leftResultSet = this.leftResultSet.bindVTITables(fromList);
        this.rightResultSet = this.rightResultSet.bindVTITables(fromList);
        return this;
    }

    public void bindExpressions(FromList fromList) throws StandardException {
        if (!(this instanceof UnionNode) || !((UnionNode)this).tableConstructor()) {
            this.leftResultSet.rejectParameters();
            this.rightResultSet.rejectParameters();
        }
        this.leftResultSet.bindExpressions(fromList);
        this.rightResultSet.bindExpressions(fromList);
    }

    public void rejectParameters() throws StandardException {
        this.leftResultSet.rejectParameters();
        this.rightResultSet.rejectParameters();
    }

    public void bindExpressionsWithTables(FromList fromList) throws StandardException {
        if (!(this instanceof UnionNode) || !((UnionNode)this).tableConstructor()) {
            this.leftResultSet.rejectParameters();
            this.rightResultSet.rejectParameters();
        }
        this.leftResultSet.bindExpressionsWithTables(fromList);
        this.rightResultSet.bindExpressionsWithTables(fromList);
    }

    public void bindResultColumns(FromList fromList) throws StandardException {
        this.leftResultSet.bindResultColumns(fromList);
        this.rightResultSet.bindResultColumns(fromList);
    }

    public void bindResultColumns(TableDescriptor tableDescriptor, FromVTI fromVTI, ResultColumnList resultColumnList, DMLStatementNode dMLStatementNode, FromList fromList) throws StandardException {
        this.leftResultSet.bindResultColumns(tableDescriptor, fromVTI, resultColumnList, dMLStatementNode, fromList);
        this.rightResultSet.bindResultColumns(tableDescriptor, fromVTI, resultColumnList, dMLStatementNode, fromList);
    }

    protected FromTable getFromTableByName(String string, String string2, boolean bl) throws StandardException {
        FromTable fromTable = this.leftResultSet.getFromTableByName(string, string2, bl);
        if (fromTable == null) {
            fromTable = this.rightResultSet.getFromTableByName(string, string2, bl);
        }
        return fromTable;
    }

    public ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        this.leftResultSet = this.leftResultSet.preprocess(n, groupByList, fromList);
        if (this.leftResultSet instanceof FromSubquery) {
            this.leftResultSet = ((FromSubquery)this.leftResultSet).extractSubquery(n);
        }
        this.rightResultSet = this.rightResultSet.preprocess(n, groupByList, fromList);
        if (this.rightResultSet instanceof FromSubquery) {
            this.rightResultSet = ((FromSubquery)this.rightResultSet).extractSubquery(n);
        }
        this.referencedTableMap = (JBitSet)this.leftResultSet.getReferencedTableMap().clone();
        this.referencedTableMap.or(this.rightResultSet.getReferencedTableMap());
        this.referencedTableMap.set(this.tableNumber);
        if (this.isFlattenableJoinNode()) {
            return this;
        }
        this.projectResultColumns();
        return this.genProjectRestrict(n);
    }

    void projectResultColumns() throws StandardException {
        this.resultColumns.doProjection();
    }

    void setReferencedColumns() {
    }

    public ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double d) throws StandardException {
        Optimizer optimizer = this.getOptimizer((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this, this.getContextManager()), predicateList, dataDictionary, null);
        this.costEstimate = optimizer.newCostEstimate();
        this.leftResultSet = this.leftResultSet.optimize(dataDictionary, predicateList, d);
        this.rightResultSet = this.rightResultSet.optimize(dataDictionary, predicateList, d);
        this.costEstimate.setCost(this.leftResultSet.getCostEstimate().getEstimatedCost(), this.leftResultSet.getCostEstimate().rowCount(), this.leftResultSet.getCostEstimate().singleScanRowCount() + this.rightResultSet.getCostEstimate().singleScanRowCount());
        this.costEstimate.add(this.rightResultSet.costEstimate, this.costEstimate);
        return this;
    }

    public ResultSetNode modifyAccessPaths() throws StandardException {
        SetOperatorNode setOperatorNode;
        if (!this.leftModifyAccessPathsDone) {
            if (this.leftOptimizer != null) {
                this.leftOptimizer.modifyAccessPaths();
                this.leftResultSet = (ResultSetNode)((Object)((OptimizerImpl)this.leftOptimizer).optimizableList.getOptimizable(0));
            } else if (this instanceof SetOperatorNode) {
                setOperatorNode = (SetOperatorNode)this;
                this.leftResultSet = this.leftResultSet.modifyAccessPaths(setOperatorNode.getLeftOptPredicateList());
            } else {
                this.leftResultSet = this.leftResultSet.modifyAccessPaths();
            }
        }
        if (!this.rightModifyAccessPathsDone) {
            if (this.rightOptimizer != null) {
                this.rightOptimizer.modifyAccessPaths();
                this.rightResultSet = (ResultSetNode)((Object)((OptimizerImpl)this.rightOptimizer).optimizableList.getOptimizable(0));
            } else if (this instanceof SetOperatorNode) {
                setOperatorNode = (SetOperatorNode)this;
                this.rightResultSet = this.rightResultSet.modifyAccessPaths(setOperatorNode.getRightOptPredicateList());
            } else {
                this.rightResultSet = this.rightResultSet.modifyAccessPaths();
            }
        }
        return this;
    }

    public boolean referencesTarget(String string, boolean bl) throws StandardException {
        return this.leftResultSet.referencesTarget(string, bl) || this.rightResultSet.referencesTarget(string, bl);
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.leftResultSet.referencesSessionSchema() || this.rightResultSet.referencesSessionSchema();
    }

    protected ResultSetNode optimizeSource(Optimizer optimizer, ResultSetNode resultSetNode, PredicateList predicateList, CostEstimate costEstimate) throws StandardException {
        ResultSetNode resultSetNode2;
        if (resultSetNode instanceof FromTable) {
            FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), resultSetNode, this.getContextManager());
            if (predicateList == null) {
                predicateList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
            }
            LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
            OptimizerFactory optimizerFactory = languageConnectionContext.getOptimizerFactory();
            optimizer = optimizerFactory.getOptimizer(fromList, predicateList, this.getDataDictionary(), null, this.getCompilerContext().getNumTables(), languageConnectionContext);
            optimizer.prepForNextRound();
            if (resultSetNode == this.leftResultSet) {
                this.leftOptimizer = optimizer;
            } else if (resultSetNode == this.rightResultSet) {
                this.rightOptimizer = optimizer;
            }
            optimizer.setOuterRows(costEstimate.rowCount());
            while (optimizer.getNextPermutation()) {
                while (optimizer.getNextDecoratedPermutation()) {
                    optimizer.costPermutation();
                }
            }
            resultSetNode2 = resultSetNode;
        } else {
            resultSetNode2 = resultSetNode.optimize(optimizer.getDataDictionary(), predicateList, costEstimate.rowCount());
        }
        return resultSetNode2;
    }

    void decrementLevel(int n) {
        this.leftResultSet.decrementLevel(n);
        this.rightResultSet.decrementLevel(n);
    }

    void replaceDefaults(TableDescriptor tableDescriptor, ResultColumnList resultColumnList) throws StandardException {
        this.leftResultSet.replaceDefaults(tableDescriptor, resultColumnList);
        this.rightResultSet.replaceDefaults(tableDescriptor, resultColumnList);
    }

    void adjustForSortElimination() {
        this.leftResultSet.adjustForSortElimination();
        this.rightResultSet.adjustForSortElimination();
    }

    void adjustForSortElimination(RequiredRowOrdering requiredRowOrdering) throws StandardException {
        this.leftResultSet.adjustForSortElimination(requiredRowOrdering);
        this.rightResultSet.adjustForSortElimination(requiredRowOrdering);
    }

    public Visitable accept(Visitor visitor) throws StandardException {
        if (visitor.skipChildren(this)) {
            return visitor.visit(this);
        }
        Visitable visitable = super.accept(visitor);
        if (this.leftResultSet != null && !visitor.stopTraversal()) {
            this.leftResultSet = (ResultSetNode)this.leftResultSet.accept(visitor);
        }
        if (this.rightResultSet != null && !visitor.stopTraversal()) {
            this.rightResultSet = (ResultSetNode)this.rightResultSet.accept(visitor);
        }
        return visitable;
    }

    public boolean needsSpecialRCLBinding() {
        return true;
    }
}

