/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.decisiontable.parser.ActionType;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.decisiontable.parser.SourceBuilder;
import org.drools.template.model.SnippetBuilder;
import org.drools.template.parser.DecisionTableParseException;

public class RhsBuilder
implements SourceBuilder {
    private int headerRow;
    private int headerCol;
    private ActionType.Code actionTypeCode;
    private Map<Integer, String> templates;
    private String variable;
    private List<String> values;
    private boolean hasValues;

    public RhsBuilder(ActionType.Code code, int row, int column, String boundVariable) {
        this.actionTypeCode = code;
        this.headerRow = row;
        this.headerCol = column;
        this.variable = boundVariable == null ? "" : boundVariable.trim();
        this.templates = new HashMap<Integer, String>();
        this.values = new ArrayList<String>();
    }

    public ActionType.Code getActionTypeCode() {
        return this.actionTypeCode;
    }

    public void addTemplate(int row, int column, String content) {
        Integer key = new Integer(column);
        content = content.trim();
        if (this.isBoundVar()) {
            content = this.variable + "." + content + ";";
        }
        this.templates.put(key, content);
    }

    private boolean isBoundVar() {
        return !"".equals(this.variable);
    }

    public void addCellValue(int row, int column, String value) {
        this.hasValues = true;
        String template = this.templates.get(new Integer(column));
        if (template == null) {
            throw new DecisionTableParseException("No code snippet for " + (Object)((Object)this.actionTypeCode) + ", above cell " + RuleSheetParserUtil.rc2name(this.headerRow + 2, this.headerCol));
        }
        SnippetBuilder snip = new SnippetBuilder(template);
        this.values.add(snip.build(value));
    }

    public void clearValues() {
        this.hasValues = false;
        this.values.clear();
    }

    public String getResult() {
        StringBuffer buf = new StringBuffer();
        Iterator<String> iter = this.values.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append('\n');
        }
        return buf.toString();
    }

    public boolean hasValues() {
        return this.hasValues;
    }
}

