/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.components;

import org.drools.lang.descr.BaseDescr;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.data.VerifierComponent;
import org.drools.verifier.report.components.Cause;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field
extends VerifierComponent<BaseDescr>
implements Cause {
    public static final String BOOLEAN = "java.lang.Boolean";
    public static final String STRING = "java.lang.String";
    public static final String INT = "java.lang.Integer";
    public static final String DOUBLE = "java.lang.Double";
    public static final String DATE = "java.util.Date";
    public static final String VARIABLE = "Variable";
    public static final String OBJECT = "Object";
    public static final String ENUM = "Enum";
    public static final String UNKNOWN = "Unknown";
    private String objectTypePath;
    protected String objectTypeName;
    protected String name;
    private String fieldType;

    public Field(BaseDescr descr) {
        super(descr);
    }

    @Override
    public String getPath() {
        return String.format("%s/field[@name='%s']", this.getObjectTypePath(), this.getName());
    }

    @Override
    public VerifierComponentType getVerifierComponentType() {
        return VerifierComponentType.FIELD;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType == VARIABLE && this.fieldType == null ? fieldType : fieldType;
    }

    public String getObjectTypePath() {
        return this.objectTypePath;
    }

    public void setObjectTypePath(String objectTypePath) {
        this.objectTypePath = objectTypePath;
    }

    public String getObjectTypeName() {
        return this.objectTypeName;
    }

    public void setObjectTypeName(String objectTypeName) {
        this.objectTypeName = objectTypeName;
    }

    @Override
    public String toString() {
        return "Field '" + this.name + "' from object type '" + this.objectTypeName + "'";
    }
}

