/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import thredds.catalog2.builder.BuilderIssue;
import thredds.catalog2.builder.BuilderIssues;
import thredds.catalog2.builder.ThreddsBuilder;
import thredds.catalog2.simpleImpl.ServiceImpl;

class GlobalServiceContainer {
    private Map<String, ServiceImpl> servicesByGloballyUniqueName = new HashMap<String, ServiceImpl>();
    private List<ServiceImpl> servicesWithDuplicateName = new ArrayList<ServiceImpl>();

    GlobalServiceContainer() {
    }

    boolean isServiceNameInUseGlobally(String name) {
        return this.servicesByGloballyUniqueName.containsKey(name);
    }

    ServiceImpl getServiceByGloballyUniqueName(String name) {
        if (name == null) {
            return null;
        }
        return this.servicesByGloballyUniqueName.get(name);
    }

    void addService(ServiceImpl service) {
        if (service == null) {
            return;
        }
        if (this.servicesByGloballyUniqueName.containsKey(service.getName())) {
            boolean success = this.servicesWithDuplicateName.add(service);
            assert (success);
            return;
        }
        ServiceImpl replacedService = this.servicesByGloballyUniqueName.put(service.getName(), service);
        assert (null == replacedService);
    }

    boolean removeService(ServiceImpl service) {
        if (service == null) {
            return false;
        }
        if (this.servicesWithDuplicateName.remove(service)) {
            return true;
        }
        if (this.servicesByGloballyUniqueName.containsValue(service)) {
            ServiceImpl removedService = this.servicesByGloballyUniqueName.remove(service.getName());
            assert (service == removedService);
            boolean promoted = this.promoteFirstServiceWithDuplicateName(service.getName());
            assert (promoted);
            return true;
        }
        return false;
    }

    private boolean promoteFirstServiceWithDuplicateName(String name) {
        for (ServiceImpl service : this.servicesWithDuplicateName) {
            if (!service.getName().equals(name)) continue;
            boolean success = this.servicesWithDuplicateName.remove(service);
            assert (success);
            ServiceImpl replacedService = this.servicesByGloballyUniqueName.put(service.getName(), service);
            assert (null == replacedService);
            return true;
        }
        return false;
    }

    boolean isEmpty() {
        return this.servicesByGloballyUniqueName.isEmpty();
    }

    int numberOfServicesWithGloballyUniqueNames() {
        return this.servicesByGloballyUniqueName.size();
    }

    int numberOfServicesWithDuplicateNames() {
        return this.servicesWithDuplicateName.size();
    }

    BuilderIssues getIssues(ThreddsBuilder responsibleBuilder) {
        BuilderIssues issues = new BuilderIssues();
        if (!this.servicesWithDuplicateName.isEmpty()) {
            for (ServiceImpl s : this.servicesWithDuplicateName) {
                issues.addIssue(BuilderIssue.Severity.WARNING, "Catalog contains duplicate service name [" + s.getName() + "].", responsibleBuilder, null);
            }
        }
        return issues;
    }
}

