/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import ucar.ma2.Index;

public class Index1D
extends Index {
    private int curr0;
    private int stride0;
    private int shape0;

    Index1D() {
        super(1);
    }

    public Index1D(int[] shape) {
        super(shape);
        this.precalc();
    }

    public String toString() {
        return Integer.toString(this.curr0);
    }

    protected void precalc() {
        this.shape0 = this.shape[0];
        this.stride0 = this.stride[0];
        this.curr0 = this.current[0];
    }

    public int[] getCurrentCounter() {
        this.current[0] = this.curr0;
        return (int[])this.current.clone();
    }

    public int currentElement() {
        return this.offset + this.curr0 * this.stride0;
    }

    public int incr() {
        if (++this.curr0 >= this.shape0) {
            this.curr0 = 0;
        }
        return this.offset + this.curr0 * this.stride0;
    }

    public void setDim(int dim, int value) {
        if (value < 0 || value >= this.shape[dim]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.curr0 = value;
    }

    public Index set0(int v) {
        if (v < 0 || v >= this.shape0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.curr0 = v;
        return this;
    }

    public Index set(int v0) {
        this.set0(v0);
        return this;
    }

    public Index set(int[] index) {
        if (index.length != this.rank) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.set0(index[0]);
        return this;
    }

    public Object clone() {
        return super.clone();
    }

    int setDirect(int v0) {
        if (v0 < 0 || v0 >= this.shape0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.offset + v0 * this.stride0;
    }
}

