/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import org.drools.commons.jci.problems.CompilationProblem;
import org.drools.compiler.DroolsError;
import org.drools.lang.descr.FunctionDescr;

public class FunctionError
extends DroolsError {
    private final FunctionDescr functionDescr;
    private final Object object;
    private final String message;
    private int[] errorLines;

    public FunctionError(FunctionDescr functionDescr, Object object, String message) {
        this.functionDescr = functionDescr;
        this.object = object;
        this.message = this.createMessage(message);
    }

    public FunctionDescr getFunctionDescr() {
        return this.functionDescr;
    }

    public Object getObject() {
        return this.object;
    }

    public int[] getErrorLines() {
        return this.errorLines;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.message;
    }

    private String createMessage(String message) {
        StringBuilder detail = new StringBuilder();
        if (this.object instanceof CompilationProblem[]) {
            CompilationProblem[] cp = (CompilationProblem[])this.object;
            this.errorLines = new int[cp.length];
            for (int i = 0; i < cp.length; ++i) {
                this.errorLines[i] = cp[i].getStartLine() - this.functionDescr.getOffset() + this.getFunctionDescr().getLine() - 1;
                detail.append(this.functionDescr.getName());
                detail.append(" (line:");
                detail.append(this.errorLines[i]);
                detail.append("): ");
                detail.append(cp[i].getMessage());
                detail.append("\n");
            }
        } else {
            this.errorLines = new int[0];
        }
        return "[ " + this.functionDescr.getName() + " : " + message + "\n" + detail.toString() + " ]";
    }
}

