/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.PropStat;
import org.eclipse.webdav.dom.QualifiedName;
import org.eclipse.webdav.dom.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResponseBody
extends ElementEditor {
    protected static final String[] childNames = new String[]{"href", "href", "status", "propstat", "responsedescription"};
    public static String[] fgNamesStatus = new String[]{"href", "href", "status", "responsedescription"};
    public static String[] fgNamesPropStat = new String[]{"href", "propstat", "responsedescription"};

    public ResponseBody(Element root) throws MalformedElementException {
        super(root, "response");
    }

    public PropStat accumulatePropStat(QualifiedName propertyName, String status, String responseDescription) {
        Assert.isNotNull(propertyName);
        Assert.isNotNull(status);
        Element child = ElementEditor.getFirstChild(this.root, new String[]{"href", "status"});
        Assert.isTrue(child == null || ElementEditor.isDAVElement(child, "href") && ElementEditor.getNextSibling(child, new String[]{"href", "status"}) == null);
        String nsName = propertyName.getQualifier();
        Assert.isTrue(!"".equals(nsName));
        String localName = propertyName.getLocalName();
        Assert.isNotNull(localName);
        Assert.isTrue(!localName.equals(""));
        Document document = this.root.getOwnerDocument();
        Element element = document.createElement(localName);
        ElementEditor.declareNS(element, null, nsName);
        try {
            return this.accumulatePropStat(element, status, responseDescription);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    public PropStat accumulatePropStat(Element element, String status, String responseDescription) throws MalformedElementException {
        Assert.isNotNull(element);
        Assert.isNotNull(status);
        Element child = ElementEditor.getFirstChild(this.root, new String[]{"href", "status"});
        Assert.isTrue(child == null || ElementEditor.isDAVElement(child, "href") && ElementEditor.getNextSibling(child, new String[]{"href", "status"}) == null);
        boolean found = false;
        Element propstat = ElementEditor.getFirstChild(this.root, "propstat");
        while (!found && propstat != null) {
            String text = ElementEditor.getChildText(propstat, "status", false);
            if (text != null && text.equals(status)) {
                found = true;
                continue;
            }
            propstat = ElementEditor.getTwin(propstat, true);
        }
        Element prop = null;
        if (propstat == null) {
            propstat = ElementEditor.addChild(this.root, "propstat", fgNamesPropStat, false);
            prop = ElementEditor.setChild(propstat, "prop", PropStat.childNames, true);
            ElementEditor.setChild(propstat, "status", status, PropStat.childNames, false);
        } else {
            prop = ElementEditor.getFirstChild(propstat, "prop");
            if (prop == null) {
                prop = ElementEditor.setChild(propstat, "prop", PropStat.childNames, true);
            }
        }
        if (responseDescription == null) {
            Element responsedescription = ElementEditor.getLastChild(propstat, "responsedescription");
            if (responsedescription != null) {
                propstat.removeChild(responsedescription);
            }
        } else {
            ElementEditor.setChild(propstat, "responsedescription", responseDescription, PropStat.childNames, false);
        }
        ElementEditor.extractNode(prop, element);
        try {
            return new PropStat(propstat);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    public void addHref(String href) {
        Assert.isNotNull(href);
        Assert.isTrue(ElementEditor.getLastChild(this.root, "propstat") == null);
        ElementEditor.addChild(this.root, "href", ElementEditor.encodeHref(href), fgNamesStatus, false);
    }

    public PropStat addPropStat() {
        Element firstHref = ElementEditor.getFirstChild(this.root, "href");
        Assert.isTrue(firstHref == null || ElementEditor.getNextSibling(firstHref, new String[]{"href", "status"}) == null);
        Element element = ElementEditor.addChild(this.root, "propstat", fgNamesPropStat, false);
        try {
            return new PropStat(element);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    public void changePropStatStatus(String oldStatus, String newStatus, String responseDescription) {
        Assert.isNotNull(oldStatus);
        Assert.isNotNull(newStatus);
        Element firstHref = ElementEditor.getFirstChild(this.root, "href");
        Assert.isTrue(firstHref == null || ElementEditor.getNextSibling(firstHref, new String[]{"href", "status"}) == null);
        Element propstat = ElementEditor.getFirstChild(this.root, "propstat");
        while (propstat != null) {
            String status = ElementEditor.getChildText(propstat, "status", true);
            if (oldStatus.equals(status)) {
                ElementEditor.setChild(propstat, "status", newStatus, PropStat.childNames, true);
                if (responseDescription == null) {
                    Element responsedescription = ElementEditor.getLastChild(propstat, "responsedescription");
                    if (responsedescription != null) {
                        propstat.removeChild(responsedescription);
                    }
                } else {
                    ElementEditor.setChild(propstat, "responsedescription", responseDescription, PropStat.childNames, false);
                }
            }
            propstat = ElementEditor.getTwin(propstat, true);
        }
    }

    public static ResponseBody create(Document document) {
        Assert.isNotNull(document);
        Assert.isTrue(document.getDocumentElement() == null);
        Element element = ElementEditor.create(document, "response");
        ResponseBody result = null;
        try {
            result = new ResponseBody(element);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
        }
        return result;
    }

    public String getHref() throws MalformedElementException {
        String href = ElementEditor.getChildText(this.root, "href", true);
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingHrefElmt"), href);
        return ElementEditor.decodeHref(href);
    }

    public Enumeration getHrefs() throws MalformedElementException {
        Element firstHref = ElementEditor.getFirstChild(this.root, "href");
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingHrefElmt"), firstHref);
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingStatusElmt"), ElementEditor.getNextSibling(firstHref, "status"));
        Enumeration e = new Enumeration(firstHref){
            Node currentHref;
            {
                this.currentHref = ElementEditor.getTwin((Element)node, true);
            }

            public boolean hasMoreElements() {
                return this.currentHref != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String href = ElementEditor.getFirstText((Element)this.currentHref);
                this.currentHref = ElementEditor.getTwin((Element)this.currentHref, true);
                return ElementEditor.decodeHref(href);
            }
        };
        return e;
    }

    public Enumeration getPropStats() throws MalformedElementException {
        Element firstPropStat = ElementEditor.getFirstChild(this.root, "propstat");
        ElementEditor.ensureNotNull("ensure.missingPropstatElmt", firstPropStat);
        Enumeration e = new Enumeration(firstPropStat){
            Element currentPropStat;
            {
                this.currentPropStat = element;
            }

            public boolean hasMoreElements() {
                return this.currentPropStat != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                PropStat result = null;
                try {
                    result = new PropStat(this.currentPropStat);
                }
                catch (MalformedElementException malformedElementException) {
                    Assert.isTrue(false, Policy.bind("assert.internalError"));
                }
                this.currentPropStat = ElementEditor.getTwin(this.currentPropStat, true);
                return result;
            }
        };
        return e;
    }

    public String getResponseDescription() throws MalformedElementException {
        return ElementEditor.getChildText(this.root, "responsedescription", false);
    }

    public String getStatus() throws MalformedElementException {
        Element status = ElementEditor.getFirstChild(this.root, "status");
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingStatusElmt"), status);
        return ElementEditor.getFirstText(status);
    }

    public int getStatusCode() throws MalformedElementException {
        return new Status(this.getStatus()).getStatusCode();
    }

    public boolean isPropStat() throws MalformedElementException {
        Element child = ElementEditor.getFirstChild(this.root, new String[]{"status", "propstat"});
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingStatusOrPropstatElmt"), child);
        boolean isPropStat = ElementEditor.isDAVElement(child, "propstat");
        child = isPropStat ? ElementEditor.getNextSibling(child, "status") : ElementEditor.getNextSibling(child, "propstat");
        ElementEditor.ensureNull(Policy.bind("ensure.conflictingStatusOrPropstatElmt"), child);
        return isPropStat;
    }

    public boolean isStatus() throws MalformedElementException {
        return !this.isPropStat();
    }

    public void setHref(String href) {
        Assert.isNotNull(href);
        ElementEditor.setChild(this.root, "href", href, childNames, true);
    }

    public void setResponseDescription(String value) {
        if (value == null) {
            Element child = ElementEditor.getLastChild(this.root, "responsedescription");
            if (child != null) {
                this.root.removeChild(child);
            }
        } else {
            ElementEditor.setChild(this.root, "responsedescription", value, childNames, false);
        }
    }

    public void setResponseDescription(Element value) {
        Element child = ElementEditor.getLastChild(this.root, "responsedescription");
        if (child != null) {
            this.root.removeChild(child);
        }
        if (value == null) {
            child = ElementEditor.setChild(this.root, "responsedescription", childNames, false);
            child.appendChild(value);
        }
    }

    public void setStatus(String status) {
        Assert.isNotNull(status);
        Assert.isTrue(ElementEditor.getLastChild(this.root, "propstat") == null);
        ElementEditor.setChild(this.root, "status", status, fgNamesStatus, true);
    }
}

