/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.optional.depend;

import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.optional.depend.DependScanner;
import org.apache.tools.ant.util.StringUtils;

public class ClassfileSet
extends FileSet {
    private Vector rootClasses = new Vector();
    private Vector rootFileSets = new Vector();

    public ClassfileSet() {
    }

    public void addRootFileset(FileSet rootFileSet) {
        this.rootFileSets.addElement(rootFileSet);
        this.setChecked(false);
    }

    protected ClassfileSet(ClassfileSet s) {
        super((FileSet)s);
        this.rootClasses = (Vector)s.rootClasses.clone();
    }

    public void setRootClass(String rootClass) {
        this.rootClasses.addElement(rootClass);
    }

    public DirectoryScanner getDirectoryScanner(Project p) {
        if (this.isReference()) {
            return this.getRef(p).getDirectoryScanner(p);
        }
        this.dieOnCircularReference(p);
        DirectoryScanner parentScanner = super.getDirectoryScanner(p);
        DependScanner scanner = new DependScanner(parentScanner);
        Vector allRootClasses = (Vector)this.rootClasses.clone();
        Enumeration e = this.rootFileSets.elements();
        while (e.hasMoreElements()) {
            FileSet additionalRootSet = (FileSet)e.nextElement();
            DirectoryScanner additionalScanner = additionalRootSet.getDirectoryScanner(p);
            String[] files = additionalScanner.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].endsWith(".class")) continue;
                String classFilePath = StringUtils.removeSuffix((String)files[i], (String)".class");
                String className = classFilePath.replace('/', '.').replace('\\', '.');
                allRootClasses.addElement(className);
            }
            scanner.addBasedir(additionalRootSet.getDir(p));
        }
        scanner.setBasedir(this.getDir(p));
        scanner.setRootClasses(allRootClasses);
        scanner.scan();
        return scanner;
    }

    public void addConfiguredRoot(ClassRoot root) {
        this.rootClasses.addElement(root.getClassname());
    }

    public Object clone() {
        return new ClassfileSet(this.isReference() ? (ClassfileSet)this.getRef(this.getProject()) : this);
    }

    protected synchronized void dieOnCircularReference(Stack stk, Project p) {
        if (this.isChecked()) {
            return;
        }
        super.dieOnCircularReference(stk, p);
        if (!this.isReference()) {
            Enumeration e = this.rootFileSets.elements();
            while (e.hasMoreElements()) {
                FileSet additionalRootSet = (FileSet)e.nextElement();
                ClassfileSet.pushAndInvokeCircularReferenceCheck((DataType)additionalRootSet, (Stack)stk, (Project)p);
            }
            this.setChecked(true);
        }
    }

    public static class ClassRoot {
        private String rootClass;

        public void setClassname(String name) {
            this.rootClass = name;
        }

        public String getClassname() {
            return this.rootClass;
        }
    }
}

