/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.actions;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.webdav.IResponse;
import org.guvnor.tools.Activator;
import org.guvnor.tools.utils.ActionUtils;
import org.guvnor.tools.utils.GuvnorMetadataProps;
import org.guvnor.tools.utils.GuvnorMetadataUtils;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.utils.webdav.IWebDavClient;
import org.guvnor.tools.utils.webdav.ResourceProperties;
import org.guvnor.tools.utils.webdav.WebDavClientFactory;
import org.guvnor.tools.utils.webdav.WebDavException;
import org.guvnor.tools.utils.webdav.WebDavServerCache;

public class UpdateAction
implements IObjectActionDelegate {
    private IStructuredSelection selectedItems;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        assert (this.selectedItems != null);
        for (Object oneItem : this.selectedItems) {
            if (!(oneItem instanceof IFile)) continue;
            this.processUpdate((IFile)oneItem);
        }
        PlatformUtils.updateDecoration();
    }

    private void processUpdate(IFile selectedFile) {
        block18: {
            IResponse response = null;
            try {
                try {
                    InputStream ins;
                    IWebDavClient client;
                    GuvnorMetadataProps props;
                    block17: {
                        props = GuvnorMetadataUtils.getGuvnorMetadata((IResource)selectedFile);
                        client = WebDavServerCache.getWebDavClient(props.getRepository());
                        if (client == null) {
                            client = WebDavClientFactory.createClient(new URL(props.getRepository()));
                            WebDavServerCache.cacheWebDavClient(props.getRepository(), client);
                        }
                        ins = null;
                        try {
                            response = client.getResourceInputStream(props.getFullpath());
                            ins = response.getInputStream();
                        }
                        catch (WebDavException wde) {
                            if (wde.getErrorCode() != 401) {
                                throw wde;
                            }
                            boolean retry = PlatformUtils.getInstance().authenticateForServer(props.getRepository(), client);
                            if (!retry) break block17;
                            response = client.getResourceInputStream(props.getFullpath());
                            ins = response.getInputStream();
                        }
                    }
                    if (ins != null) {
                        selectedFile.setContents(ins, true, true, null);
                        GuvnorMetadataUtils.markCurrentGuvnorResource((IResource)selectedFile);
                        ResourceProperties resProps = client.queryProperties(props.getFullpath());
                        GuvnorMetadataProps mdProps = GuvnorMetadataUtils.getGuvnorMetadata((IResource)selectedFile);
                        mdProps.setVersion(resProps.getLastModifiedDate());
                        mdProps.setRevision(resProps.getRevision());
                        GuvnorMetadataUtils.setGuvnorMetadataProps(selectedFile.getFullPath(), mdProps);
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().displayError(4, e.getMessage(), e, true);
                    if (response == null) break block18;
                    try {
                        response.close();
                    }
                    catch (IOException ioe) {
                        Activator.getDefault().writeLog(4, ioe.getMessage(), ioe);
                    }
                }
            }
            finally {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException ioe) {
                        Activator.getDefault().writeLog(4, ioe.getMessage(), ioe);
                    }
                }
            }
        }
    }

    private ResourceProperties getRemoteResourceProps(IFile file, GuvnorMetadataProps localProps) {
        ResourceProperties remoteProps = null;
        try {
            IWebDavClient client = WebDavServerCache.getWebDavClient(localProps.getRepository());
            if (client == null) {
                client = WebDavClientFactory.createClient(new URL(localProps.getRepository()));
                WebDavServerCache.cacheWebDavClient(localProps.getRepository(), client);
            }
            try {
                remoteProps = client.queryProperties(localProps.getFullpath());
            }
            catch (WebDavException wde) {
                if (wde.getErrorCode() != 401) {
                    throw wde;
                }
                boolean retry = PlatformUtils.getInstance().authenticateForServer(localProps.getRepository(), client);
                if (retry) {
                    remoteProps = client.queryProperties(localProps.getFullpath());
                }
            }
        }
        catch (Exception e) {
            Activator.getDefault().writeLog(4, e.getMessage(), e);
        }
        return remoteProps;
    }

    private boolean hasChangedRevision(ISelection selection) {
        boolean res;
        block8: {
            res = true;
            if (selection instanceof IStructuredSelection) break block8;
            return false;
        }
        try {
            IStructuredSelection sel = (IStructuredSelection)selection;
            for (Object oneSelection : sel) {
                if (!(oneSelection instanceof IFile)) continue;
                GuvnorMetadataProps localProps = GuvnorMetadataUtils.getGuvnorMetadata((IResource)((IFile)oneSelection));
                if (localProps != null) {
                    ResourceProperties remoteProps = this.getRemoteResourceProps((IFile)oneSelection, localProps);
                    if (remoteProps == null) {
                        res = false;
                    } else {
                        if (!remoteProps.getRevision().equals(localProps.getRevision())) continue;
                        res = false;
                    }
                } else {
                    res = false;
                }
                break;
            }
        }
        catch (Exception e) {
            Activator.getDefault().writeLog(4, e.getMessage(), e);
            res = false;
        }
        return res;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean validResourceSet;
        boolean bl = validResourceSet = ActionUtils.checkResourceSet(selection, true) && ActionUtils.areFilesDirty(selection) || this.hasChangedRevision(selection);
        if (validResourceSet) {
            action.setEnabled(true);
            this.selectedItems = (IStructuredSelection)selection;
        } else {
            action.setEnabled(false);
            this.selectedItems = null;
        }
    }
}

