/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.utils.webdav;

import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Path;
import org.eclipse.webdav.IContext;
import org.eclipse.webdav.ILocator;
import org.eclipse.webdav.IResponse;
import org.eclipse.webdav.client.RemoteDAVClient;
import org.eclipse.webdav.client.WebDAVFactory;
import org.eclipse.webdav.http.client.HttpClient;
import org.eclipse.webdav.http.client.IAuthenticator;
import org.guvnor.tools.Activator;
import org.guvnor.tools.utils.webdav.DebugHttpClient;
import org.guvnor.tools.utils.webdav.IWebDavClient;
import org.guvnor.tools.utils.webdav.ResourceProperties;
import org.guvnor.tools.utils.webdav.StreamProcessingUtils;
import org.guvnor.tools.utils.webdav.WebDavAuthenticator;
import org.guvnor.tools.utils.webdav.WebDavException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDavClient
implements IWebDavClient {
    private RemoteDAVClient client;
    private WebDavAuthenticator platformAuthenticator;

    WebDavClient(URL serverUrl) {
        DebugHttpClient httpClient = null;
        httpClient = Activator.getDefault().useDebugHttpClient() ? new DebugHttpClient() : new HttpClient();
        this.platformAuthenticator = new WebDavAuthenticator(serverUrl);
        httpClient.setAuthenticator(this.platformAuthenticator);
        this.client = new RemoteDAVClient(new WebDAVFactory(), (HttpClient)httpClient);
    }

    @Override
    public void setSessionAuthenticator(IAuthenticator sessionAuthen) {
        if (sessionAuthen != null) {
            this.client.getHttpClient().setAuthenticator(sessionAuthen);
        } else {
            this.client.getHttpClient().setAuthenticator((IAuthenticator)this.platformAuthenticator);
        }
    }

    @Override
    public RemoteDAVClient getClient() {
        return this.client;
    }

    @Override
    public IContext createContext() {
        IContext context = WebDAVFactory.contextFactory.newContext();
        context.put("USER-AGENT", "guvnor");
        return context;
    }

    @Override
    public Map<String, ResourceProperties> listDirectory(String path) throws Exception {
        IResponse response = null;
        try {
            IContext context = this.createContext();
            context.put("Depth", "1");
            ILocator locator = WebDAVFactory.locatorFactory.newLocator(path);
            response = this.client.propfind(locator, context, null);
            if (response.getStatusCode() != 207) {
                throw new WebDavException(response);
            }
            Map<String, ResourceProperties> res = StreamProcessingUtils.parseListing(path, response.getInputStream());
            this.addGuvnorResourceProperties(res, path);
            Map<String, ResourceProperties> map = res;
            return map;
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    private void addGuvnorResourceProperties(Map<String, ResourceProperties> props, String path) throws Exception {
        IResponse response = null;
        try {
            String apiVer = this.changeToAPICall(path);
            Properties guvProps = new Properties();
            response = this.getResourceInputStream(apiVer);
            guvProps.load(response.getInputStream());
            response.getInputStream();
            for (String oneKey : props.keySet()) {
                String val = guvProps.getProperty(oneKey);
                if (val == null) continue;
                ResourceProperties resProps = props.get(oneKey);
                StringTokenizer tokens = new StringTokenizer(val, ",");
                if (tokens.hasMoreElements()) {
                    resProps.setLastModifiedDate(tokens.nextToken());
                }
                if (!tokens.hasMoreElements()) continue;
                resProps.setRevision(tokens.nextToken());
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Override
    public ResourceProperties queryProperties(String resource) throws Exception {
        IResponse response = null;
        try {
            IContext context = this.createContext();
            context.put("Depth", "1");
            ILocator locator = WebDAVFactory.locatorFactory.newLocator(resource);
            response = this.client.propfind(locator, context, null);
            if (response.getStatusCode() != 207 && response.getStatusCode() != 200) {
                throw new WebDavException(response);
            }
            Map<String, ResourceProperties> props = StreamProcessingUtils.parseListing("", response.getInputStream());
            if (props.keySet().size() != 1) {
                throw new Exception(String.valueOf(props.keySet().size()) + " entries found for " + resource);
            }
            String fullpath = props.keySet().iterator().next();
            ResourceProperties res = props.get(fullpath);
            String filename = new Path(fullpath).lastSegment();
            this.addGuvnorResourceProperties(res, filename, resource);
            ResourceProperties resourceProperties = res;
            return resourceProperties;
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    private void addGuvnorResourceProperties(ResourceProperties props, String filename, String resource) throws Exception {
        if (props == null) {
            return;
        }
        IResponse response = null;
        try {
            String path = resource.substring(0, resource.lastIndexOf(47));
            String apiVer = this.changeToAPICall(path);
            Properties guvProps = new Properties();
            response = this.getResourceInputStream(apiVer);
            guvProps.load(response.getInputStream());
            String val = guvProps.getProperty(filename);
            if (val != null) {
                StringTokenizer tokens = new StringTokenizer(val, ",");
                if (tokens.hasMoreElements()) {
                    props.setLastModifiedDate(tokens.nextToken());
                }
                if (tokens.hasMoreElements()) {
                    props.setRevision(tokens.nextToken());
                }
            } else {
                Exception nfe = new Exception("Failed to get Guvnor properties for " + filename);
                Activator.getDefault().writeLog(2, nfe.getMessage(), nfe);
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Override
    public String getResourceContents(String resource) throws Exception {
        IResponse response = null;
        try {
            response = this.getResourceInputStream(resource);
            String string = StreamProcessingUtils.getStreamContents(response.getInputStream());
            return string;
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Override
    public String getResourceVersionContents(String resource, String version) throws Exception {
        String apiVer = String.valueOf(this.changeToAPICall(resource)) + "?version=" + version;
        return this.getResourceContents(apiVer);
    }

    @Override
    public IResponse getResourceInputStream(String resource) throws Exception {
        ILocator locator = WebDAVFactory.locatorFactory.newLocator(resource);
        IResponse response = this.client.get(locator, this.createContext());
        if (response.getStatusCode() != 200) {
            throw new WebDavException(response);
        }
        return response;
    }

    @Override
    public IResponse getResourceVersionInputStream(String resource, String version) throws Exception {
        String apiVer = String.valueOf(this.changeToAPICall(resource)) + "?version=" + version;
        return this.getResourceInputStream(apiVer);
    }

    @Override
    public boolean createResource(String resource, InputStream is) throws Exception {
        return this.createResource(resource, is, true);
    }

    @Override
    public boolean createResource(String resource, InputStream is, boolean overwrite) throws Exception {
        boolean res;
        block9: {
            res = true;
            if (!overwrite) {
                try {
                    if (this.queryProperties(resource) != null) {
                        res = false;
                    }
                }
                catch (WebDavException e) {
                    if (e.getErrorCode() == 404) break block9;
                    throw e;
                }
            }
        }
        IResponse response = null;
        try {
            ILocator locator;
            if (res && (response = this.client.put(locator = WebDAVFactory.locatorFactory.newLocator(resource), this.createContext(), is)).getStatusCode() != 200 && response.getStatusCode() != 201) {
                throw new WebDavException(response);
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        return res;
    }

    @Override
    public void putResource(String resource, InputStream is) throws Exception {
        IResponse response = null;
        try {
            ILocator locator = WebDAVFactory.locatorFactory.newLocator(resource);
            response = this.client.put(locator, this.createContext(), is);
            if (response.getStatusCode() != 200 && response.getStatusCode() != 204 && response.getStatusCode() != 201) {
                throw new WebDavException(response);
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Override
    public IResponse getResourceVersions(String resource) throws Exception {
        String apiVer = String.valueOf(this.changeToAPICall(resource)) + "?version=all";
        return this.getResourceInputStream(apiVer);
    }

    @Override
    public void deleteResource(String resource) throws Exception {
        IResponse response = null;
        try {
            ILocator locator = WebDAVFactory.locatorFactory.newLocator(resource);
            response = this.client.delete(locator, this.createContext());
            if (response.getStatusCode() != 204 && response.getStatusCode() != 200) {
                throw new WebDavException(response);
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    private String changeToAPICall(String path) {
        return path.replaceFirst("/webdav/", "/api/");
    }
}

