/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.detect.ContainerDetector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.microsoft.OfficeParser;

public class POIFSContainerDetector
implements ContainerDetector {
    private static final MediaType DEFAULT = MediaType.application((String)"x-tika-msoffice");

    public MediaType getDefault() {
        return DEFAULT;
    }

    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (TikaInputStream.isTikaInputStream((InputStream)input)) {
            TikaInputStream stream = TikaInputStream.get((InputStream)input);
            return this.detect(stream, metadata);
        }
        return DEFAULT;
    }

    public MediaType detect(TikaInputStream stream, Metadata metadata) throws IOException {
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(stream.getFile()));
        stream.setOpenContainer((Object)fs);
        OfficeParser.POIFSDocumentType type = OfficeParser.POIFSDocumentType.detectType(fs);
        if (type != OfficeParser.POIFSDocumentType.UNKNOWN) {
            return type.getType();
        }
        MediaType mt = this.detectCorel(fs.getRoot());
        if (mt != null) {
            return mt;
        }
        return DEFAULT;
    }

    protected MediaType detectCorel(DirectoryNode directory) {
        boolean hasNativeContentMain = false;
        boolean hasPerfectOfficeMain = false;
        boolean hasPerfectOfficeObjects = false;
        boolean hasSlideShow = false;
        for (Entry entry : directory) {
            if (entry.getName().equals("NativeContent_MAIN")) {
                hasNativeContentMain = true;
            }
            if (entry.getName().equals("PerfectOffice_MAIN")) {
                hasPerfectOfficeMain = true;
            }
            if (entry.getName().equals("PerfectOffice_OBJECTS")) {
                hasPerfectOfficeObjects = true;
            }
            if (!entry.getName().equals("SlideShow")) continue;
            hasSlideShow = true;
        }
        if (hasPerfectOfficeMain && hasSlideShow) {
            return MediaType.application((String)"x-corelpresentations");
        }
        if (hasPerfectOfficeMain && hasPerfectOfficeObjects) {
            return MediaType.application((String)"x-quattro-pro");
        }
        if (!hasPerfectOfficeMain && hasNativeContentMain) {
            return MediaType.application((String)"x-quattro-pro");
        }
        return null;
    }
}

