/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.html;

import de.l3s.boilerpipe.BoilerpipeExtractor;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import de.l3s.boilerpipe.extractors.DefaultExtractor;
import de.l3s.boilerpipe.sax.BoilerpipeHTMLContentHandler;
import java.io.Writer;
import org.apache.tika.sax.WriteOutContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class BoilerpipeContentHandler
extends BoilerpipeHTMLContentHandler {
    private static final char[] NL = new char[]{'\n'};
    private ContentHandler delegate;
    private BoilerpipeExtractor extractor;

    public BoilerpipeContentHandler(ContentHandler delegate) {
        this(delegate, (BoilerpipeExtractor)DefaultExtractor.INSTANCE);
    }

    public BoilerpipeContentHandler(Writer writer) {
        this((ContentHandler)new WriteOutContentHandler(writer));
    }

    public BoilerpipeContentHandler(ContentHandler delegate, BoilerpipeExtractor extractor) {
        this.delegate = delegate;
        this.extractor = extractor;
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        TextDocument td = this.toTextDocument();
        try {
            this.extractor.process(td);
        }
        catch (BoilerpipeProcessingException e) {
            throw new SAXException((Exception)((Object)e));
        }
        AttributesImpl emptyAttrs = new AttributesImpl();
        this.delegate.startDocument();
        this.delegate.startPrefixMapping("", "http://www.w3.org/1999/xhtml");
        this.delegate.startElement("http://www.w3.org/1999/xhtml", "html", "html", emptyAttrs);
        this.delegate.startElement("http://www.w3.org/1999/xhtml", "head", "head", emptyAttrs);
        this.delegate.startElement("http://www.w3.org/1999/xhtml", "title", "title", emptyAttrs);
        if (td.getTitle() != null) {
            char[] titleChars = td.getTitle().toCharArray();
            this.delegate.characters(titleChars, 0, titleChars.length);
            this.delegate.ignorableWhitespace(NL, 0, NL.length);
        }
        this.delegate.endElement("http://www.w3.org/1999/xhtml", "title", "title");
        this.delegate.endElement("http://www.w3.org/1999/xhtml", "head", "head");
        this.delegate.startElement("http://www.w3.org/1999/xhtml", "body", "body", emptyAttrs);
        for (TextBlock block : td.getTextBlocks()) {
            if (!block.isContent()) continue;
            this.delegate.startElement("http://www.w3.org/1999/xhtml", "p", "p", emptyAttrs);
            char[] chars = block.getText().toCharArray();
            this.delegate.characters(chars, 0, chars.length);
            this.delegate.endElement("http://www.w3.org/1999/xhtml", "p", "p");
            this.delegate.ignorableWhitespace(NL, 0, NL.length);
        }
        this.delegate.endElement("http://www.w3.org/1999/xhtml", "body", "body");
        this.delegate.endElement("http://www.w3.org/1999/xhtml", "html", "html");
        this.delegate.endPrefixMapping("");
        this.delegate.endDocument();
    }
}

