/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.tiff.TiffMetadataReader;
import com.drew.imaging.tiff.TiffProcessingException;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Property;
import org.xml.sax.SAXException;

public class ImageMetadataExtractor {
    private final org.apache.tika.metadata.Metadata metadata;
    private static final Pattern HOURS_MINUTES_SECONDS = Pattern.compile("(-?\\d+)\"(\\d+)'(\\d+\\.?\\d*)");
    private static final DecimalFormat LAT_LONG_FORMAT = new DecimalFormat("##0.0####", new DecimalFormatSymbols(Locale.US));
    private static final SimpleDateFormat DATE_UNSPECIFIED_TZ = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final Pattern LEADING_NUMBERS = Pattern.compile("(\\d+)\\s*.*");

    public ImageMetadataExtractor(org.apache.tika.metadata.Metadata metadata) {
        this.metadata = metadata;
    }

    public void parseTiff(InputStream stream) throws IOException, SAXException, TikaException {
        try {
            Metadata tiffMetadata = TiffMetadataReader.readMetadata((InputStream)stream);
            this.parse(tiffMetadata);
        }
        catch (TiffProcessingException e) {
            throw new TikaException("Can't read TIFF metadata", (Throwable)e);
        }
    }

    public void parseJpeg(InputStream stream) throws IOException, SAXException, TikaException {
        try {
            Metadata jpegMetadata = JpegMetadataReader.readMetadata((InputStream)stream);
            this.parse(jpegMetadata);
        }
        catch (JpegProcessingException e) {
            throw new TikaException("Can't read JPEG metadata", (Throwable)e);
        }
    }

    protected void parse(Metadata imageMetadata) throws IOException, SAXException, TikaException {
        try {
            Iterator directories = imageMetadata.getDirectoryIterator();
            while (directories.hasNext()) {
                Directory directory = (Directory)directories.next();
                Iterator tags = directory.getTagIterator();
                while (tags.hasNext()) {
                    Tag tag = (Tag)tags.next();
                    this.metadata.set(tag.getTagName(), tag.getDescription());
                    ImageMetadataExtractor.handleCommonImageTags(this.metadata, tag, directory);
                }
                ImageMetadataExtractor.handleGeoImageTags(this.metadata);
            }
        }
        catch (MetadataException e) {
            throw new TikaException("Can't read TIFF/JPEG metadata", (Throwable)e);
        }
    }

    public static void handleGeoImageTags(org.apache.tika.metadata.Metadata metadata) {
        Double longitude;
        Double latitude;
        String lat = metadata.get("GPS Latitude");
        String latNS = metadata.get("GPS Latitude Ref");
        if (lat != null && (latitude = ImageMetadataExtractor.parseHMS(lat)) != null) {
            if (latNS != null && latNS.equalsIgnoreCase("S") && latitude > 0.0) {
                latitude = latitude * -1.0;
            }
            metadata.set(org.apache.tika.metadata.Metadata.LATITUDE, LAT_LONG_FORMAT.format(latitude));
        }
        String lng = metadata.get("GPS Longitude");
        String lngEW = metadata.get("GPS Longitude Ref");
        if (lng != null && (longitude = ImageMetadataExtractor.parseHMS(lng)) != null) {
            if (lngEW != null && lngEW.equalsIgnoreCase("W") && longitude > 0.0) {
                longitude = longitude * -1.0;
            }
            metadata.set(org.apache.tika.metadata.Metadata.LONGITUDE, LAT_LONG_FORMAT.format(longitude));
        }
    }

    private static Double parseHMS(String hms) {
        Matcher m = HOURS_MINUTES_SECONDS.matcher(hms);
        if (m.matches()) {
            double value = (double)Integer.parseInt(m.group(1)) + (double)Integer.parseInt(m.group(2)) / 60.0 + Double.parseDouble(m.group(3)) / 60.0 / 60.0;
            return value;
        }
        return null;
    }

    private static synchronized void handleDate(Property property, org.apache.tika.metadata.Metadata metadata, Tag tag, Directory directory) throws MetadataException {
        Date date = directory.getDate(tag.getTagType());
        String dateString = DATE_UNSPECIFIED_TZ.format(date);
        metadata.set(property, dateString);
    }

    public static void handleCommonImageTags(org.apache.tika.metadata.Metadata metadata, Tag tag, Directory directory) throws MetadataException {
        Matcher m;
        if (tag.getTagName().equals("Date/Time") || tag.getTagType() == 306) {
            ImageMetadataExtractor.handleDate(org.apache.tika.metadata.Metadata.DATE, metadata, tag, directory);
            metadata.set(org.apache.tika.metadata.Metadata.LAST_MODIFIED, metadata.get(org.apache.tika.metadata.Metadata.DATE));
            return;
        }
        if (tag.getTagName().equals("Date/Time Original") || tag.getTagType() == 36867) {
            ImageMetadataExtractor.handleDate(org.apache.tika.metadata.Metadata.ORIGINAL_DATE, metadata, tag, directory);
            return;
        }
        if (tag.getTagName().equals("Exposure Time") || tag.getTagType() == 33434) {
            Object exposure = directory.getObject(tag.getTagType());
            if (exposure instanceof Rational) {
                metadata.set(org.apache.tika.metadata.Metadata.EXPOSURE_TIME, ((Rational)exposure).doubleValue());
            } else {
                metadata.set(org.apache.tika.metadata.Metadata.EXPOSURE_TIME, tag.getDescription());
            }
            return;
        }
        if (tag.getTagName().equals("Flash") || tag.getTagType() == 37385) {
            String flash = tag.getDescription();
            if (flash.indexOf("Flash fired") > -1) {
                metadata.set(org.apache.tika.metadata.Metadata.FLASH_FIRED, Boolean.TRUE.toString());
            } else if (flash.indexOf("Flash did not fire") > -1) {
                metadata.set(org.apache.tika.metadata.Metadata.FLASH_FIRED, Boolean.FALSE.toString());
            } else {
                metadata.set(org.apache.tika.metadata.Metadata.FLASH_FIRED, flash);
            }
            return;
        }
        if (tag.getTagName().equals("F-Number") || tag.getTagType() == 33437) {
            Object fnumber = directory.getObject(tag.getTagType());
            if (fnumber instanceof Rational) {
                metadata.set(org.apache.tika.metadata.Metadata.F_NUMBER, ((Rational)fnumber).doubleValue());
            } else {
                metadata.set(org.apache.tika.metadata.Metadata.F_NUMBER, tag.getDescription());
            }
            return;
        }
        if (tag.getTagName().equals("Focal Length") || tag.getTagType() == 37386) {
            Object length = directory.getObject(tag.getTagType());
            if (length instanceof Rational) {
                metadata.set(org.apache.tika.metadata.Metadata.FOCAL_LENGTH, ((Rational)length).doubleValue());
            } else {
                metadata.set(org.apache.tika.metadata.Metadata.FOCAL_LENGTH, tag.getDescription());
            }
            return;
        }
        if (tag.getTagName().equals("ISO Speed Ratings") || tag.getTagType() == 34855) {
            metadata.set(org.apache.tika.metadata.Metadata.ISO_SPEED_RATINGS, tag.getDescription());
            return;
        }
        if (tag.getTagName().equals("Make") || tag.getTagType() == 271) {
            metadata.set(org.apache.tika.metadata.Metadata.EQUIPMENT_MAKE, tag.getDescription());
            return;
        }
        if (tag.getTagName().equals("Model") || tag.getTagType() == 272) {
            metadata.set(org.apache.tika.metadata.Metadata.EQUIPMENT_MODEL, tag.getDescription());
            return;
        }
        if (tag.getTagName().equals("Orientation") || tag.getTagType() == 274) {
            Object length = directory.getObject(tag.getTagType());
            if (length instanceof Integer) {
                metadata.set(org.apache.tika.metadata.Metadata.ORIENTATION, Integer.toString((Integer)length));
            } else {
                metadata.set(org.apache.tika.metadata.Metadata.ORIENTATION, tag.getDescription());
            }
            return;
        }
        if (tag.getTagName().equals("Software") || tag.getTagType() == 305) {
            metadata.set(org.apache.tika.metadata.Metadata.SOFTWARE, tag.getDescription());
            return;
        }
        if (tag.getTagName().equals("X Resolution") || tag.getTagType() == 282) {
            Object resolution = directory.getObject(tag.getTagType());
            if (resolution instanceof Rational) {
                metadata.set(org.apache.tika.metadata.Metadata.RESOLUTION_HORIZONTAL, ((Rational)resolution).doubleValue());
            } else {
                metadata.set(org.apache.tika.metadata.Metadata.RESOLUTION_HORIZONTAL, tag.getDescription());
            }
            return;
        }
        if (tag.getTagName().equals("Y Resolution") || tag.getTagType() == 283) {
            Object resolution = directory.getObject(tag.getTagType());
            if (resolution instanceof Rational) {
                metadata.set(org.apache.tika.metadata.Metadata.RESOLUTION_VERTICAL, ((Rational)resolution).doubleValue());
            } else {
                metadata.set(org.apache.tika.metadata.Metadata.RESOLUTION_VERTICAL, tag.getDescription());
            }
            return;
        }
        if (tag.getTagName().equals("Resolution Unit") || tag.getTagType() == 296) {
            metadata.set(org.apache.tika.metadata.Metadata.RESOLUTION_UNIT, tag.getDescription());
            return;
        }
        if (tag.getTagName().equals("Keywords") || tag.getTagType() == 537) {
            metadata.set("Keywords", tag.getDescription());
            return;
        }
        if (tag.getTagName().equals("Jpeg Comment")) {
            metadata.set("Comments", tag.getDescription());
            return;
        }
        if ("Iptc".equals(tag.getDirectoryName())) {
            if ("Object Name".equals(tag.getTagName())) {
                metadata.set("title", tag.getDescription());
                return;
            }
            if ("By-line".equals(tag.getTagName())) {
                metadata.set("Author", tag.getDescription());
                return;
            }
            if ("Caption/Abstract".equals(tag.getTagName())) {
                metadata.set("description", tag.getDescription().replaceAll("\r\n?", "\n"));
                return;
            }
        }
        Property key = null;
        if (tag.getTagName().equals("Image Width") || tag.getTagType() == 256) {
            key = org.apache.tika.metadata.Metadata.IMAGE_WIDTH;
        }
        if (tag.getTagName().equals("Image Height") || tag.getTagType() == 257) {
            key = org.apache.tika.metadata.Metadata.IMAGE_LENGTH;
        }
        if (tag.getTagName().equals("Data Precision") || tag.getTagName().equals("Bits Per Sample") || tag.getTagType() == 258) {
            key = org.apache.tika.metadata.Metadata.BITS_PER_SAMPLE;
        }
        if (tag.getTagType() == 277) {
            key = org.apache.tika.metadata.Metadata.SAMPLES_PER_PIXEL;
        }
        if (key != null && (m = LEADING_NUMBERS.matcher(tag.getDescription())).matches()) {
            metadata.set(key, m.group(1));
        }
    }
}

