/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug.core;

import com.sun.jdi.StackFrame;
import java.util.ArrayList;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.debug.core.DroolsThread;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;

public class DroolsStackFrame
extends JDIStackFrame {
    protected static final String HANDLE_SUFIX = "__Handle__";
    protected static final String DROOLS_VAR_NAME = "drools";
    private static final String CONSEQUENCE_SIGNATURE = "(Lorg/drools/spi/KnowledgeHelper";

    public DroolsStackFrame(JDIThread thread, StackFrame frame, int depth) {
        super(thread, frame, depth);
    }

    public boolean isExecutingRule() {
        try {
            if (("defaultConsequence".equals(this.getMethodName()) || "consequence".equals(this.getMethodName())) && this.getSignature().startsWith(CONSEQUENCE_SIGNATURE)) {
                return true;
            }
        }
        catch (DebugException exc) {
            DroolsEclipsePlugin.log(exc);
        }
        return false;
    }

    public DRLInfo.RuleInfo getExecutingRuleInfo() {
        try {
            String methodName = this.getMethodName();
            String signature = this.getSignature();
            String type = this.getDeclaringTypeName();
            if (("defaultConsequence".equals(methodName) || "consequence".equals(methodName)) && signature.startsWith(CONSEQUENCE_SIGNATURE)) {
                return DroolsEclipsePlugin.getDefault().getRuleInfoByClass(type);
            }
        }
        catch (DebugException exc) {
            DroolsEclipsePlugin.log(exc);
        }
        return null;
    }

    public DRLInfo.FunctionInfo getExecutingFunctionInfo() {
        try {
            return DroolsEclipsePlugin.getDefault().getFunctionInfoByClass(this.getDeclaringTypeName());
        }
        catch (DebugException exc) {
            DroolsEclipsePlugin.log(exc);
            return null;
        }
    }

    protected JDIStackFrame bind(StackFrame frame, int depth) {
        JDIStackFrame jdiFrame = super.bind(frame, depth);
        if (jdiFrame != null && jdiFrame != this) {
            jdiFrame = DroolsThread.createCustomFrame((DroolsThread)this.getThread(), depth, frame);
        }
        return jdiFrame;
    }

    public IVariable[] getVariables() throws DebugException {
        IVariable[] variables = super.getVariables();
        ArrayList<IVariable> result = new ArrayList<IVariable>((variables.length - 1) / 2);
        int i = 0;
        while (i < variables.length) {
            String name = variables[i].getName();
            if (!name.equals(DROOLS_VAR_NAME) && !name.endsWith(HANDLE_SUFIX)) {
                result.add(variables[i]);
            }
            ++i;
        }
        variables = result.toArray(new IVariable[result.size()]);
        return variables;
    }

    public IJavaVariable[] getLocalVariables() throws DebugException {
        IJavaVariable[] localVars = super.getLocalVariables();
        return localVars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineNumber() throws DebugException {
        IThread iThread = this.getThread();
        synchronized (iThread) {
            DRLInfo.RuleInfo ruleInfo = this.getExecutingRuleInfo();
            if (ruleInfo != null) {
                return ruleInfo.getConsequenceDrlLineNumber() + (super.getLineNumber() - ruleInfo.getConsequenceJavaLineNumber() - 1);
            }
            DRLInfo.FunctionInfo functionInfo = this.getExecutingFunctionInfo();
            if (functionInfo != null) {
                return functionInfo.getDrlLineNumber() + (super.getLineNumber() - functionInfo.getJavaLineNumber());
            }
        }
        return super.getLineNumber();
    }

    public StackFrame getUnderlyingStackFrame() throws DebugException {
        return super.getUnderlyingStackFrame();
    }

    protected void setUnderlyingStackFrame(StackFrame frame) {
        super.setUnderlyingStackFrame(frame);
    }

    public void stepOver() throws DebugException {
        super.stepOver();
    }
}

