/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.definition.process.Node;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.ruleflow.core.NodeWrapper;
import org.eclipse.draw2d.geometry.Point;
import org.jbpm.workflow.core.Connection;
import org.jbpm.workflow.core.impl.ConnectionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionWrapper
extends ElementConnection {
    private static final long serialVersionUID = 510L;
    private ConnectionImpl connection;

    public Connection getConnection() {
        return this.connection;
    }

    public void localSetConnection(Connection connection) {
        this.connection = (ConnectionImpl)connection;
    }

    @Override
    public void disconnect() {
        super.disconnect();
        this.connection.terminate();
        this.connection = null;
    }

    @Override
    public void connect(ElementWrapper source, ElementWrapper target) {
        this.connection = new ConnectionImpl((Node)((NodeWrapper)source).getNode(), "DROOLS_DEFAULT", (Node)((NodeWrapper)target).getNode(), "DROOLS_DEFAULT");
        super.connect(source, target);
    }

    @Override
    protected List<Point> internalGetBendpoints() {
        return this.stringToBendpoints((String)this.connection.getMetaData("bendpoints"));
    }

    @Override
    protected void internalSetBendpoints(List<Point> bendpoints) {
        this.connection.setMetaData("bendpoints", (Object)this.bendpointsToString(bendpoints));
    }

    private String bendpointsToString(List<Point> bendpoints) {
        if (bendpoints == null) {
            return null;
        }
        String result = "[";
        Iterator<Point> iterator = bendpoints.iterator();
        while (iterator.hasNext()) {
            Point point = iterator.next();
            result = String.valueOf(result) + point.x + "," + point.y + (iterator.hasNext() ? ";" : "");
        }
        result = String.valueOf(result) + "]";
        return result;
    }

    private List<Point> stringToBendpoints(String s) {
        String[] bendpoints;
        ArrayList<Point> result = new ArrayList<Point>();
        if (s == null) {
            return result;
        }
        s = s.substring(1, s.length() - 1);
        String[] stringArray = bendpoints = s.split(";");
        int n = bendpoints.length;
        int n2 = 0;
        while (n2 < n) {
            String bendpoint = stringArray[n2];
            if ((bendpoint = bendpoint.trim()).length() != 0) {
                String[] xy = bendpoint.split(",");
                if (xy.length != 2) {
                    throw new IllegalArgumentException("Unexpected bendpoint: " + bendpoint + " for bendpoints " + bendpoints + " - nb points = " + xy.length);
                }
                try {
                    result.add(new Point(new Integer(xy[0]).intValue(), new Integer(xy[1]).intValue()));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Could not parse bendpoint " + bendpoint, e);
                }
            }
            ++n2;
        }
        return result;
    }
}

