/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import org.drools.eclipse.rulebuilder.ui.RuleDialog;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class AddCompositeConstraintOptionDialog
extends RuleDialog {
    private RuleModeller modeller;
    private FactPattern pattern;
    private final CompositeFieldConstraint constraint;

    public AddCompositeConstraintOptionDialog(Shell parent, RuleModeller modeller, CompositeFieldConstraint constraint, FactPattern pattern) {
        super(parent, "Add fields to this constriant", "Pick the value from combo.");
        this.modeller = modeller;
        this.constraint = constraint;
        this.pattern = pattern;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout l = new GridLayout();
        l.numColumns = 3;
        l.marginBottom = 0;
        l.marginHeight = 0;
        l.marginLeft = 0;
        l.marginRight = 0;
        l.marginTop = 0;
        l.marginWidth = 0;
        composite.setLayout((Layout)l);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.createFieldRestrictionCombo(composite, gd);
        this.createMultiFieldCombo(composite, gd);
        return composite;
    }

    private void createFieldRestrictionCombo(Composite composite, GridData gd) {
        this.createLabel(composite, "Add a restriction on a field");
        final Combo combo = new Combo(composite, 8);
        combo.setLayoutData((Object)gd);
        combo.add("...");
        String[] fields = this.modeller.getSuggestionCompletionEngine().getFieldCompletions(this.pattern.getFactType());
        int i = 0;
        while (i < fields.length) {
            combo.add(fields[i]);
            ++i;
        }
        combo.select(0);
        combo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (combo.getSelectionIndex() == 0) {
                    return;
                }
                AddCompositeConstraintOptionDialog.this.constraint.addConstraint((FieldConstraint)new SingleFieldConstraint(combo.getText()));
                AddCompositeConstraintOptionDialog.this.modeller.setDirty(true);
                AddCompositeConstraintOptionDialog.this.modeller.reloadLhs();
                AddCompositeConstraintOptionDialog.this.close();
            }
        });
    }

    private void createMultiFieldCombo(Composite composite, GridData gd) {
        this.createLabel(composite, "Multiple field constraint");
        final Combo combo = new Combo(composite, 8);
        combo.setLayoutData((Object)gd);
        combo.add("...");
        combo.add("All of (And)");
        combo.add("Any of (Or)");
        combo.setData("All of (And)", (Object)"&&");
        combo.setData("Any of (Or)", (Object)"||");
        combo.select(0);
        combo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (combo.getSelectionIndex() == 0) {
                    return;
                }
                CompositeFieldConstraint comp = new CompositeFieldConstraint();
                comp.compositeJunctionType = combo.getText();
                AddCompositeConstraintOptionDialog.this.constraint.addConstraint((FieldConstraint)comp);
                AddCompositeConstraintOptionDialog.this.modeller.reloadLhs();
                AddCompositeConstraintOptionDialog.this.modeller.setDirty(true);
                AddCompositeConstraintOptionDialog.this.close();
            }
        });
    }
}

