/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import org.drools.eclipse.rulebuilder.ui.RuleDialog;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.ide.common.client.modeldriven.brl.BaseSingleFieldConstraint;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ValueEditorTypeSelectionDialog
extends RuleDialog {
    private final FormToolkit toolkit;
    private RuleModeller modeller;
    private BaseSingleFieldConstraint constraint;

    public ValueEditorTypeSelectionDialog(Shell parent, FormToolkit toolkit, RuleModeller modeller, BaseSingleFieldConstraint constraint) {
        super(parent, "Select value editor type", "Select value editor type");
        this.toolkit = toolkit;
        this.modeller = modeller;
        this.constraint = constraint;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createLabel(composite, "Field value:");
        final Combo valueTypeCombo = new Combo(composite, 8);
        valueTypeCombo.add("Literal value");
        valueTypeCombo.add("A formula");
        if (this.modeller.getModel().getBoundVariablesInScope(this.constraint).size() > 0) {
            valueTypeCombo.add("Bound variable");
        }
        valueTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                switch (valueTypeCombo.getSelectionIndex()) {
                    case 0: {
                        ValueEditorTypeSelectionDialog.this.constraint.setConstraintValueType(1);
                        break;
                    }
                    case 1: {
                        ValueEditorTypeSelectionDialog.this.constraint.setConstraintValueType(3);
                        break;
                    }
                    case 2: {
                        ValueEditorTypeSelectionDialog.this.constraint.setConstraintValueType(2);
                    }
                }
                ValueEditorTypeSelectionDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ValueEditorTypeSelectionDialog.this.modeller.reloadLhs();
                        ValueEditorTypeSelectionDialog.this.modeller.setDirty(true);
                        ValueEditorTypeSelectionDialog.this.close();
                    }
                });
            }
        });
        this.toolkit.paintBordersFor(composite);
        return composite;
    }
}

