/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.helpers.XSSFXmlColumnPr;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTable;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableColumn;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.TableDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table
extends POIXMLDocumentPart {
    private CTTable ctTable;
    private List<XSSFXmlColumnPr> xmlColumnPr;
    private CellReference startCellReference;
    private CellReference endCellReference;
    private String commonXPath;

    public Table() {
        this.ctTable = CTTable.Factory.newInstance();
    }

    public Table(PackagePart part, PackageRelationship rel) throws IOException {
        super(part, rel);
        this.readFrom(part.getInputStream());
    }

    public void readFrom(InputStream is) throws IOException {
        try {
            TableDocument doc = TableDocument.Factory.parse((InputStream)is);
            this.ctTable = doc.getTable();
        }
        catch (XmlException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public XSSFSheet getXSSFSheet() {
        return (XSSFSheet)this.getParent();
    }

    public void writeTo(OutputStream out) throws IOException {
        TableDocument doc = TableDocument.Factory.newInstance();
        doc.setTable(this.ctTable);
        doc.save(out, DEFAULT_XML_OPTIONS);
    }

    @Override
    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.writeTo(out);
        out.close();
    }

    public CTTable getCTTable() {
        return this.ctTable;
    }

    public boolean mapsTo(long id) {
        boolean maps = false;
        List<XSSFXmlColumnPr> pointers = this.getXmlColumnPrs();
        for (XSSFXmlColumnPr pointer : pointers) {
            if (pointer.getMapId() != id) continue;
            maps = true;
            break;
        }
        return maps;
    }

    public String getCommonXpath() {
        if (this.commonXPath == null) {
            String[] commonTokens = new String[]{};
            block0: for (CTTableColumn column : this.ctTable.getTableColumns().getTableColumnList()) {
                if (column.getXmlColumnPr() == null) continue;
                String xpath = column.getXmlColumnPr().getXpath();
                String[] tokens = xpath.split("/");
                if (commonTokens.length == 0) {
                    commonTokens = tokens;
                    continue;
                }
                int maxLenght = commonTokens.length > tokens.length ? tokens.length : commonTokens.length;
                for (int i = 0; i < maxLenght; ++i) {
                    if (commonTokens[i].equals(tokens[i])) continue;
                    List<String> subCommonTokens = Arrays.asList(commonTokens).subList(0, i);
                    String[] container = new String[]{};
                    commonTokens = subCommonTokens.toArray(container);
                    continue block0;
                }
            }
            this.commonXPath = "";
            for (int i = 1; i < commonTokens.length; ++i) {
                this.commonXPath = this.commonXPath + "/" + commonTokens[i];
            }
        }
        return this.commonXPath;
    }

    public List<XSSFXmlColumnPr> getXmlColumnPrs() {
        if (this.xmlColumnPr == null) {
            this.xmlColumnPr = new Vector<XSSFXmlColumnPr>();
            for (CTTableColumn column : this.ctTable.getTableColumns().getTableColumnList()) {
                if (column.getXmlColumnPr() == null) continue;
                XSSFXmlColumnPr columnPr = new XSSFXmlColumnPr(this, column, column.getXmlColumnPr());
                this.xmlColumnPr.add(columnPr);
            }
        }
        return this.xmlColumnPr;
    }

    public long getNumerOfMappedColumns() {
        return this.ctTable.getTableColumns().getCount();
    }

    public CellReference getStartCellReference() {
        if (this.startCellReference == null) {
            String ref = this.ctTable.getRef();
            String[] boundaries = ref.split(":");
            String from = boundaries[0];
            this.startCellReference = new CellReference(from);
        }
        return this.startCellReference;
    }

    public CellReference getEndCellReference() {
        if (this.endCellReference == null) {
            String ref = this.ctTable.getRef();
            String[] boundaries = ref.split(":");
            String from = boundaries[1];
            this.endCellReference = new CellReference(from);
        }
        return this.endCellReference;
    }

    public int getRowCount() {
        CellReference from = this.getStartCellReference();
        CellReference to = this.getEndCellReference();
        int rowCount = -1;
        if (from != null && to != null) {
            rowCount = to.getRow() - from.getRow();
        }
        return rowCount;
    }
}

