/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.Source;
import org.apache.jackrabbit.commons.query.QueryObjectModelBuilderRegistry;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.query.QueryImpl;
import org.apache.jackrabbit.core.query.lucene.LuceneQueryFactory;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.join.QueryEngine;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.spi.commons.query.qom.BindVariableValueImpl;
import org.apache.jackrabbit.spi.commons.query.qom.DefaultTraversingQOMTreeVisitor;
import org.apache.jackrabbit.spi.commons.query.qom.QOMTreeVisitor;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelTree;

public class QueryObjectModelImpl
extends QueryImpl
implements QueryObjectModel {
    protected QueryObjectModelTree qomTree;
    private final Map<String, Value> variables = new HashMap<String, Value>();
    private LuceneQueryFactory lqf;

    public void init(SessionContext sessionContext, QueryHandler handler, String statement, String language, Node node) throws InvalidQueryException {
        throw new UnsupportedOperationException();
    }

    public void init(SessionContext sessionContext, QueryHandler handler, QueryObjectModelTree qomTree, String language, Node node) throws InvalidQueryException, RepositoryException {
        this.checkNotInitialized();
        this.sessionContext = sessionContext;
        this.language = language;
        this.handler = handler;
        this.qomTree = qomTree;
        this.node = node;
        this.statement = QueryObjectModelBuilderRegistry.getQueryObjectModelBuilder((String)language).toString((QueryObjectModel)this);
        try {
            qomTree.accept((QOMTreeVisitor)new DefaultTraversingQOMTreeVisitor(){

                public Object visit(BindVariableValueImpl node, Object data) {
                    QueryObjectModelImpl.this.variables.put(node.getBindVariableName(), null);
                    return data;
                }
            }, null);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        this.lqf = new LuceneQueryFactory(sessionContext.getSessionImpl(), (SearchIndex)handler, this.variables);
        this.setInitialized();
    }

    public QueryResult execute() throws RepositoryException {
        QueryEngine engine = new QueryEngine((Session)this.sessionContext.getSessionImpl(), this.lqf, this.variables);
        return engine.execute(this.getColumns(), this.getSource(), this.getConstraint(), this.getOrderings(), this.offset, this.limit);
    }

    public String[] getBindVariableNames() {
        return this.variables.keySet().toArray(new String[this.variables.size()]);
    }

    public void bindValue(String varName, Value value) throws IllegalArgumentException {
        if (!this.variables.containsKey(varName)) {
            throw new IllegalArgumentException("No such bind variable: " + varName);
        }
        this.variables.put(varName, value);
    }

    public Source getSource() {
        return this.qomTree.getSource();
    }

    public Constraint getConstraint() {
        return this.qomTree.getConstraint();
    }

    public Ordering[] getOrderings() {
        return this.qomTree.getOrderings();
    }

    public Column[] getColumns() {
        return this.qomTree.getColumns();
    }
}

