/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.spi.Name;

public final class ChildNodeEntry {
    private int hash;
    private final Name name;
    private final int index;
    private final NodeId id;

    ChildNodeEntry(Name name, NodeId id, int index) {
        if (name == null) {
            throw new IllegalArgumentException("name can not be null");
        }
        this.name = name;
        if (id == null) {
            throw new IllegalArgumentException("id can not be null");
        }
        this.id = id;
        if (index < 1) {
            throw new IllegalArgumentException("index is 1-based");
        }
        this.index = index;
    }

    public NodeId getId() {
        return this.id;
    }

    public Name getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChildNodeEntry) {
            ChildNodeEntry other = (ChildNodeEntry)obj;
            return this.name.equals(other.name) && this.id.equals(other.id) && this.index == other.index;
        }
        return false;
    }

    public String toString() {
        return this.name.toString() + "[" + this.index + "] -> " + this.id;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = 17;
            h = 37 * h + this.name.hashCode();
            h = 37 * h + this.id.hashCode();
            this.hash = h = 37 * h + this.index;
        }
        return h;
    }
}

