/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.util.db;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.jackrabbit.core.util.db.DbUtility;

public final class ResultSetWrapper
implements InvocationHandler {
    private final Connection connection;
    private final Statement statement;
    private final ResultSet resultSet;

    public static final ResultSet newInstance(Connection con, Statement stmt, ResultSet rs) {
        ResultSetWrapper proxy = new ResultSetWrapper(con, stmt, rs);
        return (ResultSet)Proxy.newProxyInstance(rs.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)proxy);
    }

    private ResultSetWrapper(Connection con, Statement stmt, ResultSet rs) {
        this.connection = con;
        this.statement = stmt;
        this.resultSet = rs;
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if ("close".equals(m.getName())) {
            DbUtility.close(this.connection, this.statement, this.resultSet);
            return null;
        }
        return m.invoke((Object)this.resultSet, args);
    }
}

