/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.sasn1;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.sasn1.Asn1Integer;
import org.bouncycastle.sasn1.Asn1Null;
import org.bouncycastle.sasn1.Asn1Object;
import org.bouncycastle.sasn1.Asn1ObjectIdentifier;
import org.bouncycastle.sasn1.Asn1TaggedObject;
import org.bouncycastle.sasn1.BerOctetString;
import org.bouncycastle.sasn1.BerSequence;
import org.bouncycastle.sasn1.BerSet;
import org.bouncycastle.sasn1.DefiniteLengthInputStream;
import org.bouncycastle.sasn1.DerOctetString;
import org.bouncycastle.sasn1.DerSequence;
import org.bouncycastle.sasn1.DerSet;
import org.bouncycastle.sasn1.IndefiniteLengthInputStream;

public class Asn1InputStream {
    InputStream _in;
    private int _limit;
    private boolean _eofFound;

    public Asn1InputStream(InputStream inputStream) {
        this._in = inputStream;
        this._limit = Integer.MAX_VALUE;
    }

    public Asn1InputStream(InputStream inputStream, int n) {
        this._in = inputStream;
        this._limit = n;
    }

    public Asn1InputStream(byte[] byArray) {
        this._in = new ByteArrayInputStream(byArray);
        this._limit = byArray.length;
    }

    InputStream getParentStream() {
        return this._in;
    }

    private int readLength() throws IOException {
        int n = this._in.read();
        if (n < 0) {
            throw new IOException("EOF found when length expected");
        }
        if (n == 128) {
            return -1;
        }
        if (n > 127) {
            int n2 = n & 0x7F;
            if (n2 > 4) {
                throw new IOException("DER length more than 4 bytes");
            }
            n = 0;
            for (int i = 0; i < n2; ++i) {
                int n3 = this._in.read();
                if (n3 < 0) {
                    throw new IOException("EOF found reading length");
                }
                n = (n << 8) + n3;
            }
            if (n < 0) {
                throw new IOException("corrupted stream - negative length found");
            }
            if (n >= this._limit) {
                throw new IOException("corrupted stream - out of bounds length found");
            }
        }
        return n;
    }

    public Asn1Object readObject() throws IOException {
        int n;
        int n2;
        int n3 = this._in.read();
        if (n3 == -1) {
            if (this._eofFound) {
                throw new EOFException("attempt to read past end of file.");
            }
            this._eofFound = true;
            return null;
        }
        if (this._in instanceof IndefiniteLengthInputStream) {
            ((IndefiniteLengthInputStream)this._in).setEofOn00(false);
        }
        int n4 = n2 = n3 & 0xFFFFFFDF;
        if ((n3 & 0x80) != 0 && (n4 = n3 & 0x1F) == 31) {
            n4 = 0;
            n = this._in.read();
            while (n >= 0 && (n & 0x80) != 0) {
                n4 |= n & 0x7F;
                n4 <<= 7;
                n = this._in.read();
            }
            if (n < 0) {
                this._eofFound = true;
                throw new EOFException("EOF encountered inside tag value.");
            }
            n4 |= n & 0x7F;
        }
        if ((n = this.readLength()) < 0) {
            IndefiniteLengthInputStream indefiniteLengthInputStream = new IndefiniteLengthInputStream(this._in);
            switch (n2) {
                case 5: {
                    return new Asn1Null(n3);
                }
                case 4: {
                    return new BerOctetString(n3, indefiniteLengthInputStream);
                }
                case 16: {
                    return new BerSequence(n3, indefiniteLengthInputStream);
                }
                case 17: {
                    return new BerSet(n3, indefiniteLengthInputStream);
                }
            }
            return new Asn1TaggedObject(n3, n4, indefiniteLengthInputStream);
        }
        DefiniteLengthInputStream definiteLengthInputStream = new DefiniteLengthInputStream(this._in, n);
        switch (n2) {
            case 2: {
                return new Asn1Integer(n3, definiteLengthInputStream.toByteArray());
            }
            case 5: {
                return new Asn1Null(n3);
            }
            case 6: {
                return new Asn1ObjectIdentifier(n3, definiteLengthInputStream.toByteArray());
            }
            case 4: {
                return new DerOctetString(n3, definiteLengthInputStream.toByteArray());
            }
            case 16: {
                return new DerSequence(n3, definiteLengthInputStream.toByteArray());
            }
            case 17: {
                return new DerSet(n3, definiteLengthInputStream.toByteArray());
            }
        }
        return new Asn1TaggedObject(n3, n4, definiteLengthInputStream);
    }
}

