/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.index.ByteSliceReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DefaultSkipListWriter;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FreqProxFieldMergeState;
import org.apache.lucene.index.FreqProxTermsWriterPerField;
import org.apache.lucene.index.FreqProxTermsWriterPerThread;
import org.apache.lucene.index.RawPostingList;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosWriter;
import org.apache.lucene.index.TermsHashConsumer;
import org.apache.lucene.index.TermsHashConsumerPerThread;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.index.TermsHashPerThread;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.UnicodeUtil;

final class FreqProxTermsWriter
extends TermsHashConsumer {
    final byte[] copyByteBuffer = new byte[4096];
    private final TermInfo termInfo = new TermInfo();
    final UnicodeUtil.UTF8Result termsUTF8 = new UnicodeUtil.UTF8Result();
    static final /* synthetic */ boolean $assertionsDisabled;

    FreqProxTermsWriter() {
    }

    public TermsHashConsumerPerThread addThread(TermsHashPerThread perThread) {
        return new FreqProxTermsWriterPerThread(perThread);
    }

    void createPostings(RawPostingList[] postings, int start, int count) {
        int end = start + count;
        for (int i = start; i < end; ++i) {
            postings[i] = new PostingList();
        }
    }

    private static int compareText(char[] text1, int pos1, char[] text2, int pos2) {
        char c1;
        do {
            char c2;
            if ((c1 = text1[pos1++]) == (c2 = text2[pos2++])) continue;
            if ('\uffff' == c2) {
                return 1;
            }
            if ('\uffff' == c1) {
                return -1;
            }
            return c1 - c2;
        } while ('\uffff' != c1);
        return 0;
    }

    void closeDocStore(DocumentsWriter.FlushState state) {
    }

    void abort() {
    }

    public void flush(Map threadsAndFields, DocumentsWriter.FlushState state) throws IOException {
        ArrayList<FreqProxTermsWriterPerField> allFields = new ArrayList<FreqProxTermsWriterPerField>();
        Iterator it = threadsAndFields.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Collection fields = (Collection)entry.getValue();
            Iterator fieldsIt = fields.iterator();
            while (fieldsIt.hasNext()) {
                FreqProxTermsWriterPerField perField = (FreqProxTermsWriterPerField)fieldsIt.next();
                if (perField.termsHashPerField.numPostings <= 0) continue;
                allFields.add(perField);
            }
        }
        Collections.sort(allFields);
        int numAllFields = allFields.size();
        TermInfosWriter termsOut = new TermInfosWriter(state.directory, state.segmentName, this.fieldInfos, state.docWriter.writer.getTermIndexInterval());
        IndexOutput freqOut = state.directory.createOutput(state.segmentFileName("frq"));
        IndexOutput proxOut = this.fieldInfos.hasProx() ? state.directory.createOutput(state.segmentFileName("prx")) : null;
        DefaultSkipListWriter skipListWriter = new DefaultSkipListWriter(termsOut.skipInterval, termsOut.maxSkipLevels, state.numDocsInRAM, freqOut, proxOut);
        int start = 0;
        while (start < numAllFields) {
            int i;
            int end;
            FieldInfo fieldInfo = ((FreqProxTermsWriterPerField)allFields.get((int)start)).fieldInfo;
            String fieldName = fieldInfo.name;
            for (end = start + 1; end < numAllFields && ((FreqProxTermsWriterPerField)allFields.get((int)end)).fieldInfo.name.equals(fieldName); ++end) {
            }
            FreqProxTermsWriterPerField[] fields = new FreqProxTermsWriterPerField[end - start];
            for (i = start; i < end; ++i) {
                fields[i - start] = (FreqProxTermsWriterPerField)allFields.get(i);
                fieldInfo.storePayloads |= fields[i - start].hasPayloads;
            }
            this.appendPostings(state, fields, termsOut, freqOut, proxOut, skipListWriter);
            for (i = 0; i < fields.length; ++i) {
                TermsHashPerField perField = fields[i].termsHashPerField;
                int numPostings = perField.numPostings;
                perField.reset();
                perField.shrinkHash(numPostings);
                fields[i].reset();
            }
            start = end;
        }
        it = threadsAndFields.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            FreqProxTermsWriterPerThread perThread = (FreqProxTermsWriterPerThread)entry.getKey();
            perThread.termsHashPerThread.reset(true);
        }
        freqOut.close();
        if (proxOut != null) {
            state.flushedFiles.add(state.segmentFileName("prx"));
            proxOut.close();
        }
        termsOut.close();
        state.flushedFiles.add(state.segmentFileName("fnm"));
        state.flushedFiles.add(state.segmentFileName("frq"));
        state.flushedFiles.add(state.segmentFileName("tis"));
        state.flushedFiles.add(state.segmentFileName("tii"));
    }

    void copyBytes(IndexInput srcIn, IndexOutput destIn, long numBytes) throws IOException {
        while (numBytes > 0L) {
            int chunk = numBytes > 4096L ? 4096 : (int)numBytes;
            srcIn.readBytes(this.copyByteBuffer, 0, chunk);
            destIn.writeBytes(this.copyByteBuffer, 0, chunk);
            numBytes -= (long)chunk;
        }
    }

    void appendPostings(DocumentsWriter.FlushState flushState, FreqProxTermsWriterPerField[] fields, TermInfosWriter termsOut, IndexOutput freqOut, IndexOutput proxOut, DefaultSkipListWriter skipListWriter) throws CorruptIndexException, IOException {
        int fieldNumber = fields[0].fieldInfo.number;
        int numFields = fields.length;
        FreqProxFieldMergeState[] mergeStates = new FreqProxFieldMergeState[numFields];
        for (int i = 0; i < numFields; ++i) {
            FreqProxFieldMergeState fms = mergeStates[i] = new FreqProxFieldMergeState(fields[i]);
            if (!$assertionsDisabled && fms.field.fieldInfo != fields[0].fieldInfo) {
                throw new AssertionError();
            }
            boolean result = fms.nextTerm();
            if (!$assertionsDisabled && !result) {
                throw new AssertionError();
            }
        }
        int skipInterval = termsOut.skipInterval;
        boolean currentFieldOmitTf = fields[0].fieldInfo.omitTf;
        boolean currentFieldStorePayloads = currentFieldOmitTf ? false : fields[0].fieldInfo.storePayloads;
        FreqProxFieldMergeState[] termStates = new FreqProxFieldMergeState[numFields];
        while (numFields > 0) {
            termStates[0] = mergeStates[0];
            int numToMerge = 1;
            for (int i = 1; i < numFields; ++i) {
                char[] text = mergeStates[i].text;
                int textOffset = mergeStates[i].textOffset;
                int cmp = FreqProxTermsWriter.compareText(text, textOffset, termStates[0].text, termStates[0].textOffset);
                if (cmp < 0) {
                    termStates[0] = mergeStates[i];
                    numToMerge = 1;
                    continue;
                }
                if (cmp != 0) continue;
                termStates[numToMerge++] = mergeStates[i];
            }
            int df = 0;
            int lastPayloadLength = -1;
            int lastDoc = 0;
            char[] text = termStates[0].text;
            int start = termStates[0].textOffset;
            long freqPointer = freqOut.getFilePointer();
            long proxPointer = proxOut != null ? proxOut.getFilePointer() : 0L;
            skipListWriter.resetSkip();
            while (numToMerge > 0) {
                int i;
                if (++df % skipInterval == 0) {
                    skipListWriter.setSkipData(lastDoc, currentFieldStorePayloads, lastPayloadLength);
                    skipListWriter.bufferSkip(df);
                }
                FreqProxFieldMergeState minState = termStates[0];
                for (int i2 = 1; i2 < numToMerge; ++i2) {
                    if (termStates[i2].docID >= minState.docID) continue;
                    minState = termStates[i2];
                }
                int doc = minState.docID;
                int termDocFreq = minState.termFreq;
                if (!$assertionsDisabled && doc >= flushState.numDocsInRAM) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && doc <= lastDoc && df != 1) {
                    throw new AssertionError();
                }
                ByteSliceReader prox = minState.prox;
                if (!currentFieldOmitTf) {
                    if (!$assertionsDisabled && proxOut == null) {
                        throw new AssertionError();
                    }
                    for (int j = 0; j < termDocFreq; ++j) {
                        int code = prox.readVInt();
                        if (currentFieldStorePayloads) {
                            int payloadLength = (code & 1) != 0 ? prox.readVInt() : 0;
                            if (payloadLength != lastPayloadLength) {
                                proxOut.writeVInt(code | 1);
                                proxOut.writeVInt(payloadLength);
                                lastPayloadLength = payloadLength;
                            } else {
                                proxOut.writeVInt(code & 0xFFFFFFFE);
                            }
                            if (payloadLength <= 0) continue;
                            this.copyBytes(prox, proxOut, payloadLength);
                            continue;
                        }
                        if (!$assertionsDisabled && 0 != (code & 1)) {
                            throw new AssertionError();
                        }
                        proxOut.writeVInt(code >> 1);
                    }
                    int newDocCode = doc - lastDoc << 1;
                    if (1 == termDocFreq) {
                        freqOut.writeVInt(newDocCode | 1);
                    } else {
                        freqOut.writeVInt(newDocCode);
                        freqOut.writeVInt(termDocFreq);
                    }
                } else {
                    freqOut.writeVInt(doc - lastDoc);
                }
                lastDoc = doc;
                if (minState.nextDoc()) continue;
                int upto = 0;
                for (i = 0; i < numToMerge; ++i) {
                    if (termStates[i] == minState) continue;
                    termStates[upto++] = termStates[i];
                }
                if (!$assertionsDisabled && upto != --numToMerge) {
                    throw new AssertionError();
                }
                if (minState.nextTerm()) continue;
                upto = 0;
                for (i = 0; i < numFields; ++i) {
                    if (mergeStates[i] == minState) continue;
                    mergeStates[upto++] = mergeStates[i];
                }
                if (!$assertionsDisabled && upto != --numFields) {
                    throw new AssertionError();
                }
            }
            if (!$assertionsDisabled && df <= 0) {
                throw new AssertionError();
            }
            long skipPointer = skipListWriter.writeSkip(freqOut);
            this.termInfo.set(df, freqPointer, proxPointer, (int)(skipPointer - freqPointer));
            UnicodeUtil.UTF16toUTF8(text, start, this.termsUTF8);
            termsOut.add(fieldNumber, this.termsUTF8.result, this.termsUTF8.length, this.termInfo);
        }
    }

    void files(Collection files) {
    }

    int bytesPerPosting() {
        return 36;
    }

    static {
        $assertionsDisabled = !FreqProxTermsWriter.class.desiredAssertionStatus();
    }

    static final class PostingList
    extends RawPostingList {
        int docFreq;
        int lastDocID;
        int lastDocCode;
        int lastPosition;

        PostingList() {
        }
    }
}

