/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.rule.Pattern;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.Constraint;

public class InstanceNotEqualsConstraint
implements BetaNodeFieldConstraint {
    private static final long serialVersionUID = 510L;
    private static Declaration[] declarations = new Declaration[0];
    private Pattern otherPattern;

    public InstanceNotEqualsConstraint() {
    }

    public InstanceNotEqualsConstraint(Pattern otherPattern) {
        this.otherPattern = otherPattern;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        declarations = (Declaration[])in.readObject();
        this.otherPattern = (Pattern)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(declarations);
        out.writeObject(this.otherPattern);
    }

    public Declaration[] getRequiredDeclarations() {
        return declarations;
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
    }

    public Pattern getOtherPattern() {
        return this.otherPattern;
    }

    public boolean isTemporal() {
        return false;
    }

    public ContextEntry createContextEntry() {
        return new InstanceNotEqualsConstraintContextEntry(this.otherPattern);
    }

    public boolean isAllowed(ContextEntry entry) {
        InstanceNotEqualsConstraintContextEntry context = (InstanceNotEqualsConstraintContextEntry)entry;
        return context.left != context.right;
    }

    public boolean isAllowedCachedLeft(ContextEntry context, InternalFactHandle handle) {
        return ((InstanceNotEqualsConstraintContextEntry)context).left != handle.getObject();
    }

    public boolean isAllowedCachedRight(LeftTuple tuple, ContextEntry context) {
        return tuple.get(this.otherPattern.getOffset()).getObject() != ((InstanceNotEqualsConstraintContextEntry)context).right;
    }

    public String toString() {
        return "[InstanceEqualsConstraint otherPattern=" + this.otherPattern + " ]";
    }

    public int hashCode() {
        return this.otherPattern.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof InstanceNotEqualsConstraint)) {
            return false;
        }
        InstanceNotEqualsConstraint other = (InstanceNotEqualsConstraint)object;
        return this.otherPattern.equals(other.otherPattern);
    }

    public Object clone() {
        return new InstanceNotEqualsConstraint(this.otherPattern);
    }

    public Constraint.ConstraintType getType() {
        return Constraint.ConstraintType.BETA;
    }

    public static class InstanceNotEqualsConstraintContextEntry
    implements ContextEntry {
        private static final long serialVersionUID = 510L;
        public Object left;
        public Object right;
        private Pattern pattern;
        private ContextEntry entry;

        public InstanceNotEqualsConstraintContextEntry() {
        }

        public InstanceNotEqualsConstraintContextEntry(Pattern pattern) {
            this.pattern = pattern;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.left = in.readObject();
            this.right = in.readObject();
            this.pattern = (Pattern)in.readObject();
            this.entry = (ContextEntry)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.left);
            out.writeObject(this.right);
            out.writeObject(this.pattern);
            out.writeObject(this.entry);
        }

        public ContextEntry getNext() {
            return this.entry;
        }

        public void setNext(ContextEntry entry) {
            this.entry = entry;
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.left = tuple.get(this.pattern.getOffset()).getObject();
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.right = handle.getObject();
        }

        public void resetTuple() {
            this.left = null;
        }

        public void resetFactHandle() {
            this.right = null;
        }
    }
}

