/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuntimeDroolsException;
import org.drools.WorkingMemoryEntryPoint;
import org.drools.base.ClassObjectType;
import org.drools.common.AbstractWorkingMemory;
import org.drools.common.EqualityKey;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.InternalWorkingMemoryEntryPoint;
import org.drools.common.ObjectStore;
import org.drools.common.ObjectTypeConfigurationRegistry;
import org.drools.common.PropagationContextImpl;
import org.drools.common.SingleThreadedObjectStore;
import org.drools.common.TruthMaintenanceSystem;
import org.drools.core.util.Iterator;
import org.drools.core.util.ObjectHashSet;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.ObjectTypeConf;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.Rete;
import org.drools.rule.EntryPoint;
import org.drools.rule.Rule;
import org.drools.runtime.ObjectFilter;
import org.drools.spi.Activation;
import org.drools.spi.FactHandleFactory;
import org.drools.spi.ObjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedEntryPoint
implements InternalWorkingMemoryEntryPoint,
WorkingMemoryEntryPoint,
PropertyChangeListener {
    protected static final Class[] ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES = new Class[]{PropertyChangeListener.class};
    protected final Object[] addRemovePropertyChangeListenerArgs = new Object[]{this};
    private static final long serialVersionUID = 510L;
    protected ObjectStore objectStore;
    protected transient InternalRuleBase ruleBase;
    protected EntryPoint entryPoint;
    protected EntryPointNode entryPointNode;
    private ObjectTypeConfigurationRegistry typeConfReg;
    private final AbstractWorkingMemory wm;
    private FactHandleFactory handleFactory;
    protected final ReentrantLock lock;

    public NamedEntryPoint(EntryPoint entryPoint, EntryPointNode entryPointNode, AbstractWorkingMemory wm) {
        this(entryPoint, entryPointNode, wm, new ReentrantLock());
    }

    public NamedEntryPoint(EntryPoint entryPoint, EntryPointNode entryPointNode, AbstractWorkingMemory wm, ReentrantLock lock) {
        this.entryPoint = entryPoint;
        this.entryPointNode = entryPointNode;
        this.wm = wm;
        this.ruleBase = (InternalRuleBase)this.wm.getRuleBase();
        this.lock = lock;
        this.typeConfReg = new ObjectTypeConfigurationRegistry(this.ruleBase);
        this.handleFactory = this.wm.getFactHandleFactory();
        this.objectStore = new SingleThreadedObjectStore(this.ruleBase.getConfiguration(), this.lock);
    }

    @Override
    public void reset() {
        this.objectStore.clear();
    }

    @Override
    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    @Override
    public EntryPointNode getEntryPointNode() {
        return this.entryPointNode;
    }

    @Override
    public FactHandle insert(Object object) throws FactException {
        return this.insert(object, false, false, null, null);
    }

    @Override
    public FactHandle insert(Object object, boolean dynamic) throws FactException {
        return this.insert(object, dynamic, false, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected FactHandle insert(Object object, boolean dynamic, boolean logical, Rule rule, Activation activation) throws FactException {
        if (object == null) {
            return null;
        }
        try {
            this.wm.startOperation();
            ObjectTypeConf typeConf = this.typeConfReg.getObjectTypeConf(this.entryPoint, object);
            if (logical && !typeConf.isTMSEnabled()) {
                this.enableTMS(object, typeConf);
            }
            InternalFactHandle handle = null;
            if (this.wm.isSequential()) {
                handle = this.createHandle(object, typeConf);
                this.insert(handle, object, rule, activation, typeConf);
                InternalFactHandle internalFactHandle = handle;
                return internalFactHandle;
            }
            try {
                block36: {
                    block38: {
                        EqualityKey key;
                        TruthMaintenanceSystem tms;
                        block40: {
                            block41: {
                                block39: {
                                    this.ruleBase.readLock();
                                    this.lock.lock();
                                    handle = this.objectStore.getHandleForObject(object);
                                    if (!typeConf.isTMSEnabled()) break block38;
                                    tms = this.wm.getTruthMaintenanceSystem();
                                    if (handle != null) break block39;
                                    key = tms.get(object);
                                    if (key != null) break block40;
                                    break block41;
                                }
                                EqualityKey key2 = handle.getEqualityKey();
                                if (key2.getStatus() == 1) {
                                    InternalFactHandle internalFactHandle = handle;
                                    return internalFactHandle;
                                }
                                if (!logical) {
                                    key2.setStatus(1);
                                    tms.removeLogicalDependencies(handle);
                                } else {
                                    tms.addLogicalDependency(handle, activation, activation.getPropagationContext(), rule);
                                }
                                InternalFactHandle internalFactHandle = handle;
                                return internalFactHandle;
                            }
                            handle = this.createHandle(object, typeConf);
                            key = this.createEqualityKey(handle);
                            tms.put(key);
                            if (!logical) {
                                key.setStatus(1);
                                break block36;
                            } else {
                                key.setStatus(2);
                                tms.addLogicalDependency(handle, activation, activation.getPropagationContext(), rule);
                            }
                            break block36;
                        }
                        if (!logical) {
                            if (key.getStatus() == 2) {
                                InternalFactHandle justifiedHandle = key.getFactHandle();
                                tms.removeLogicalDependencies(justifiedHandle);
                                if (this.wm.discardOnLogicalOverride) {
                                    key.setStatus(1);
                                    handle = key.getFactHandle();
                                    if (RuleBaseConfiguration.AssertBehaviour.IDENTITY.equals(this.ruleBase.getConfiguration().getAssertBehaviour())) {
                                        this.objectStore.updateHandle(handle, object);
                                    }
                                    InternalFactHandle internalFactHandle = handle;
                                    return internalFactHandle;
                                }
                                key.setStatus(1);
                                handle = this.createHandle(object, typeConf);
                                handle.setEqualityKey(key);
                                key.addFactHandle(handle);
                                break block36;
                            } else {
                                handle = this.createHandle(object, typeConf);
                                key.addFactHandle(handle);
                                handle.setEqualityKey(key);
                            }
                            break block36;
                        } else {
                            if (key.getStatus() == 2) {
                                tms.addLogicalDependency(key.getFactHandle(), activation, activation.getPropagationContext(), rule);
                                InternalFactHandle internalFactHandle = key.getFactHandle();
                                return internalFactHandle;
                            }
                            FactHandle factHandle = null;
                            return factHandle;
                        }
                    }
                    if (handle != null) {
                        InternalFactHandle internalFactHandle = handle;
                        return internalFactHandle;
                    }
                    handle = this.createHandle(object, typeConf);
                }
                if (dynamic || typeConf.isDynamic()) {
                    this.addPropertyChangeListener(object);
                }
                this.insert(handle, object, rule, activation, typeConf);
            }
            finally {
                this.lock.unlock();
                this.ruleBase.readUnlock();
            }
            InternalFactHandle internalFactHandle = handle;
            return internalFactHandle;
        }
        finally {
            this.wm.endOperation();
        }
    }

    public void insert(InternalFactHandle handle, Object object, Rule rule, Activation activation, ObjectTypeConf typeConf) {
        this.ruleBase.executeQueuedActions();
        this.wm.executeQueuedActions();
        if (activation != null) {
            activation.getPropagationContext().releaseResources();
        }
        PropagationContextImpl propagationContext = new PropagationContextImpl(this.wm.getNextPropagationIdCounter(), 0, rule, activation == null ? null : activation.getTuple(), handle, this.wm.agenda.getActiveActivations(), this.wm.agenda.getDormantActivations(), this.entryPoint);
        this.entryPointNode.assertObject(handle, propagationContext, typeConf, this.wm);
        propagationContext.evaluateActionQueue(this.wm);
        this.wm.workingMemoryEventSupport.fireObjectInserted(propagationContext, handle, object, this.wm);
        this.wm.executeQueuedActions();
        if (rule == null) {
            this.wm.getAgenda().unstageActivations();
        }
    }

    @Override
    public void update(org.drools.runtime.rule.FactHandle handle, Object object) throws FactException {
        this.update(handle, object, null, null);
    }

    @Override
    public void update(org.drools.runtime.rule.FactHandle factHandle, Object object, Rule rule, Activation activation) throws FactException {
        this.update((FactHandle)factHandle, object, rule, activation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(FactHandle factHandle, Object object, Rule rule, Activation activation) throws FactException {
        try {
            this.ruleBase.readLock();
            this.lock.lock();
            this.wm.startOperation();
            this.ruleBase.executeQueuedActions();
            InternalFactHandle handle = (InternalFactHandle)factHandle;
            Object originalObject = handle.getObject();
            if (handle.isDisconnected()) {
                handle = this.objectStore.reconnect(factHandle);
            }
            if (handle.getEntryPoint() != this) {
                throw new IllegalArgumentException("Invalid Entry Point. You updated the FactHandle on entry point '" + handle.getEntryPoint().getEntryPointId() + "' instead of '" + this.getEntryPointId() + "'");
            }
            ObjectTypeConf typeConf = this.typeConfReg.getObjectTypeConf(this.entryPoint, object);
            int status = -1;
            if (typeConf.isTMSEnabled()) {
                status = handle.getEqualityKey().getStatus();
            }
            if (handle.getId() == -1 || object == null || handle.isEvent() && ((EventFactHandle)handle).isExpired()) {
                return;
            }
            if (activation != null) {
                activation.getPropagationContext().releaseResources();
            }
            if (originalObject != object || !RuleBaseConfiguration.AssertBehaviour.IDENTITY.equals(this.ruleBase.getConfiguration().getAssertBehaviour())) {
                this.objectStore.removeHandle(handle);
                handle.setObject(object);
                this.objectStore.addHandle(handle, object);
            }
            if (typeConf.isTMSEnabled()) {
                EqualityKey key = handle.getEqualityKey();
                key.removeFactHandle(handle);
                TruthMaintenanceSystem tms = this.wm.getTruthMaintenanceSystem();
                if (key.isEmpty()) {
                    tms.remove(key);
                }
                if ((key = tms.get(object)) == null) {
                    key = new EqualityKey(handle, status);
                    tms.put(key);
                } else {
                    key.addFactHandle(handle);
                }
                handle.setEqualityKey(key);
            }
            this.handleFactory.increaseFactHandleRecency(handle);
            PropagationContextImpl propagationContext = new PropagationContextImpl(this.wm.getNextPropagationIdCounter(), 2, rule, activation == null ? null : activation.getTuple(), handle, this.wm.agenda.getActiveActivations(), this.wm.agenda.getDormantActivations(), this.entryPoint);
            this.entryPointNode.modifyObject(handle, propagationContext, typeConf, (InternalWorkingMemory)this.wm);
            propagationContext.evaluateActionQueue(this.wm);
            this.wm.workingMemoryEventSupport.fireObjectUpdated(propagationContext, factHandle, originalObject, object, this.wm);
            this.wm.executeQueuedActions();
            if (rule == null) {
                this.wm.getAgenda().unstageActivations();
            }
        }
        finally {
            this.wm.endOperation();
            this.lock.unlock();
            this.ruleBase.readUnlock();
        }
    }

    @Override
    public void retract(org.drools.runtime.rule.FactHandle handle) throws FactException {
        this.retract((FactHandle)handle, true, true, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retract(FactHandle factHandle, boolean removeLogical, boolean updateEqualsMap, Rule rule, Activation activation) throws FactException {
        if (factHandle == null) {
            throw new IllegalArgumentException("FactHandle cannot be null ");
        }
        try {
            this.ruleBase.readLock();
            this.lock.lock();
            this.wm.startOperation();
            this.ruleBase.executeQueuedActions();
            InternalFactHandle handle = (InternalFactHandle)factHandle;
            if (handle.getId() == -1) {
                return;
            }
            if (handle.isDisconnected()) {
                handle = this.objectStore.reconnect(handle);
            }
            if (handle.getEntryPoint() != this) {
                throw new IllegalArgumentException("Invalid Entry Point. You updated the FactHandle on entry point '" + handle.getEntryPoint().getEntryPointId() + "' instead of '" + this.getEntryPointId() + "'");
            }
            this.removePropertyChangeListener(handle);
            if (activation != null) {
                activation.getPropagationContext().releaseResources();
            }
            PropagationContextImpl propagationContext = new PropagationContextImpl(this.wm.getNextPropagationIdCounter(), 1, rule, activation == null ? null : activation.getTuple(), handle, this.wm.agenda.getActiveActivations(), this.wm.agenda.getDormantActivations(), this.entryPoint);
            Object object = handle.getObject();
            ObjectTypeConf typeConf = this.typeConfReg.getObjectTypeConf(this.entryPoint, object);
            this.entryPointNode.retractObject(handle, propagationContext, typeConf, this.wm);
            if (typeConf.isTMSEnabled()) {
                TruthMaintenanceSystem tms = this.wm.getTruthMaintenanceSystem();
                EqualityKey key = handle.getEqualityKey();
                if (key.getStatus() == 2) {
                    tms.removeLogicalDependencies(handle);
                }
                key.removeFactHandle(handle);
                handle.setEqualityKey(null);
                if (key.isEmpty()) {
                    tms.remove(key);
                }
            }
            propagationContext.evaluateActionQueue(this.wm);
            this.wm.workingMemoryEventSupport.fireObjectRetracted(propagationContext, handle, object, this.wm);
            this.objectStore.removeHandle(handle);
            this.handleFactory.destroyFactHandle(handle);
            this.wm.executeQueuedActions();
            if (rule == null) {
                this.wm.getAgenda().unstageActivations();
            }
        }
        finally {
            this.wm.endOperation();
            this.lock.unlock();
            this.ruleBase.readUnlock();
        }
    }

    protected void addPropertyChangeListener(Object object) {
        try {
            Method method = object.getClass().getMethod("addPropertyChangeListener", ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES);
            method.invoke(object, this.addRemovePropertyChangeListenerArgs);
        }
        catch (NoSuchMethodException e) {
            System.err.println("Warning: Method addPropertyChangeListener not found on the class " + object.getClass() + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object");
        }
        catch (IllegalArgumentException e) {
            System.err.println("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " does not take" + " a simple PropertyChangeListener argument" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object");
        }
        catch (IllegalAccessException e) {
            System.err.println("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " is not public" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object");
        }
        catch (InvocationTargetException e) {
            System.err.println("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " threw an InvocationTargetException" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object: " + e.getMessage());
        }
        catch (SecurityException e) {
            System.err.println("Warning: The SecurityManager controlling the class " + object.getClass() + " did not allow the lookup of a" + " addPropertyChangeListener method" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object: " + e.getMessage());
        }
    }

    protected void removePropertyChangeListener(FactHandle handle) {
        Object object = null;
        try {
            object = ((InternalFactHandle)handle).getObject();
            if (object != null) {
                Method mehod = object.getClass().getMethod("removePropertyChangeListener", ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES);
                mehod.invoke(object, this.addRemovePropertyChangeListenerArgs);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeDroolsException("Warning: The removePropertyChangeListener method on the class " + object.getClass() + " does not take a simple PropertyChangeListener argument so Drools will be unable to stop processing JavaBean" + " PropertyChangeEvents on the retracted Object");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeDroolsException("Warning: The removePropertyChangeListener method on the class " + object.getClass() + " is not public so Drools will be unable to stop processing JavaBean PropertyChangeEvents on the retracted Object");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeDroolsException("Warning: The removePropertyChangeL istener method on the class " + object.getClass() + " threw an InvocationTargetException so Drools will be unable to stop processing JavaBean" + " PropertyChangeEvents on the retracted Object: " + e.getMessage());
        }
        catch (SecurityException e) {
            throw new RuntimeDroolsException("Warning: The SecurityManager controlling the class " + object.getClass() + " did not allow the lookup of a removePropertyChangeListener method so Drools will be unable to stop processing JavaBean" + " PropertyChangeEvents on the retracted Object: " + e.getMessage());
        }
    }

    @Override
    public WorkingMemoryEntryPoint getWorkingMemoryEntryPoint(String name) {
        return this.wm.getWorkingMemoryEntryPoint(name);
    }

    @Override
    public ObjectTypeConfigurationRegistry getObjectTypeConfigurationRegistry() {
        return this.typeConfReg;
    }

    @Override
    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public FactHandle getFactHandle(Object object) {
        return this.objectStore.getHandleForObject(object);
    }

    @Override
    public EntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public InternalWorkingMemory getInternalWorkingMemory() {
        return this.wm;
    }

    @Override
    public FactHandle getFactHandleByIdentity(Object object) {
        return this.objectStore.getHandleForObjectIdentity(object);
    }

    public Object getObject(org.drools.runtime.rule.FactHandle factHandle) {
        return this.objectStore.getObjectForHandle(factHandle);
    }

    public <T extends org.drools.runtime.rule.FactHandle> Collection<T> getFactHandles() {
        return new StatefulKnowledgeSessionImpl.ObjectStoreWrapper(this.objectStore, null, 1);
    }

    public <T extends org.drools.runtime.rule.FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        return new StatefulKnowledgeSessionImpl.ObjectStoreWrapper(this.objectStore, filter, 1);
    }

    public Collection<Object> getObjects() {
        return new StatefulKnowledgeSessionImpl.ObjectStoreWrapper(this.objectStore, null, 0);
    }

    public Collection<Object> getObjects(ObjectFilter filter) {
        return new StatefulKnowledgeSessionImpl.ObjectStoreWrapper(this.objectStore, filter, 0);
    }

    public String getEntryPointId() {
        return this.entryPoint.getEntryPointId();
    }

    public long getFactCount() {
        return this.objectStore.size();
    }

    private InternalFactHandle createHandle(Object object, ObjectTypeConf typeConf) {
        InternalFactHandle handle = this.handleFactory.newFactHandle(object, typeConf, this.wm, this);
        this.objectStore.addHandle(handle, object);
        return handle;
    }

    private EqualityKey createEqualityKey(InternalFactHandle handle) {
        EqualityKey key = new EqualityKey(handle);
        handle.setEqualityKey(key);
        return key;
    }

    private void enableTMS(Object object, ObjectTypeConf conf) {
        Rete source = this.ruleBase.getRete();
        ClassObjectType cot = new ClassObjectType(object.getClass());
        Map<ObjectType, ObjectTypeNode> map = source.getObjectTypeNodes(EntryPoint.DEFAULT);
        ObjectTypeNode node = map.get(cot);
        ObjectHashSet memory = (ObjectHashSet)this.wm.getNodeMemory(node);
        Iterator it = memory.iterator();
        Object obj = it.next();
        while (obj != null) {
            ObjectHashSet.ObjectEntry holder = (ObjectHashSet.ObjectEntry)obj;
            InternalFactHandle handle = (InternalFactHandle)holder.getValue();
            if (handle != null) {
                EqualityKey key = this.createEqualityKey(handle);
                key.setStatus(1);
                this.wm.getTruthMaintenanceSystem().put(key);
            }
            obj = it.next();
        }
        conf.enableTMS();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object object = event.getSource();
        try {
            FactHandle handle = this.getFactHandle(object);
            if (handle == null) {
                throw new FactException("Update error: handle not found for object: " + object + ". Is it in the working memory?");
            }
            this.update(handle, object);
        }
        catch (FactException e) {
            throw new RuntimeDroolsException(e.getMessage());
        }
    }
}

