/*
 * Decompiled with CFR 0.152.
 */
package org.drools.marshalling.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.RuleBaseConfiguration;
import org.drools.SessionConfiguration;
import org.drools.common.InternalRuleBase;
import org.drools.concurrent.CommandExecutor;
import org.drools.concurrent.ExecutorService;
import org.drools.impl.InternalKnowledgeBase;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.marshalling.Marshaller;
import org.drools.marshalling.impl.InputMarshaller;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.marshalling.impl.MarshallingConfiguration;
import org.drools.marshalling.impl.ObjectMarshallingStrategyStore;
import org.drools.marshalling.impl.OutputMarshaller;
import org.drools.marshalling.impl.RuleBaseNodes;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooStatefulSession;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.spi.ExecutorServiceFactory;
import org.drools.spi.GlobalResolver;

public class DefaultMarshaller
implements Marshaller {
    KnowledgeBase kbase;
    GlobalResolver globalResolver;
    RuleBaseConfiguration ruleBaseConfig;
    MarshallingConfiguration marshallingConfig;
    ObjectMarshallingStrategyStore strategyStore;

    public DefaultMarshaller(KnowledgeBase kbase, MarshallingConfiguration marshallingConfig) {
        this.kbase = kbase;
        this.ruleBaseConfig = this.ruleBaseConfig != null ? this.ruleBaseConfig : RuleBaseConfiguration.getDefaultInstance();
        this.marshallingConfig = marshallingConfig;
        this.strategyStore = this.marshallingConfig.getObjectMarshallingStrategyStore();
    }

    public StatefulKnowledgeSession unmarshall(InputStream stream) throws IOException, ClassNotFoundException {
        return this.unmarshall(stream, null, null);
    }

    public StatefulKnowledgeSession unmarshall(InputStream stream, KnowledgeSessionConfiguration config, Environment environment) throws IOException, ClassNotFoundException {
        if (config == null) {
            config = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        }
        if (environment == null) {
            environment = KnowledgeBaseFactory.newEnvironment();
        }
        MarshallerReaderContext context = new MarshallerReaderContext(stream, (InternalRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase, RuleBaseNodes.getNodeMap((InternalRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase), this.strategyStore, this.marshallingConfig.isMarshallProcessInstances(), this.marshallingConfig.isMarshallWorkItems(), environment);
        int id = ((ReteooRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase).nextWorkingMemoryCounter();
        RuleBaseConfiguration conf = ((ReteooRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase).getConfiguration();
        ExecutorService executor = ExecutorServiceFactory.createExecutorService(conf.getExecutorService());
        ReteooStatefulSession session = InputMarshaller.readSession(context, id, executor, environment, (SessionConfiguration)config);
        executor.setCommandExecutor(new CommandExecutor(session));
        context.close();
        if (((SessionConfiguration)config).isKeepReference()) {
            ((ReteooRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase).addStatefulSession(session);
        }
        return (StatefulKnowledgeSession)session.getKnowledgeRuntime();
    }

    public void unmarshall(InputStream stream, StatefulKnowledgeSession ksession) throws IOException, ClassNotFoundException {
        MarshallerReaderContext context = new MarshallerReaderContext(stream, (InternalRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase, RuleBaseNodes.getNodeMap((InternalRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase), this.strategyStore, this.marshallingConfig.isMarshallProcessInstances(), this.marshallingConfig.isMarshallWorkItems(), ksession.getEnvironment());
        InputMarshaller.readSession((ReteooStatefulSession)((StatefulKnowledgeSessionImpl)ksession).session, context);
        context.close();
    }

    public void marshall(OutputStream stream, StatefulKnowledgeSession ksession) throws IOException {
        this.marshall(stream, ksession, ksession.getSessionClock().getCurrentTime());
    }

    public void marshall(OutputStream stream, StatefulKnowledgeSession ksession, long clockTime) throws IOException {
        MarshallerWriteContext context = new MarshallerWriteContext(stream, (InternalRuleBase)((InternalKnowledgeBase)this.kbase).getRuleBase(), ((StatefulKnowledgeSessionImpl)ksession).session, RuleBaseNodes.getNodeMap((InternalRuleBase)((InternalKnowledgeBase)this.kbase).getRuleBase()), this.strategyStore, this.marshallingConfig.isMarshallProcessInstances(), this.marshallingConfig.isMarshallWorkItems(), ksession.getEnvironment());
        context.clockTime = clockTime;
        OutputMarshaller.writeSession(context);
        context.close();
    }

    public MarshallingConfiguration getMarshallingConfiguration() {
        return this.marshallingConfig;
    }
}

